/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileTypeBox
extends Box {
    private static String[] elementNames = new String[]{"Brand", "MinorVersion", "CompatibilityList"};
    private int brand;
    private int minorVersion;
    private int[] compatibility;

    public static String[] getElementNames() {
        return elementNames;
    }

    public FileTypeBox(int n, int n2, int[] nArray) {
        super(16 + (nArray == null ? 0 : nArray.length << 2), 1718909296, null);
        this.brand = n;
        this.minorVersion = n2;
        this.compatibility = nArray;
    }

    public FileTypeBox(byte[] byArray) {
        super(8 + byArray.length, 1718909296, byArray);
    }

    public FileTypeBox(Node node) throws IIOInvalidTreeException {
        super(node);
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            String string = node2.getNodeName();
            if ("Brand".equals(string)) {
                this.brand = Box.getIntElementValue(node2);
            }
            if ("MinorVersion".equals(string)) {
                this.minorVersion = Box.getIntElementValue(node2);
            }
            if ("CompatibilityList".equals(string)) {
                this.compatibility = Box.getIntArrayElementValue(node2);
            }
            ++n;
        }
    }

    public int getBrand() {
        return this.brand;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int[] getCompatibilityList() {
        return this.compatibility;
    }

    @Override
    public IIOMetadataNode getNativeNode() {
        return this.getNativeNodeForSimpleBox();
    }

    @Override
    protected void parse(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        this.brand = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        this.minorVersion = (byArray[4] & 0xFF) << 24 | (byArray[5] & 0xFF) << 16 | (byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF;
        int n = (byArray.length - 8) / 4;
        if (n > 0) {
            this.compatibility = new int[n];
            int n2 = 0;
            int n3 = 8;
            while (n2 < n) {
                this.compatibility[n2] = (byArray[n3] & 0xFF) << 24 | (byArray[n3 + 1] & 0xFF) << 16 | (byArray[n3 + 2] & 0xFF) << 8 | byArray[n3 + 3] & 0xFF;
                ++n2;
                n3 += 4;
            }
        }
    }

    @Override
    protected void compose() {
        if (this.data != null) {
            return;
        }
        this.data = new byte[8 + (this.compatibility != null ? this.compatibility.length << 2 : 0)];
        FileTypeBox.copyInt(this.data, 0, this.brand);
        FileTypeBox.copyInt(this.data, 4, this.minorVersion);
        if (this.compatibility != null) {
            int n = 0;
            int n2 = 8;
            while (n < this.compatibility.length) {
                FileTypeBox.copyInt(this.data, n2, this.compatibility[n]);
                ++n;
                n2 += 4;
            }
        }
    }
}

