/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComponentMappingBox
extends Box {
    private short[] components;
    private byte[] type;
    private byte[] map;

    public ComponentMappingBox(byte[] byArray) {
        super(8 + byArray.length, 1668112752, byArray);
    }

    public ComponentMappingBox(short[] sArray, byte[] byArray, byte[] byArray2) {
        super(8 + (sArray.length << 2), 1668112752, null);
        this.components = sArray;
        this.type = byArray;
        this.map = byArray2;
    }

    public ComponentMappingBox(Node node) throws IIOInvalidTreeException {
        super(node);
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength() / 3;
        this.components = new short[n];
        this.type = new byte[n];
        this.map = new byte[n];
        n *= 3;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Node node2 = nodeList.item(n3);
            String string = node2.getNodeName();
            if ("Component".equals(string)) {
                this.components[n2] = Box.getShortElementValue(node2);
            }
            if ("ComponentType".equals(string)) {
                this.type[n2] = Box.getByteElementValue(node2);
            }
            if ("ComponentAssociation".equals(string)) {
                this.map[n2++] = Box.getByteElementValue(node2);
            }
            ++n3;
        }
    }

    @Override
    protected void parse(byte[] byArray) {
        int n = byArray.length / 4;
        this.components = new short[n];
        this.type = new byte[n];
        this.map = new byte[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            this.components[n2] = (short)((byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF);
            this.type[n2] = byArray[n3++];
            this.map[n2] = byArray[n3++];
            ++n2;
        }
    }

    @Override
    public IIOMetadataNode getNativeNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(Box.getName(this.getType()));
        this.setDefaultAttributes(iIOMetadataNode);
        int n = 0;
        while (n < this.components.length) {
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Component");
            new Short(this.components[n]);
            iIOMetadataNode2.setUserObject(new Short(this.components[n]));
            iIOMetadataNode2.setNodeValue("" + this.components[n]);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            iIOMetadataNode2 = new IIOMetadataNode("ComponentType");
            iIOMetadataNode2.setUserObject(new Byte(this.type[n]));
            iIOMetadataNode2.setNodeValue("" + this.type[n]);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            iIOMetadataNode2 = new IIOMetadataNode("ComponentAssociation");
            iIOMetadataNode2.setUserObject(new Byte(this.map[n]));
            iIOMetadataNode2.setNodeValue("" + this.map[n]);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            ++n;
        }
        return iIOMetadataNode;
    }

    public short[] getComponent() {
        return this.components;
    }

    public byte[] getComponentType() {
        return this.type;
    }

    public byte[] getComponentAssociation() {
        return this.map;
    }

    @Override
    protected void compose() {
        if (this.data != null) {
            return;
        }
        this.data = new byte[this.type.length << 2];
        int n = 0;
        int n2 = 0;
        while (n < this.type.length) {
            this.data[n2++] = (byte)(this.components[n] >> 8);
            this.data[n2++] = (byte)(this.components[n] & 0xFF);
            this.data[n2++] = this.type[n];
            this.data[n2++] = this.map[n];
            ++n;
        }
    }
}

