/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import java.awt.image.ColorModel;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChannelDefinitionBox
extends Box {
    private short num;
    private short[] channels;
    private short[] types;
    private short[] associations;

    private static int computeLength(ColorModel colorModel) {
        int n = colorModel.getComponentSize().length - 1;
        return 10 + (colorModel.isAlphaPremultiplied() ? n * 18 : n * 12);
    }

    public static void fillBasedOnBands(int n, boolean bl, short[] sArray, short[] sArray2, short[] sArray3) {
        int n2;
        int n3 = n * (bl ? 3 : 2);
        if (bl) {
            n2 = n * 2;
            while (n2 < n3) {
                sArray[n2] = (short)(n2 - n * 2);
                sArray2[n2] = 2;
                sArray3[n2] = (short)(n2 + 1 - n * 2);
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < n) {
            int n4 = n2 + n;
            sArray[n2] = (short)n2;
            sArray2[n2] = 0;
            sArray3[n4] = sArray3[n2] = (short)(n2 + 1);
            sArray[n4] = (short)n;
            sArray2[n4] = 1;
            ++n2;
        }
    }

    public ChannelDefinitionBox(ColorModel colorModel) {
        super(ChannelDefinitionBox.computeLength(colorModel), 1667523942, null);
        short s = (short)(colorModel.getComponentSize().length - 1);
        this.num = (short)(s * (colorModel.isAlphaPremultiplied() ? 3 : 2));
        this.channels = new short[this.num];
        this.types = new short[this.num];
        this.associations = new short[this.num];
        ChannelDefinitionBox.fillBasedOnBands(s, colorModel.isAlphaPremultiplied(), this.channels, this.types, this.associations);
    }

    public ChannelDefinitionBox(byte[] byArray) {
        super(8 + byArray.length, 1667523942, byArray);
    }

    public ChannelDefinitionBox(short[] sArray, short[] sArray2, short[] sArray3) {
        super(10 + sArray.length * 6, 1667523942, null);
        this.num = (short)sArray.length;
        this.channels = sArray;
        this.types = sArray2;
        this.associations = sArray3;
    }

    public ChannelDefinitionBox(Node node) throws IIOInvalidTreeException {
        super(node);
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            Node node2 = nodeList.item(n2);
            String string = node2.getNodeName();
            if ("NumberOfDefinition".equals(string)) {
                this.num = Box.getShortElementValue(node2);
            }
            if ("Definitions".equals(string)) {
                this.channels = new short[this.num];
                this.types = new short[this.num];
                this.associations = new short[this.num];
                NodeList nodeList2 = node2.getChildNodes();
                int n3 = 0;
                while (n3 < nodeList2.getLength()) {
                    node2 = nodeList2.item(n3);
                    string = node2.getNodeName();
                    if ("ChannelNumber".equals(string)) {
                        this.channels[n] = Box.getShortElementValue(node2);
                    }
                    if ("ChannelType".equals(string)) {
                        this.types[n] = Box.getShortElementValue(node2);
                    }
                    if ("Association".equals(string)) {
                        this.associations[n++] = Box.getShortElementValue(node2);
                    }
                    ++n3;
                }
            }
            ++n2;
        }
    }

    @Override
    protected void parse(byte[] byArray) {
        this.num = (short)(byArray[0] << 8 | byArray[1]);
        this.channels = new short[this.num];
        this.types = new short[this.num];
        this.associations = new short[this.num];
        int n = 0;
        int n2 = 2;
        while (n < this.num) {
            this.channels[n] = (short)(((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF));
            this.types[n] = (short)(((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF));
            this.associations[n] = (short)(((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF));
            ++n;
        }
    }

    public short[] getChannel() {
        return this.channels;
    }

    public short[] getTypes() {
        return this.types;
    }

    public short[] getAssociation() {
        return this.associations;
    }

    @Override
    public IIOMetadataNode getNativeNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(Box.getName(this.getType()));
        this.setDefaultAttributes(iIOMetadataNode);
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("NumberOfDefinition");
        iIOMetadataNode2.setUserObject(new Short(this.num));
        iIOMetadataNode2.setNodeValue("" + this.num);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("Definitions");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        int n = 0;
        while (n < this.num) {
            IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("ChannelNumber");
            iIOMetadataNode3.setUserObject(new Short(this.channels[n]));
            iIOMetadataNode3.setNodeValue("" + this.channels[n]);
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
            iIOMetadataNode3 = new IIOMetadataNode("ChannelType");
            iIOMetadataNode3.setUserObject(new Short(this.types[n]));
            iIOMetadataNode3.setNodeValue("" + this.types[n]);
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
            iIOMetadataNode3 = new IIOMetadataNode("Association");
            iIOMetadataNode3.setUserObject(new Short(this.associations[n]));
            iIOMetadataNode3.setNodeValue("" + this.associations[n]);
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
            ++n;
        }
        return iIOMetadataNode;
    }

    @Override
    protected void compose() {
        if (this.data != null) {
            return;
        }
        int n = this.num * 6 + 2;
        this.data = new byte[n];
        this.data[0] = (byte)(this.num >> 8);
        this.data[1] = (byte)(this.num & 0xFF);
        int n2 = 0;
        int n3 = 2;
        while (n2 < this.num) {
            this.data[n3++] = (byte)(this.channels[n2] >> 8);
            this.data[n3++] = (byte)(this.channels[n2] & 0xFF);
            this.data[n3++] = (byte)(this.types[n2] >> 8);
            this.data[n3++] = (byte)(this.types[n2] & 0xFF);
            this.data[n3++] = (byte)(this.associations[n2] >> 8);
            this.data[n3++] = (byte)(this.associations[n2] & 0xFF);
            ++n2;
        }
    }
}

