/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.gif;

import com.sun.media.imageioimpl.plugins.gif.GIFStreamMetadata;
import javax.imageio.metadata.IIOInvalidTreeException;
import org.w3c.dom.Node;

class GIFWritableStreamMetadata
extends GIFStreamMetadata {
    static final String NATIVE_FORMAT_NAME = "javax_imageio_gif_stream_1.0";

    public GIFWritableStreamMetadata() {
        super(true, NATIVE_FORMAT_NAME, "com.sun.media.imageioimpl.plugins.gif.GIFStreamMetadataFormat", null, null);
        this.reset();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void mergeTree(String string, Node node) throws IIOInvalidTreeException {
        if (string.equals(NATIVE_FORMAT_NAME)) {
            if (node == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeNativeTree(node);
        } else if (string.equals("javax_imageio_1.0")) {
            if (node == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeStandardTree(node);
        } else {
            throw new IllegalArgumentException("Not a recognized format!");
        }
    }

    @Override
    public void reset() {
        this.version = null;
        this.logicalScreenWidth = -1;
        this.logicalScreenHeight = -1;
        this.colorResolution = -1;
        this.pixelAspectRatio = 0;
        this.backgroundColorIndex = 0;
        this.sortFlag = false;
        this.globalColorTable = null;
    }

    @Override
    protected void mergeNativeTree(Node node) throws IIOInvalidTreeException {
        Node node2 = node;
        if (!node2.getNodeName().equals(NATIVE_FORMAT_NAME)) {
            GIFWritableStreamMetadata.fatal(node2, "Root must be javax_imageio_gif_stream_1.0");
        }
        node2 = node2.getFirstChild();
        while (node2 != null) {
            String string = node2.getNodeName();
            if (string.equals("Version")) {
                this.version = GIFWritableStreamMetadata.getStringAttribute(node2, "value", null, true, versionStrings);
            } else if (string.equals("LogicalScreenDescriptor")) {
                this.logicalScreenWidth = GIFWritableStreamMetadata.getIntAttribute(node2, "logicalScreenWidth", -1, true, true, 1, 65535);
                this.logicalScreenHeight = GIFWritableStreamMetadata.getIntAttribute(node2, "logicalScreenHeight", -1, true, true, 1, 65535);
                this.colorResolution = GIFWritableStreamMetadata.getIntAttribute(node2, "colorResolution", -1, true, true, 1, 8);
                this.pixelAspectRatio = GIFWritableStreamMetadata.getIntAttribute(node2, "pixelAspectRatio", 0, true, true, 0, 255);
            } else if (string.equals("GlobalColorTable")) {
                int n = GIFWritableStreamMetadata.getIntAttribute(node2, "sizeOfGlobalColorTable", true, 2, 256);
                if (n != 2 && n != 4 && n != 8 && n != 16 && n != 32 && n != 64 && n != 128 && n != 256) {
                    GIFWritableStreamMetadata.fatal(node2, "Bad value for GlobalColorTable attribute sizeOfGlobalColorTable!");
                }
                this.backgroundColorIndex = GIFWritableStreamMetadata.getIntAttribute(node2, "backgroundColorIndex", 0, true, true, 0, 255);
                this.sortFlag = GIFWritableStreamMetadata.getBooleanAttribute(node2, "sortFlag", false, true);
                this.globalColorTable = this.getColorTable(node2, "ColorTableEntry", true, n);
            } else {
                GIFWritableStreamMetadata.fatal(node2, "Unknown child of root node!");
            }
            node2 = node2.getNextSibling();
        }
    }

    @Override
    protected void mergeStandardTree(Node node) throws IIOInvalidTreeException {
        Node node2 = node;
        if (!node2.getNodeName().equals("javax_imageio_1.0")) {
            GIFWritableStreamMetadata.fatal(node2, "Root must be javax_imageio_1.0");
        }
        node2 = node2.getFirstChild();
        while (node2 != null) {
            block27: {
                int n;
                String string;
                Node node3;
                String string2 = node2.getNodeName();
                if (string2.equals("Chroma")) {
                    node3 = node2.getFirstChild();
                    while (node3 != null) {
                        string = node3.getNodeName();
                        if (string.equals("Palette")) {
                            this.globalColorTable = this.getColorTable(node3, "PaletteEntry", false, -1);
                        } else if (string.equals("BackgroundIndex")) {
                            this.backgroundColorIndex = GIFWritableStreamMetadata.getIntAttribute(node3, "value", -1, true, true, 0, 255);
                        }
                        node3 = node3.getNextSibling();
                    }
                } else if (string2.equals("Data")) {
                    node3 = node2.getFirstChild();
                    while (node3 != null) {
                        string = node3.getNodeName();
                        if (string.equals("BitsPerSample")) {
                            this.colorResolution = GIFWritableStreamMetadata.getIntAttribute(node3, "value", -1, true, true, 1, 8);
                            break;
                        }
                        node3 = node3.getNextSibling();
                    }
                } else if (string2.equals("Dimension")) {
                    node3 = node2.getFirstChild();
                    while (node3 != null) {
                        string = node3.getNodeName();
                        if (string.equals("PixelAspectRatio")) {
                            float f = GIFWritableStreamMetadata.getFloatAttribute(node3, "value");
                            if (f == 1.0f) {
                                this.pixelAspectRatio = 0;
                            } else {
                                n = (int)(f * 64.0f - 15.0f);
                                this.pixelAspectRatio = Math.max(Math.min(n, 255), 0);
                            }
                        } else if (string.equals("HorizontalScreenSize")) {
                            this.logicalScreenWidth = GIFWritableStreamMetadata.getIntAttribute(node3, "value", -1, true, true, 1, 65535);
                        } else if (string.equals("VerticalScreenSize")) {
                            this.logicalScreenHeight = GIFWritableStreamMetadata.getIntAttribute(node3, "value", -1, true, true, 1, 65535);
                        }
                        node3 = node3.getNextSibling();
                    }
                } else if (string2.equals("Document")) {
                    node3 = node2.getFirstChild();
                    while (node3 != null) {
                        string = node3.getNodeName();
                        if (string.equals("FormatVersion")) {
                            String string3 = GIFWritableStreamMetadata.getStringAttribute(node3, "value", null, true, null);
                            n = 0;
                            while (n < versionStrings.length) {
                                if (string3.equals(versionStrings[n])) {
                                    this.version = string3;
                                    break block27;
                                }
                                ++n;
                            }
                            break;
                        }
                        node3 = node3.getNextSibling();
                    }
                }
            }
            node2 = node2.getNextSibling();
        }
    }

    @Override
    public void setFromTree(String string, Node node) throws IIOInvalidTreeException {
        this.reset();
        this.mergeTree(string, node);
    }
}

