/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.gif;

import com.sun.media.imageioimpl.plugins.gif.GIFImageMetadata;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

class GIFWritableImageMetadata
extends GIFImageMetadata {
    static final String NATIVE_FORMAT_NAME = "javax_imageio_gif_image_1.0";

    GIFWritableImageMetadata() {
        super(true, NATIVE_FORMAT_NAME, "com.sun.media.imageioimpl.plugins.gif.GIFImageMetadataFormat", null, null);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void reset() {
        this.imageLeftPosition = 0;
        this.imageTopPosition = 0;
        this.imageWidth = 0;
        this.imageHeight = 0;
        this.interlaceFlag = false;
        this.sortFlag = false;
        this.localColorTable = null;
        this.disposalMethod = 0;
        this.userInputFlag = false;
        this.transparentColorFlag = false;
        this.delayTime = 0;
        this.transparentColorIndex = 0;
        this.hasPlainTextExtension = false;
        this.textGridLeft = 0;
        this.textGridTop = 0;
        this.textGridWidth = 0;
        this.textGridHeight = 0;
        this.characterCellWidth = 0;
        this.characterCellHeight = 0;
        this.textForegroundColor = 0;
        this.textBackgroundColor = 0;
        this.text = null;
        this.applicationIDs = null;
        this.authenticationCodes = null;
        this.applicationData = null;
        this.comments = null;
    }

    private byte[] fromISO8859(String string) {
        try {
            return string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String("").getBytes();
        }
    }

    @Override
    protected void mergeNativeTree(Node node) throws IIOInvalidTreeException {
        Node node2 = node;
        if (!node2.getNodeName().equals(NATIVE_FORMAT_NAME)) {
            GIFWritableImageMetadata.fatal(node2, "Root must be javax_imageio_gif_image_1.0");
        }
        node2 = node2.getFirstChild();
        while (node2 != null) {
            String string;
            String string2 = node2.getNodeName();
            if (string2.equals("ImageDescriptor")) {
                this.imageLeftPosition = GIFWritableImageMetadata.getIntAttribute(node2, "imageLeftPosition", -1, true, true, 0, 65535);
                this.imageTopPosition = GIFWritableImageMetadata.getIntAttribute(node2, "imageTopPosition", -1, true, true, 0, 65535);
                this.imageWidth = GIFWritableImageMetadata.getIntAttribute(node2, "imageWidth", -1, true, true, 1, 65535);
                this.imageHeight = GIFWritableImageMetadata.getIntAttribute(node2, "imageHeight", -1, true, true, 1, 65535);
                this.interlaceFlag = GIFWritableImageMetadata.getBooleanAttribute(node2, "interlaceFlag", false, true);
            } else if (string2.equals("LocalColorTable")) {
                int n = GIFWritableImageMetadata.getIntAttribute(node2, "sizeOfLocalColorTable", true, 2, 256);
                if (n != 2 && n != 4 && n != 8 && n != 16 && n != 32 && n != 64 && n != 128 && n != 256) {
                    GIFWritableImageMetadata.fatal(node2, "Bad value for LocalColorTable attribute sizeOfLocalColorTable!");
                }
                this.sortFlag = GIFWritableImageMetadata.getBooleanAttribute(node2, "sortFlag", false, true);
                this.localColorTable = this.getColorTable(node2, "ColorTableEntry", true, n);
            } else if (string2.equals("GraphicControlExtension")) {
                String string3 = GIFWritableImageMetadata.getStringAttribute(node2, "disposalMethod", null, true, disposalMethodNames);
                this.disposalMethod = 0;
                while (!string3.equals(disposalMethodNames[this.disposalMethod])) {
                    ++this.disposalMethod;
                }
                this.userInputFlag = GIFWritableImageMetadata.getBooleanAttribute(node2, "userInputFlag", false, true);
                this.transparentColorFlag = GIFWritableImageMetadata.getBooleanAttribute(node2, "transparentColorFlag", false, true);
                this.delayTime = GIFWritableImageMetadata.getIntAttribute(node2, "delayTime", -1, true, true, 0, 65535);
                this.transparentColorIndex = GIFWritableImageMetadata.getIntAttribute(node2, "transparentColorIndex", -1, true, true, 0, 65535);
            } else if (string2.equals("PlainTextExtension")) {
                this.hasPlainTextExtension = true;
                this.textGridLeft = GIFWritableImageMetadata.getIntAttribute(node2, "textGridLeft", -1, true, true, 0, 65535);
                this.textGridTop = GIFWritableImageMetadata.getIntAttribute(node2, "textGridTop", -1, true, true, 0, 65535);
                this.textGridWidth = GIFWritableImageMetadata.getIntAttribute(node2, "textGridWidth", -1, true, true, 1, 65535);
                this.textGridHeight = GIFWritableImageMetadata.getIntAttribute(node2, "textGridHeight", -1, true, true, 1, 65535);
                this.characterCellWidth = GIFWritableImageMetadata.getIntAttribute(node2, "characterCellWidth", -1, true, true, 1, 65535);
                this.characterCellHeight = GIFWritableImageMetadata.getIntAttribute(node2, "characterCellHeight", -1, true, true, 1, 65535);
                this.textForegroundColor = GIFWritableImageMetadata.getIntAttribute(node2, "textForegroundColor", -1, true, true, 0, 255);
                this.textBackgroundColor = GIFWritableImageMetadata.getIntAttribute(node2, "textBackgroundColor", -1, true, true, 0, 255);
                String string4 = GIFWritableImageMetadata.getStringAttribute(node2, "text", "", false, null);
                this.text = this.fromISO8859(string4);
            } else if (string2.equals("ApplicationExtensions")) {
                IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)node2.getFirstChild();
                if (!iIOMetadataNode.getNodeName().equals("ApplicationExtension")) {
                    GIFWritableImageMetadata.fatal(node2, "Only a ApplicationExtension may be a child of a ApplicationExtensions!");
                }
                string = GIFWritableImageMetadata.getStringAttribute(iIOMetadataNode, "applicationID", null, true, null);
                String string5 = GIFWritableImageMetadata.getStringAttribute(iIOMetadataNode, "authenticationCode", null, true, null);
                Object object = iIOMetadataNode.getUserObject();
                if (object == null || !(object instanceof byte[])) {
                    GIFWritableImageMetadata.fatal(iIOMetadataNode, "Bad user object in ApplicationExtension!");
                }
                if (this.applicationIDs == null) {
                    this.applicationIDs = new ArrayList();
                    this.authenticationCodes = new ArrayList();
                    this.applicationData = new ArrayList();
                }
                this.applicationIDs.add(this.fromISO8859(string));
                this.authenticationCodes.add(this.fromISO8859(string5));
                this.applicationData.add(object);
            } else if (string2.equals("CommentExtensions")) {
                Node node3 = node2.getFirstChild();
                if (node3 != null) {
                    while (node3 != null) {
                        if (!node3.getNodeName().equals("CommentExtension")) {
                            GIFWritableImageMetadata.fatal(node2, "Only a CommentExtension may be a child of a CommentExtensions!");
                        }
                        if (this.comments == null) {
                            this.comments = new ArrayList();
                        }
                        string = GIFWritableImageMetadata.getStringAttribute(node3, "value", null, true, null);
                        this.comments.add(this.fromISO8859(string));
                        node3 = node3.getNextSibling();
                    }
                }
            } else {
                GIFWritableImageMetadata.fatal(node2, "Unknown child of root node!");
            }
            node2 = node2.getNextSibling();
        }
    }

    @Override
    protected void mergeStandardTree(Node node) throws IIOInvalidTreeException {
        Node node2 = node;
        if (!node2.getNodeName().equals("javax_imageio_1.0")) {
            GIFWritableImageMetadata.fatal(node2, "Root must be javax_imageio_1.0");
        }
        node2 = node2.getFirstChild();
        while (node2 != null) {
            String string;
            Node node3;
            String string2 = node2.getNodeName();
            if (string2.equals("Chroma")) {
                node3 = node2.getFirstChild();
                while (node3 != null) {
                    string = node3.getNodeName();
                    if (string.equals("Palette")) {
                        this.localColorTable = this.getColorTable(node3, "PaletteEntry", false, -1);
                        break;
                    }
                    node3 = node3.getNextSibling();
                }
            } else if (string2.equals("Compression")) {
                node3 = node2.getFirstChild();
                while (node3 != null) {
                    string = node3.getNodeName();
                    if (string.equals("NumProgressiveScans")) {
                        int n = GIFWritableImageMetadata.getIntAttribute(node3, "value", 4, false, true, 1, Integer.MAX_VALUE);
                        if (n <= 1) break;
                        this.interlaceFlag = true;
                        break;
                    }
                    node3 = node3.getNextSibling();
                }
            } else if (string2.equals("Dimension")) {
                node3 = node2.getFirstChild();
                while (node3 != null) {
                    string = node3.getNodeName();
                    if (string.equals("HorizontalPixelOffset")) {
                        this.imageLeftPosition = GIFWritableImageMetadata.getIntAttribute(node3, "value", -1, true, true, 0, 65535);
                    } else if (string.equals("VerticalPixelOffset")) {
                        this.imageTopPosition = GIFWritableImageMetadata.getIntAttribute(node3, "value", -1, true, true, 0, 65535);
                    }
                    node3 = node3.getNextSibling();
                }
            } else if (string2.equals("Text")) {
                node3 = node2.getFirstChild();
                while (node3 != null) {
                    string = node3.getNodeName();
                    if (string.equals("TextEntry") && GIFWritableImageMetadata.getAttribute(node3, "compression", "none", false).equals("none") && Charset.isSupported(GIFWritableImageMetadata.getAttribute(node3, "encoding", "ISO-8859-1", false))) {
                        String string3 = GIFWritableImageMetadata.getAttribute(node3, "value");
                        byte[] byArray = this.fromISO8859(string3);
                        if (this.comments == null) {
                            this.comments = new ArrayList();
                        }
                        this.comments.add(byArray);
                    }
                    node3 = node3.getNextSibling();
                }
            } else if (string2.equals("Transparency")) {
                node3 = node2.getFirstChild();
                while (node3 != null) {
                    string = node3.getNodeName();
                    if (string.equals("TransparentIndex")) {
                        this.transparentColorIndex = GIFWritableImageMetadata.getIntAttribute(node3, "value", -1, true, true, 0, 255);
                        this.transparentColorFlag = true;
                        break;
                    }
                    node3 = node3.getNextSibling();
                }
            }
            node2 = node2.getNextSibling();
        }
    }

    @Override
    public void setFromTree(String string, Node node) throws IIOInvalidTreeException {
        this.reset();
        this.mergeTree(string, node);
    }
}

