/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.gif;

import com.sun.media.imageioimpl.plugins.gif.GIFMetadata;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class GIFStreamMetadata
extends GIFMetadata {
    static final String nativeMetadataFormatName = "javax_imageio_gif_stream_1.0";
    public static final String[] versionStrings = new String[]{"87a", "89a"};
    public String version;
    public int logicalScreenWidth;
    public int logicalScreenHeight;
    public int colorResolution;
    public int pixelAspectRatio;
    public int backgroundColorIndex;
    public boolean sortFlag;
    public static final String[] colorTableSizes = new String[]{"2", "4", "8", "16", "32", "64", "128", "256"};
    public byte[] globalColorTable = null;

    protected GIFStreamMetadata(boolean bl, String string, String string2, String[] stringArray, String[] stringArray2) {
        super(bl, string, string2, stringArray, stringArray2);
    }

    public GIFStreamMetadata() {
        this(true, nativeMetadataFormatName, "com.sun.media.imageioimpl.plugins.gif.GIFStreamMetadataFormat", null, null);
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Node getAsTree(String string) {
        if (string.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (string.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    private Node getNativeTree() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(nativeMetadataFormatName);
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Version");
        iIOMetadataNode2.setAttribute("value", this.version);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("LogicalScreenDescriptor");
        iIOMetadataNode2.setAttribute("logicalScreenWidth", this.logicalScreenWidth == -1 ? "" : Integer.toString(this.logicalScreenWidth));
        iIOMetadataNode2.setAttribute("logicalScreenHeight", this.logicalScreenHeight == -1 ? "" : Integer.toString(this.logicalScreenHeight));
        iIOMetadataNode2.setAttribute("colorResolution", this.colorResolution == -1 ? "" : Integer.toString(this.colorResolution));
        iIOMetadataNode2.setAttribute("pixelAspectRatio", Integer.toString(this.pixelAspectRatio));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        if (this.globalColorTable != null) {
            iIOMetadataNode2 = new IIOMetadataNode("GlobalColorTable");
            int n = this.globalColorTable.length / 3;
            iIOMetadataNode2.setAttribute("sizeOfGlobalColorTable", Integer.toString(n));
            iIOMetadataNode2.setAttribute("backgroundColorIndex", Integer.toString(this.backgroundColorIndex));
            iIOMetadataNode2.setAttribute("sortFlag", this.sortFlag ? "TRUE" : "FALSE");
            int n2 = 0;
            while (n2 < n) {
                IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("ColorTableEntry");
                iIOMetadataNode3.setAttribute("index", Integer.toString(n2));
                int n3 = this.globalColorTable[3 * n2] & 0xFF;
                int n4 = this.globalColorTable[3 * n2 + 1] & 0xFF;
                int n5 = this.globalColorTable[3 * n2 + 2] & 0xFF;
                iIOMetadataNode3.setAttribute("red", Integer.toString(n3));
                iIOMetadataNode3.setAttribute("green", Integer.toString(n4));
                iIOMetadataNode3.setAttribute("blue", Integer.toString(n5));
                iIOMetadataNode2.appendChild(iIOMetadataNode3);
                ++n2;
            }
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    @Override
    public IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("ColorSpaceType");
        iIOMetadataNode2.setAttribute("name", "RGB");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("BlackIsZero");
        iIOMetadataNode2.setAttribute("value", "TRUE");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        if (this.globalColorTable != null) {
            iIOMetadataNode2 = new IIOMetadataNode("Palette");
            int n = this.globalColorTable.length / 3;
            int n2 = 0;
            while (n2 < n) {
                IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("PaletteEntry");
                iIOMetadataNode3.setAttribute("index", Integer.toString(n2));
                iIOMetadataNode3.setAttribute("red", Integer.toString(this.globalColorTable[3 * n2] & 0xFF));
                iIOMetadataNode3.setAttribute("green", Integer.toString(this.globalColorTable[3 * n2 + 1] & 0xFF));
                iIOMetadataNode3.setAttribute("blue", Integer.toString(this.globalColorTable[3 * n2 + 2] & 0xFF));
                iIOMetadataNode2.appendChild(iIOMetadataNode3);
                ++n2;
            }
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            iIOMetadataNode2 = new IIOMetadataNode("BackgroundIndex");
            iIOMetadataNode2.setAttribute("value", Integer.toString(this.backgroundColorIndex));
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    @Override
    public IIOMetadataNode getStandardCompressionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Compression");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("CompressionTypeName");
        iIOMetadataNode2.setAttribute("value", "lzw");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("Lossless");
        iIOMetadataNode2.setAttribute("value", "true");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    @Override
    public IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Data");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("SampleFormat");
        iIOMetadataNode2.setAttribute("value", "Index");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("BitsPerSample");
        iIOMetadataNode2.setAttribute("value", this.colorResolution == -1 ? "" : Integer.toString(this.colorResolution));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    @Override
    public IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("PixelAspectRatio");
        float f = 1.0f;
        if (this.pixelAspectRatio != 0) {
            f = (float)(this.pixelAspectRatio + 15) / 64.0f;
        }
        iIOMetadataNode2.setAttribute("value", Float.toString(f));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("ImageOrientation");
        iIOMetadataNode2.setAttribute("value", "Normal");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("HorizontalScreenSize");
        iIOMetadataNode2.setAttribute("value", this.logicalScreenWidth == -1 ? "" : Integer.toString(this.logicalScreenWidth));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("VerticalScreenSize");
        iIOMetadataNode2.setAttribute("value", this.logicalScreenHeight == -1 ? "" : Integer.toString(this.logicalScreenHeight));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    @Override
    public IIOMetadataNode getStandardDocumentNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Document");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("FormatVersion");
        iIOMetadataNode2.setAttribute("value", this.version);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    @Override
    public IIOMetadataNode getStandardTextNode() {
        return null;
    }

    @Override
    public IIOMetadataNode getStandardTransparencyNode() {
        return null;
    }

    @Override
    public void setFromTree(String string, Node node) throws IIOInvalidTreeException {
        throw new IllegalStateException("Metadata is read-only!");
    }

    @Override
    protected void mergeNativeTree(Node node) throws IIOInvalidTreeException {
        throw new IllegalStateException("Metadata is read-only!");
    }

    @Override
    protected void mergeStandardTree(Node node) throws IIOInvalidTreeException {
        throw new IllegalStateException("Metadata is read-only!");
    }

    @Override
    public void reset() {
        throw new IllegalStateException("Metadata is read-only!");
    }
}

