/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.gif;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.common.PaletteBuilder;
import com.sun.media.imageioimpl.plugins.gif.GIFImageWriter;
import java.awt.image.ColorModel;
import java.awt.image.SampleModel;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;

public class GIFImageWriterSpi
extends ImageWriterSpi {
    private static final String vendorName = "Sun Microsystems, Inc.";
    private static final String version = "1.0";
    private static final String[] names = new String[]{"gif", "GIF"};
    private static final String[] suffixes = new String[]{"gif"};
    private static final String[] MIMETypes = new String[]{"image/gif"};
    private static final String writerClassName = "com.sun.media.imageioimpl.plugins.gif.GIFImageWriter";
    private static final String[] readerSpiNames = new String[]{"com.sun.imageio.plugins.gif.GIFImageReaderSpi"};
    private boolean registered = false;

    public GIFImageWriterSpi() {
        super(vendorName, version, names, suffixes, MIMETypes, writerClassName, STANDARD_OUTPUT_TYPE, readerSpiNames, true, "javax_imageio_gif_stream_1.0", "com.sun.media.imageioimpl.plugins.gif.GIFStreamMetadataFormat", null, null, true, "javax_imageio_gif_image_1.0", "com.sun.media.imageioimpl.plugins.gif.GIFStreamMetadataFormat", null, null);
    }

    @Override
    public boolean canEncodeImage(ImageTypeSpecifier imageTypeSpecifier) {
        boolean bl;
        if (imageTypeSpecifier == null) {
            throw new IllegalArgumentException("type == null!");
        }
        SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
        ColorModel colorModel = imageTypeSpecifier.getColorModel();
        boolean bl2 = bl = sampleModel.getNumBands() == 1 && sampleModel.getSampleSize(0) <= 8 && sampleModel.getWidth() <= 65535 && sampleModel.getHeight() <= 65535 && (colorModel == null || colorModel.getComponentSize()[0] <= 8);
        if (bl) {
            return true;
        }
        return PaletteBuilder.canCreatePalette(imageTypeSpecifier);
    }

    @Override
    public String getDescription(Locale locale) {
        String string = String.valueOf(PackageUtil.getSpecificationTitle()) + " GIF Image Writer";
        return string;
    }

    public void onRegistration(ServiceRegistry serviceRegistry, Class clazz) {
        if (this.registered) {
            return;
        }
        this.registered = true;
        ImageUtil.processOnRegistration(serviceRegistry, clazz, "GIF", this, 9, 8);
    }

    @Override
    public ImageWriter createWriterInstance(Object object) {
        return new GIFImageWriter(this);
    }
}

