/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.bmp;

import com.sun.media.imageio.plugins.bmp.BMPImageWriteParam;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.bmp.BMPConstants;
import com.sun.media.imageioimpl.plugins.bmp.BMPMetadata;
import com.sun.media.imageioimpl.plugins.bmp.I18N;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.event.IIOWriteProgressListener;
import javax.imageio.event.IIOWriteWarningListener;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public class BMPImageWriter
extends ImageWriter
implements BMPConstants {
    private ImageOutputStream stream = null;
    private ByteArrayOutputStream embedded_stream = null;
    private int compressionType;
    private boolean isTopDown;
    private int w;
    private int h;
    private int compImageSize = 0;
    private int[] bitMasks;
    private int[] bitPos;
    private byte[] bpixels;
    private short[] spixels;
    private int[] ipixels;

    public BMPImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    @Override
    public void setOutput(Object object) {
        super.setOutput(object);
        if (object != null) {
            if (!(object instanceof ImageOutputStream)) {
                throw new IllegalArgumentException(I18N.getString("BMPImageWriter0"));
            }
            this.stream = (ImageOutputStream)object;
            this.stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.stream = null;
        }
    }

    @Override
    public ImageWriteParam getDefaultWriteParam() {
        return new BMPImageWriteParam();
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        BMPMetadata bMPMetadata = new BMPMetadata();
        bMPMetadata.initialize(imageTypeSpecifier.getColorModel(), imageTypeSpecifier.getSampleModel(), imageWriteParam);
        return bMPMetadata;
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        if (iIOMetadata == null) {
            throw new IllegalArgumentException("inData == null!");
        }
        if (imageTypeSpecifier == null) {
            throw new IllegalArgumentException("imageType == null!");
        }
        BMPMetadata bMPMetadata = null;
        if (iIOMetadata instanceof BMPMetadata) {
            bMPMetadata = (BMPMetadata)((BMPMetadata)iIOMetadata).clone();
        } else {
            try {
                bMPMetadata = new BMPMetadata(iIOMetadata);
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {
                bMPMetadata = new BMPMetadata();
            }
        }
        bMPMetadata.initialize(imageTypeSpecifier.getColorModel(), imageTypeSpecifier.getSampleModel(), imageWriteParam);
        return bMPMetadata;
    }

    @Override
    public boolean canWriteRasters() {
        return true;
    }

    @Override
    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        if (this.stream == null) {
            throw new IllegalStateException(I18N.getString("BMPImageWriter7"));
        }
        if (iIOImage == null) {
            throw new IllegalArgumentException(I18N.getString("BMPImageWriter8"));
        }
        this.clearAbortRequest();
        this.processImageStarted(0);
        if (imageWriteParam == null) {
            imageWriteParam = this.getDefaultWriteParam();
        }
        BMPImageWriteParam bMPImageWriteParam = (BMPImageWriteParam)imageWriteParam;
        int n5 = 24;
        boolean bl = false;
        int n6 = 0;
        IndexColorModel indexColorModel = null;
        RenderedImage renderedImage = null;
        Raster raster = null;
        boolean bl2 = iIOImage.hasRaster();
        Object object2 = imageWriteParam.getSourceRegion();
        SampleModel sampleModel = null;
        ColorModel colorModel = null;
        this.compImageSize = 0;
        if (bl2) {
            raster = iIOImage.getRaster();
            sampleModel = raster.getSampleModel();
            colorModel = ImageUtil.createColorModel(null, sampleModel);
            object2 = object2 == null ? raster.getBounds() : ((Rectangle)object2).intersection(raster.getBounds());
        } else {
            renderedImage = iIOImage.getRenderedImage();
            sampleModel = renderedImage.getSampleModel();
            colorModel = renderedImage.getColorModel();
            object = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
            object2 = object2 == null ? object : ((Rectangle)object2).intersection((Rectangle)object);
        }
        object = iIOImage.getMetadata();
        BMPMetadata bMPMetadata = null;
        ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier(colorModel, sampleModel);
        bMPMetadata = object != null ? (BMPMetadata)this.convertImageMetadata((IIOMetadata)object, imageTypeSpecifier, imageWriteParam) : (BMPMetadata)this.getDefaultImageMetadata(imageTypeSpecifier, imageWriteParam);
        if (((Rectangle)object2).isEmpty()) {
            throw new RuntimeException(I18N.getString("BMPImageWrite0"));
        }
        int n7 = imageWriteParam.getSourceXSubsampling();
        int n8 = imageWriteParam.getSourceYSubsampling();
        int n9 = imageWriteParam.getSubsamplingXOffset();
        int n10 = imageWriteParam.getSubsamplingYOffset();
        int n11 = sampleModel.getDataType();
        ((Rectangle)object2).translate(n9, n10);
        ((Rectangle)object2).width -= n9;
        ((Rectangle)object2).height -= n10;
        int n12 = ((Rectangle)object2).x / n7;
        int n13 = ((Rectangle)object2).y / n8;
        this.w = (((Rectangle)object2).width + n7 - 1) / n7;
        this.h = (((Rectangle)object2).height + n8 - 1) / n8;
        n9 = ((Rectangle)object2).x % n7;
        n10 = ((Rectangle)object2).y % n8;
        Rectangle rectangle = new Rectangle(n12, n13, this.w, this.h);
        boolean bl3 = rectangle.equals(object2);
        int[] nArray = imageWriteParam.getSourceBands();
        boolean bl4 = true;
        int n14 = sampleModel.getNumBands();
        if (nArray != null) {
            sampleModel = sampleModel.createSubsetSampleModel(nArray);
            colorModel = null;
            bl4 = false;
            n14 = sampleModel.getNumBands();
        } else {
            nArray = new int[n14];
            int n15 = 0;
            while (n15 < n14) {
                nArray[n15] = n15;
                ++n15;
            }
        }
        int[] nArray2 = null;
        boolean bl5 = true;
        if (sampleModel instanceof ComponentSampleModel) {
            nArray2 = ((ComponentSampleModel)sampleModel).getBandOffsets();
            if (sampleModel instanceof BandedSampleModel) {
                bl5 = false;
            } else {
                int n16 = 0;
                while (n16 < nArray2.length) {
                    bl5 &= nArray2[n16] == nArray2.length - n16 - 1;
                    ++n16;
                }
            }
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            int[] nArray3 = ((SinglePixelPackedSampleModel)sampleModel).getBitOffsets();
            n4 = 0;
            while (n4 < nArray3.length - 1) {
                bl5 &= nArray3[n4] > nArray3[n4 + 1];
                ++n4;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[n14];
            int n17 = 0;
            while (n17 < n14) {
                nArray2[n17] = n17;
                ++n17;
            }
        }
        bl3 &= bl5;
        int[] nArray4 = sampleModel.getSampleSize();
        n4 = this.w * n14;
        switch (bMPImageWriteParam.getCompressionMode()) {
            case 2: {
                this.compressionType = BMPImageWriter.getCompressionType(bMPImageWriteParam.getCompressionType());
                break;
            }
            case 3: {
                this.compressionType = bMPMetadata.compression;
                break;
            }
            case 1: {
                this.compressionType = BMPImageWriter.getPreferredCompressionType(colorModel, sampleModel);
                break;
            }
            default: {
                this.compressionType = 0;
            }
        }
        if (!this.canEncodeImage(this.compressionType, colorModel, sampleModel)) {
            if (imageWriteParam.getCompressionMode() == 2) {
                throw new IIOException("Image can not be encoded with compression type " + compressionTypeNames[this.compressionType]);
            }
            this.compressionType = BMPImageWriter.getPreferredCompressionType(colorModel, sampleModel);
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        if (this.compressionType == 3) {
            n5 = DataBuffer.getDataTypeSize(sampleModel.getDataType());
            if (n5 != 16 && n5 != 32) {
                n5 = 32;
                bl3 = false;
            }
            n4 = this.w * n5 + 7 >> 3;
            bl = true;
            n6 = 3;
            byArray = new byte[n6];
            byArray2 = new byte[n6];
            byArray3 = new byte[n6];
            byArray4 = new byte[n6];
            int n18 = 0xFF0000;
            n3 = 65280;
            n2 = 255;
            if (n5 == 16) {
                if (colorModel instanceof DirectColorModel) {
                    DirectColorModel directColorModel = (DirectColorModel)colorModel;
                    n18 = directColorModel.getRedMask();
                    n3 = directColorModel.getGreenMask();
                    n2 = directColorModel.getBlueMask();
                } else {
                    throw new IOException("Image can not be encoded with compression type " + compressionTypeNames[this.compressionType]);
                }
            }
            this.writeMaskToPalette(n18, 0, byArray, byArray2, byArray3, byArray4);
            this.writeMaskToPalette(n3, 1, byArray, byArray2, byArray3, byArray4);
            this.writeMaskToPalette(n2, 2, byArray, byArray2, byArray3, byArray4);
            if (!bl3) {
                this.bitMasks = new int[3];
                this.bitMasks[0] = n18;
                this.bitMasks[1] = n3;
                this.bitMasks[2] = n2;
                this.bitPos = new int[3];
                this.bitPos[0] = this.firstLowBit(n18);
                this.bitPos[1] = this.firstLowBit(n3);
                this.bitPos[2] = this.firstLowBit(n2);
            }
            if (colorModel instanceof IndexColorModel) {
                indexColorModel = (IndexColorModel)colorModel;
            }
        } else if (colorModel instanceof IndexColorModel) {
            bl = true;
            indexColorModel = (IndexColorModel)colorModel;
            n6 = indexColorModel.getMapSize();
            if (n6 <= 2) {
                n5 = 1;
                n4 = this.w + 7 >> 3;
            } else if (n6 <= 16) {
                n5 = 4;
                n4 = this.w + 1 >> 1;
            } else if (n6 <= 256) {
                n5 = 8;
            } else {
                n5 = 24;
                bl = false;
                n6 = 0;
                n4 = this.w * 3;
            }
            if (bl) {
                byArray = new byte[n6];
                byArray2 = new byte[n6];
                byArray3 = new byte[n6];
                indexColorModel.getReds(byArray);
                indexColorModel.getGreens(byArray2);
                indexColorModel.getBlues(byArray3);
            }
        } else if (n14 == 1) {
            bl = true;
            n6 = 256;
            n5 = nArray4[0];
            n4 = this.w * n5 + 7 >> 3;
            byArray = new byte[256];
            byArray2 = new byte[256];
            byArray3 = new byte[256];
            int n19 = 0;
            while (n19 < 256) {
                byArray[n19] = (byte)n19;
                byArray2[n19] = (byte)n19;
                byArray3[n19] = (byte)n19;
                ++n19;
            }
        } else if (sampleModel instanceof SinglePixelPackedSampleModel && bl4) {
            int[] nArray5 = sampleModel.getSampleSize();
            n5 = 0;
            n3 = 0;
            while (n3 < nArray5.length) {
                n5 += nArray5[n3];
                ++n3;
            }
            if ((n5 = this.roundBpp(n5)) != DataBuffer.getDataTypeSize(sampleModel.getDataType())) {
                bl3 = false;
            }
            n4 = this.w * n5 + 7 >> 3;
        }
        int n20 = 0;
        n3 = 0;
        n2 = 0;
        int n21 = 0;
        int n22 = bMPMetadata.xPixelsPerMeter;
        int n23 = bMPMetadata.yPixelsPerMeter;
        int n24 = bMPMetadata.colorsUsed > 0 ? bMPMetadata.colorsUsed : n6;
        int n25 = n6;
        int n26 = n4 % 4;
        if (n26 != 0) {
            n26 = 4 - n26;
        }
        n3 = 54 + n6 * 4;
        n21 = (n4 + n26) * this.h;
        n20 = n21 + n3;
        n2 = 40;
        long l = this.stream.getStreamPosition();
        if (imageWriteParam instanceof BMPImageWriteParam) {
            this.isTopDown = ((BMPImageWriteParam)imageWriteParam).isTopDown();
            if (this.compressionType != 0 && this.compressionType != 3) {
                this.isTopDown = false;
            }
        } else {
            this.isTopDown = false;
        }
        this.writeFileHeader(n20, n3);
        this.writeInfoHeader(n2, n5);
        this.stream.writeInt(this.compressionType);
        this.stream.writeInt(n21);
        this.stream.writeInt(n22);
        this.stream.writeInt(n23);
        this.stream.writeInt(n24);
        this.stream.writeInt(n25);
        if (bl) {
            if (this.compressionType == 3) {
                n = 0;
                while (n < 3) {
                    int n27 = (byArray4[n] & 0xFF) + (byArray[n] & 0xFF) * 256 + (byArray2[n] & 0xFF) * 65536 + (byArray3[n] & 0xFF) * 0x1000000;
                    this.stream.writeInt(n27);
                    ++n;
                }
            } else {
                n = 0;
                while (n < n6) {
                    this.stream.writeByte(byArray3[n]);
                    this.stream.writeByte(byArray2[n]);
                    this.stream.writeByte(byArray[n]);
                    this.stream.writeByte(0);
                    ++n;
                }
            }
        }
        n = this.w * n14;
        int[] nArray6 = new int[n * n7];
        this.bpixels = new byte[n4];
        if (this.compressionType == 4 || this.compressionType == 5) {
            this.embedded_stream = new ByteArrayOutputStream();
            this.writeEmbedded(iIOImage, bMPImageWriteParam);
            this.embedded_stream.flush();
            n21 = this.embedded_stream.size();
            long l2 = this.stream.getStreamPosition();
            n20 = n3 + n21;
            this.stream.seek(l);
            this.writeSize(n20, 2);
            this.stream.seek(l);
            this.writeSize(n21, 34);
            this.stream.seek(l2);
            this.stream.write(this.embedded_stream.toByteArray());
            this.embedded_stream = null;
            if (this.abortRequested()) {
                this.processWriteAborted();
            } else {
                this.processImageComplete();
                this.stream.flushBefore(this.stream.getStreamPosition());
            }
            return;
        }
        int n28 = nArray2[0];
        int n29 = 1;
        while (n29 < nArray2.length) {
            if (nArray2[n29] > n28) {
                n28 = nArray2[n29];
            }
            ++n29;
        }
        int[] nArray7 = new int[n28 + 1];
        int n30 = n4;
        if (bl3 && bl4) {
            n30 = n4 / (DataBuffer.getDataTypeSize(n11) >> 3);
        }
        int n31 = 0;
        while (n31 < this.h) {
            int n32;
            int n33;
            int n34;
            if (this.abortRequested()) break;
            int n35 = n13 + n31;
            if (!this.isTopDown) {
                n35 = n13 + this.h - n31 - 1;
            }
            Raster raster2 = raster;
            Rectangle rectangle2 = new Rectangle(n12 * n7 + n9, n35 * n8 + n10, (this.w - 1) * n7 + 1, 1);
            if (!bl2) {
                raster2 = renderedImage.getData(rectangle2);
            }
            if (bl3 && bl4) {
                Object object3;
                SampleModel sampleModel2 = raster2.getSampleModel();
                n34 = 0;
                n33 = rectangle2.x - raster2.getSampleModelTranslateX();
                n32 = rectangle2.y - raster2.getSampleModelTranslateY();
                if (sampleModel2 instanceof ComponentSampleModel) {
                    object3 = (ComponentSampleModel)sampleModel2;
                    n34 = ((ComponentSampleModel)object3).getOffset(n33, n32, 0);
                    int n36 = 1;
                    while (n36 < ((SampleModel)object3).getNumBands()) {
                        if (n34 > ((ComponentSampleModel)object3).getOffset(n33, n32, n36)) {
                            n34 = ((ComponentSampleModel)object3).getOffset(n33, n32, n36);
                        }
                        ++n36;
                    }
                } else if (sampleModel2 instanceof MultiPixelPackedSampleModel) {
                    MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel2;
                    n34 = multiPixelPackedSampleModel.getOffset(n33, n32);
                } else if (sampleModel2 instanceof SinglePixelPackedSampleModel) {
                    SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel2;
                    n34 = singlePixelPackedSampleModel.getOffset(n33, n32);
                }
                if (this.compressionType == 0 || this.compressionType == 3) {
                    switch (n11) {
                        case 0: {
                            object3 = ((DataBufferByte)raster2.getDataBuffer()).getData();
                            this.stream.write((byte[])object3, n34, n30);
                            break;
                        }
                        case 2: {
                            short[] sArray = ((DataBufferShort)raster2.getDataBuffer()).getData();
                            this.stream.writeShorts(sArray, n34, n30);
                            break;
                        }
                        case 1: {
                            short[] sArray = ((DataBufferUShort)raster2.getDataBuffer()).getData();
                            this.stream.writeShorts(sArray, n34, n30);
                            break;
                        }
                        case 3: {
                            int[] nArray8 = ((DataBufferInt)raster2.getDataBuffer()).getData();
                            this.stream.writeInts(nArray8, n34, n30);
                        }
                    }
                    int n37 = 0;
                    while (n37 < n26) {
                        this.stream.writeByte(0);
                        ++n37;
                    }
                } else if (this.compressionType == 2) {
                    if (this.bpixels == null || this.bpixels.length < n) {
                        this.bpixels = new byte[n];
                    }
                    raster2.getPixels(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, nArray6);
                    int n38 = 0;
                    while (n38 < n) {
                        this.bpixels[n38] = (byte)nArray6[n38];
                        ++n38;
                    }
                    this.encodeRLE4(this.bpixels, n);
                } else if (this.compressionType == 1) {
                    if (this.bpixels == null || this.bpixels.length < n) {
                        this.bpixels = new byte[n];
                    }
                    raster2.getPixels(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, nArray6);
                    int n39 = 0;
                    while (n39 < n) {
                        this.bpixels[n39] = (byte)nArray6[n39];
                        ++n39;
                    }
                    this.encodeRLE8(this.bpixels, n);
                }
            } else {
                raster2.getPixels(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, nArray6);
                if (n7 != 1 || n28 != n14 - 1) {
                    int n40 = 0;
                    n34 = 0;
                    n33 = 0;
                    while (n40 < this.w) {
                        System.arraycopy(nArray6, n34, nArray7, 0, nArray7.length);
                        n32 = 0;
                        while (n32 < n14) {
                            nArray6[n33 + n32] = nArray7[nArray[n32]];
                            ++n32;
                        }
                        ++n40;
                        n34 += n7 * n14;
                        n33 += n14;
                    }
                }
                this.writePixels(0, n, n5, nArray6, n26, n14, indexColorModel);
            }
            this.processImageProgress(100.0f * ((float)n31 / (float)this.h));
            ++n31;
        }
        if (this.compressionType == 2 || this.compressionType == 1) {
            this.stream.writeByte(0);
            this.stream.writeByte(1);
            this.incCompImageSize(2);
            n21 = this.compImageSize;
            n20 = this.compImageSize + n3;
            long l3 = this.stream.getStreamPosition();
            this.stream.seek(l);
            this.writeSize(n20, 2);
            this.stream.seek(l);
            this.writeSize(n21, 34);
            this.stream.seek(l3);
        }
        if (this.abortRequested()) {
            this.processWriteAborted();
        } else {
            this.processImageComplete();
            this.stream.flushBefore(this.stream.getStreamPosition());
        }
    }

    private void writePixels(int n, int n2, int n3, int[] nArray, int n4, int n5, IndexColorModel indexColorModel) throws IOException {
        int n6 = 0;
        int n7 = 0;
        switch (n3) {
            case 1: {
                int n8 = 0;
                while (n8 < n2 / 8) {
                    this.bpixels[n7++] = (byte)(nArray[n++] << 7 | nArray[n++] << 6 | nArray[n++] << 5 | nArray[n++] << 4 | nArray[n++] << 3 | nArray[n++] << 2 | nArray[n++] << 1 | nArray[n++]);
                    ++n8;
                }
                if (n2 % 8 > 0) {
                    n6 = 0;
                    n8 = 0;
                    while (n8 < n2 % 8) {
                        n6 |= nArray[n++] << 7 - n8;
                        ++n8;
                    }
                    this.bpixels[n7++] = (byte)n6;
                }
                this.stream.write(this.bpixels, 0, (n2 + 7) / 8);
                break;
            }
            case 4: {
                if (this.compressionType == 2) {
                    byte[] byArray = new byte[n2];
                    int n9 = 0;
                    while (n9 < n2) {
                        byArray[n9] = (byte)nArray[n++];
                        ++n9;
                    }
                    this.encodeRLE4(byArray, n2);
                    break;
                }
                int n10 = 0;
                while (n10 < n2 / 2) {
                    n6 = nArray[n++] << 4 | nArray[n++];
                    this.bpixels[n7++] = (byte)n6;
                    ++n10;
                }
                if (n2 % 2 == 1) {
                    n6 = nArray[n] << 4;
                    this.bpixels[n7++] = (byte)n6;
                }
                this.stream.write(this.bpixels, 0, (n2 + 1) / 2);
                break;
            }
            case 8: {
                if (this.compressionType == 1) {
                    int n11 = 0;
                    while (n11 < n2) {
                        this.bpixels[n11] = (byte)nArray[n++];
                        ++n11;
                    }
                    this.encodeRLE8(this.bpixels, n2);
                    break;
                }
                int n12 = 0;
                while (n12 < n2) {
                    this.bpixels[n12] = (byte)nArray[n++];
                    ++n12;
                }
                this.stream.write(this.bpixels, 0, n2);
                break;
            }
            case 16: {
                if (this.spixels == null) {
                    this.spixels = new short[n2 / n5];
                }
                int n13 = 0;
                int n14 = 0;
                while (n13 < n2) {
                    this.spixels[n14] = 0;
                    if (this.compressionType == 0) {
                        this.spixels[n14] = (short)((0x1F & nArray[n13]) << 10 | (0x1F & nArray[n13 + 1]) << 5 | 0x1F & nArray[n13 + 2]);
                        n13 += 3;
                    } else {
                        int n15 = 0;
                        while (n15 < n5) {
                            int n16 = n14;
                            this.spixels[n16] = (short)(this.spixels[n16] | nArray[n13] << this.bitPos[n15] & this.bitMasks[n15]);
                            ++n15;
                            ++n13;
                        }
                    }
                    ++n14;
                }
                this.stream.writeShorts(this.spixels, 0, this.spixels.length);
                break;
            }
            case 24: {
                if (n5 == 3) {
                    int n17 = 0;
                    while (n17 < n2) {
                        this.bpixels[n7++] = (byte)nArray[n + 2];
                        this.bpixels[n7++] = (byte)nArray[n + 1];
                        this.bpixels[n7++] = (byte)nArray[n];
                        n += 3;
                        n17 += 3;
                    }
                    this.stream.write(this.bpixels, 0, n2);
                    break;
                }
                int n18 = indexColorModel.getMapSize();
                byte[] byArray = new byte[n18];
                byte[] byArray2 = new byte[n18];
                byte[] byArray3 = new byte[n18];
                indexColorModel.getReds(byArray);
                indexColorModel.getGreens(byArray2);
                indexColorModel.getBlues(byArray3);
                int n19 = 0;
                while (n19 < n2) {
                    int n20 = nArray[n];
                    this.bpixels[n7++] = byArray3[n20];
                    this.bpixels[n7++] = byArray2[n20];
                    this.bpixels[n7++] = byArray3[n20];
                    ++n;
                    ++n19;
                }
                this.stream.write(this.bpixels, 0, n2 * 3);
                break;
            }
            case 32: {
                int n21;
                if (this.ipixels == null) {
                    this.ipixels = new int[n2 / n5];
                }
                if (n5 == 3) {
                    n21 = 0;
                    int n22 = 0;
                    while (n21 < n2) {
                        this.ipixels[n22] = 0;
                        if (this.compressionType == 0) {
                            this.ipixels[n22] = (0xFF & nArray[n21 + 2]) << 16 | (0xFF & nArray[n21 + 1]) << 8 | 0xFF & nArray[n21];
                            n21 += 3;
                        } else {
                            int n23 = 0;
                            while (n23 < n5) {
                                int n24 = n22;
                                this.ipixels[n24] = this.ipixels[n24] | nArray[n21] << this.bitPos[n23] & this.bitMasks[n23];
                                ++n23;
                                ++n21;
                            }
                        }
                        ++n22;
                    }
                } else {
                    n21 = 0;
                    while (n21 < n2) {
                        this.ipixels[n21] = indexColorModel != null ? indexColorModel.getRGB(nArray[n21]) : nArray[n21] << 16 | nArray[n21] << 8 | nArray[n21];
                        ++n21;
                    }
                }
                this.stream.writeInts(this.ipixels, 0, this.ipixels.length);
            }
        }
        if (this.compressionType == 0 || this.compressionType == 3) {
            n7 = 0;
            while (n7 < n4) {
                this.stream.writeByte(0);
                ++n7;
            }
        }
    }

    private void encodeRLE8(byte[] byArray, int n) throws IOException {
        int n2 = 1;
        int n3 = -1;
        int n4 = -1;
        byte by = 0;
        byte by2 = 0;
        by = byArray[++n4];
        byte[] byArray2 = new byte[256];
        while (n4 < n - 1) {
            int n5;
            if ((by2 = byArray[++n4]) == by) {
                if (n3 >= 3) {
                    this.stream.writeByte(0);
                    this.stream.writeByte(n3);
                    this.incCompImageSize(2);
                    n5 = 0;
                    while (n5 < n3) {
                        this.stream.writeByte(byArray2[n5]);
                        this.incCompImageSize(1);
                        ++n5;
                    }
                    if (!this.isEven(n3)) {
                        this.stream.writeByte(0);
                        this.incCompImageSize(1);
                    }
                } else if (n3 > -1) {
                    n5 = 0;
                    while (n5 < n3) {
                        this.stream.writeByte(1);
                        this.stream.writeByte(byArray2[n5]);
                        this.incCompImageSize(2);
                        ++n5;
                    }
                }
                n3 = -1;
                if (++n2 == 256) {
                    this.stream.writeByte(n2 - 1);
                    this.stream.writeByte(by);
                    this.incCompImageSize(2);
                    n2 = 1;
                }
            } else {
                if (n2 > 1) {
                    this.stream.writeByte(n2);
                    this.stream.writeByte(by);
                    this.incCompImageSize(2);
                } else if (n3 < 0) {
                    byArray2[++n3] = by;
                    byArray2[++n3] = by2;
                } else if (n3 < 254) {
                    byArray2[++n3] = by2;
                } else {
                    this.stream.writeByte(0);
                    this.stream.writeByte(n3 + 1);
                    this.incCompImageSize(2);
                    n5 = 0;
                    while (n5 <= n3) {
                        this.stream.writeByte(byArray2[n5]);
                        this.incCompImageSize(1);
                        ++n5;
                    }
                    this.stream.writeByte(0);
                    this.incCompImageSize(1);
                    n3 = -1;
                }
                by = by2;
                n2 = 1;
            }
            if (n4 != n - 1) continue;
            if (n3 == -1) {
                this.stream.writeByte(n2);
                this.stream.writeByte(by);
                this.incCompImageSize(2);
                n2 = 1;
            } else if (n3 >= 2) {
                this.stream.writeByte(0);
                this.stream.writeByte(n3 + 1);
                this.incCompImageSize(2);
                n5 = 0;
                while (n5 <= n3) {
                    this.stream.writeByte(byArray2[n5]);
                    this.incCompImageSize(1);
                    ++n5;
                }
                if (!this.isEven(n3 + 1)) {
                    this.stream.writeByte(0);
                    this.incCompImageSize(1);
                }
            } else if (n3 > -1) {
                n5 = 0;
                while (n5 <= n3) {
                    this.stream.writeByte(1);
                    this.stream.writeByte(byArray2[n5]);
                    this.incCompImageSize(2);
                    ++n5;
                }
            }
            this.stream.writeByte(0);
            this.stream.writeByte(0);
            this.incCompImageSize(2);
        }
    }

    private void encodeRLE4(byte[] byArray, int n) throws IOException {
        int n2 = 2;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte[] byArray2 = new byte[256];
        by = byArray[++n4];
        by2 = byArray[++n4];
        while (n4 < n - 2) {
            int n7;
            by3 = byArray[++n4];
            by4 = byArray[++n4];
            if (by3 == by) {
                if (n3 >= 4) {
                    this.stream.writeByte(0);
                    this.stream.writeByte(n3 - 1);
                    this.incCompImageSize(2);
                    n7 = 0;
                    while (n7 < n3 - 2) {
                        n5 = byArray2[n7] << 4 | byArray2[n7 + 1];
                        this.stream.writeByte((byte)n5);
                        this.incCompImageSize(1);
                        n7 += 2;
                    }
                    if (!this.isEven(n3 - 1)) {
                        n6 = byArray2[n3 - 2] << 4;
                        this.stream.writeByte(n6);
                        this.incCompImageSize(1);
                    }
                    if (!this.isEven((int)Math.ceil((n3 - 1) / 2))) {
                        this.stream.writeByte(0);
                        this.incCompImageSize(1);
                    }
                } else if (n3 > -1) {
                    this.stream.writeByte(2);
                    n5 = byArray2[0] << 4 | byArray2[1];
                    this.stream.writeByte(n5);
                    this.incCompImageSize(2);
                }
                n3 = -1;
                if (by4 == by2) {
                    if ((n2 += 2) == 256) {
                        this.stream.writeByte(n2 - 1);
                        n5 = by << 4 | by2;
                        this.stream.writeByte(n5);
                        this.incCompImageSize(2);
                        n2 = 2;
                        if (n4 < n - 1) {
                            by = by2;
                            by2 = byArray[++n4];
                        } else {
                            this.stream.writeByte(1);
                            n7 = by2 << 4;
                            this.stream.writeByte(n7);
                            this.incCompImageSize(2);
                            n2 = -1;
                        }
                    }
                } else {
                    n5 = by << 4 | by2;
                    this.stream.writeByte(++n2);
                    this.stream.writeByte(n5);
                    this.incCompImageSize(2);
                    n2 = 2;
                    by = by4;
                    if (n4 < n - 1) {
                        by2 = byArray[++n4];
                    } else {
                        this.stream.writeByte(1);
                        n7 = by4 << 4;
                        this.stream.writeByte(n7);
                        this.incCompImageSize(2);
                        n2 = -1;
                    }
                }
            } else {
                if (n2 > 2) {
                    n5 = by << 4 | by2;
                    this.stream.writeByte(n2);
                    this.stream.writeByte(n5);
                    this.incCompImageSize(2);
                } else if (n3 < 0) {
                    byArray2[++n3] = by;
                    byArray2[++n3] = by2;
                    byArray2[++n3] = by3;
                    byArray2[++n3] = by4;
                } else if (n3 < 253) {
                    byArray2[++n3] = by3;
                    byArray2[++n3] = by4;
                } else {
                    this.stream.writeByte(0);
                    this.stream.writeByte(n3 + 1);
                    this.incCompImageSize(2);
                    n7 = 0;
                    while (n7 < n3) {
                        n5 = byArray2[n7] << 4 | byArray2[n7 + 1];
                        this.stream.writeByte((byte)n5);
                        this.incCompImageSize(1);
                        n7 += 2;
                    }
                    this.stream.writeByte(0);
                    this.incCompImageSize(1);
                    n3 = -1;
                }
                by = by3;
                by2 = by4;
                n2 = 2;
            }
            if (n4 < n - 2) continue;
            if (n3 == -1 && n2 >= 2) {
                if (n4 == n - 2) {
                    if (byArray[++n4] == by) {
                        n5 = by << 4 | by2;
                        this.stream.writeByte(++n2);
                        this.stream.writeByte(n5);
                        this.incCompImageSize(2);
                    } else {
                        n5 = by << 4 | by2;
                        this.stream.writeByte(n2);
                        this.stream.writeByte(n5);
                        this.stream.writeByte(1);
                        n5 = byArray[n4] << 4;
                        this.stream.writeByte(n5);
                        byte cfr_ignored_0 = byArray[n4];
                        this.incCompImageSize(4);
                    }
                } else {
                    this.stream.writeByte(n2);
                    n5 = by << 4 | by2;
                    this.stream.writeByte(n5);
                    this.incCompImageSize(2);
                }
            } else if (n3 > -1) {
                if (n4 == n - 2) {
                    byArray2[++n3] = byArray[++n4];
                }
                if (n3 >= 2) {
                    this.stream.writeByte(0);
                    this.stream.writeByte(n3 + 1);
                    this.incCompImageSize(2);
                    n7 = 0;
                    while (n7 < n3) {
                        n5 = byArray2[n7] << 4 | byArray2[n7 + 1];
                        this.stream.writeByte((byte)n5);
                        this.incCompImageSize(1);
                        n7 += 2;
                    }
                    if (!this.isEven(n3 + 1)) {
                        n6 = byArray2[n3] << 4;
                        this.stream.writeByte(n6);
                        this.incCompImageSize(1);
                    }
                    if (!this.isEven((int)Math.ceil((n3 + 1) / 2))) {
                        this.stream.writeByte(0);
                        this.incCompImageSize(1);
                    }
                } else {
                    switch (n3) {
                        case 0: {
                            this.stream.writeByte(1);
                            n7 = byArray2[0] << 4;
                            this.stream.writeByte(n7);
                            this.incCompImageSize(2);
                            break;
                        }
                        case 1: {
                            this.stream.writeByte(2);
                            n5 = byArray2[0] << 4 | byArray2[1];
                            this.stream.writeByte(n5);
                            this.incCompImageSize(2);
                        }
                    }
                }
            }
            this.stream.writeByte(0);
            this.stream.writeByte(0);
            this.incCompImageSize(2);
        }
    }

    private synchronized void incCompImageSize(int n) {
        this.compImageSize += n;
    }

    private boolean isEven(int n) {
        return n % 2 == 0;
    }

    private void writeFileHeader(int n, int n2) throws IOException {
        this.stream.writeByte(66);
        this.stream.writeByte(77);
        this.stream.writeInt(n);
        this.stream.writeInt(0);
        this.stream.writeInt(n2);
    }

    private void writeInfoHeader(int n, int n2) throws IOException {
        this.stream.writeInt(n);
        this.stream.writeInt(this.w);
        if (this.isTopDown) {
            this.stream.writeInt(-this.h);
        } else {
            this.stream.writeInt(this.h);
        }
        this.stream.writeShort(1);
        this.stream.writeShort(n2);
    }

    private void writeSize(int n, int n2) throws IOException {
        this.stream.skipBytes(n2);
        this.stream.writeInt(n);
    }

    @Override
    public void reset() {
        super.reset();
        this.stream = null;
    }

    static int getCompressionType(String string) {
        int n = 0;
        while (n < BMPConstants.compressionTypeNames.length) {
            if (BMPConstants.compressionTypeNames[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    private void writeEmbedded(IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        String string = this.compressionType == 4 ? "jpeg" : "png";
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string);
        ImageWriter imageWriter = null;
        if (iterator.hasNext()) {
            imageWriter = iterator.next();
        }
        if (imageWriter != null) {
            if (this.embedded_stream == null) {
                throw new RuntimeException("No stream for writing embedded image!");
            }
        } else {
            throw new RuntimeException(String.valueOf(I18N.getString("BMPImageWrite5")) + " " + string);
        }
        imageWriter.addIIOWriteProgressListener(new IIOWriteProgressAdapter(){

            @Override
            public void imageProgress(ImageWriter imageWriter, float f) {
                BMPImageWriter.this.processImageProgress(f);
            }
        });
        imageWriter.addIIOWriteWarningListener(new IIOWriteWarningListener(){

            @Override
            public void warningOccurred(ImageWriter imageWriter, int n, String string) {
                BMPImageWriter.this.processWarningOccurred(n, string);
            }
        });
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(this.embedded_stream);
        imageWriter.setOutput(imageOutputStream);
        ImageWriteParam imageWriteParam2 = imageWriter.getDefaultWriteParam();
        imageWriteParam2.setDestinationOffset(imageWriteParam.getDestinationOffset());
        imageWriteParam2.setSourceBands(imageWriteParam.getSourceBands());
        imageWriteParam2.setSourceRegion(imageWriteParam.getSourceRegion());
        imageWriteParam2.setSourceSubsampling(imageWriteParam.getSourceXSubsampling(), imageWriteParam.getSourceYSubsampling(), imageWriteParam.getSubsamplingXOffset(), imageWriteParam.getSubsamplingYOffset());
        imageWriter.write(null, iIOImage, imageWriteParam2);
        imageOutputStream.flush();
    }

    private int firstLowBit(int n) {
        int n2 = 0;
        while ((n & 1) == 0) {
            ++n2;
            n >>>= 1;
        }
        return n2;
    }

    static int getPreferredCompressionType(ColorModel colorModel, SampleModel sampleModel) {
        ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier(colorModel, sampleModel);
        return BMPImageWriter.getPreferredCompressionType(imageTypeSpecifier);
    }

    static int getPreferredCompressionType(ImageTypeSpecifier imageTypeSpecifier) {
        int n = imageTypeSpecifier.getBufferedImageType();
        if (n == 8 || n == 9) {
            return 3;
        }
        return 0;
    }

    protected boolean canEncodeImage(int n, ColorModel colorModel, SampleModel sampleModel) {
        ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier(colorModel, sampleModel);
        return this.canEncodeImage(n, imageTypeSpecifier);
    }

    protected boolean canEncodeImage(int n, ImageTypeSpecifier imageTypeSpecifier) {
        ImageWriterSpi imageWriterSpi = this.getOriginatingProvider();
        if (!imageWriterSpi.canEncodeImage(imageTypeSpecifier)) {
            return false;
        }
        int n2 = imageTypeSpecifier.getColorModel().getPixelSize();
        if (this.compressionType == 2 && n2 != 4) {
            return false;
        }
        if (this.compressionType == 1 && n2 != 8) {
            return false;
        }
        if (n2 == 16) {
            boolean bl = false;
            boolean bl2 = false;
            SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
            if (sampleModel instanceof SinglePixelPackedSampleModel) {
                int[] nArray = ((SinglePixelPackedSampleModel)sampleModel).getSampleSize();
                bl = true;
                bl2 = true;
                int n3 = 0;
                while (n3 < nArray.length) {
                    bl &= nArray[n3] == 5;
                    bl2 &= nArray[n3] == 5 || n3 == 1 && nArray[n3] == 6;
                    ++n3;
                }
            }
            return this.compressionType == 0 && bl || this.compressionType == 3 && bl2;
        }
        return true;
    }

    protected void writeMaskToPalette(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        byArray3[n2] = (byte)(0xFF & n >> 24);
        byArray2[n2] = (byte)(0xFF & n >> 16);
        byArray[n2] = (byte)(0xFF & n >> 8);
        byArray4[n2] = (byte)(0xFF & n);
    }

    private int roundBpp(int n) {
        if (n <= 8) {
            return 8;
        }
        if (n <= 16) {
            return 16;
        }
        if (n <= 24) {
            return 24;
        }
        return 32;
    }

    private class IIOWriteProgressAdapter
    implements IIOWriteProgressListener {
        private IIOWriteProgressAdapter() {
        }

        @Override
        public void imageComplete(ImageWriter imageWriter) {
        }

        @Override
        public void imageProgress(ImageWriter imageWriter, float f) {
        }

        @Override
        public void imageStarted(ImageWriter imageWriter, int n) {
        }

        @Override
        public void thumbnailComplete(ImageWriter imageWriter) {
        }

        @Override
        public void thumbnailProgress(ImageWriter imageWriter, float f) {
        }

        @Override
        public void thumbnailStarted(ImageWriter imageWriter, int n, int n2) {
        }

        @Override
        public void writeAborted(ImageWriter imageWriter) {
        }
    }
}

