/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.common;

import java.awt.color.ColorSpace;

public final class SimpleCMYKColorSpace
extends ColorSpace {
    private static ColorSpace theInstance = null;
    private ColorSpace csRGB = ColorSpace.getInstance(1004);
    private static final double power1 = 0.4166666666666667;

    public static final synchronized ColorSpace getInstance() {
        if (theInstance == null) {
            theInstance = new SimpleCMYKColorSpace();
        }
        return theInstance;
    }

    private SimpleCMYKColorSpace() {
        super(9, 4);
    }

    public boolean equals(Object object) {
        return object != null && object instanceof SimpleCMYKColorSpace;
    }

    @Override
    public float[] toRGB(float[] fArray) {
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        float f4 = fArray[3];
        float f5 = 1.0f - f4;
        float[] fArray2 = new float[]{f5 * (1.0f - f), f5 * (1.0f - f2), f5 * (1.0f - f3)};
        int n = 0;
        while (n < 3) {
            float f6 = fArray2[n];
            if (f6 < 0.0f) {
                f6 = 0.0f;
            }
            if (f6 < 0.0031308f) {
                fArray2[n] = 12.92f * f6;
            } else {
                if (f6 > 1.0f) {
                    f6 = 1.0f;
                }
                fArray2[n] = (float)(1.055 * Math.pow(f6, 0.4166666666666667) - 0.055);
            }
            ++n;
        }
        return fArray2;
    }

    @Override
    public float[] fromRGB(float[] fArray) {
        int n = 0;
        while (n < 3) {
            if (fArray[n] < 0.040449936f) {
                int n2 = n;
                fArray[n2] = fArray[n2] / 12.92f;
            } else {
                fArray[n] = (float)Math.pow(((double)fArray[n] + 0.055) / 1.055, 2.4);
            }
            ++n;
        }
        float f = 1.0f - fArray[0];
        float f2 = 1.0f - fArray[1];
        float f3 = 1.0f - fArray[2];
        float f4 = Math.min(f, Math.min(f2, f3));
        if (f4 != 1.0f) {
            float f5 = 1.0f - f4;
            f = (f - f4) / f5;
            f2 = (f2 - f4) / f5;
            f3 = (f3 - f4) / f5;
        } else {
            f3 = 0.0f;
            f2 = 0.0f;
            f = 0.0f;
        }
        return new float[]{f, f2, f3, f4};
    }

    @Override
    public float[] toCIEXYZ(float[] fArray) {
        return this.csRGB.toCIEXYZ(this.toRGB(fArray));
    }

    @Override
    public float[] fromCIEXYZ(float[] fArray) {
        return this.fromRGB(this.csRGB.fromCIEXYZ(fArray));
    }
}

