/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.common;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.imageio.ImageTypeSpecifier;

public class PaletteBuilder {
    protected static final int MAXLEVEL = 8;
    protected RenderedImage src;
    protected ColorModel srcColorModel;
    protected Raster srcRaster;
    protected int requiredSize;
    protected ColorNode root;
    protected int numNodes;
    protected int maxNodes;
    protected int currLevel;
    protected int currSize;
    protected ColorNode[] reduceList;
    protected ColorNode[] palette;
    protected int transparency;
    protected ColorNode transColor;

    public static RenderedImage createIndexedImage(RenderedImage renderedImage) {
        PaletteBuilder paletteBuilder = new PaletteBuilder(renderedImage);
        paletteBuilder.buildPalette();
        return paletteBuilder.getIndexedImage();
    }

    public static IndexColorModel createIndexColorModel(RenderedImage renderedImage) {
        PaletteBuilder paletteBuilder = new PaletteBuilder(renderedImage);
        paletteBuilder.buildPalette();
        return paletteBuilder.getIndexColorModel();
    }

    public static boolean canCreatePalette(ImageTypeSpecifier imageTypeSpecifier) {
        if (imageTypeSpecifier == null) {
            throw new IllegalArgumentException("type == null");
        }
        return true;
    }

    public static boolean canCreatePalette(RenderedImage renderedImage) {
        if (renderedImage == null) {
            throw new IllegalArgumentException("image == null");
        }
        ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier(renderedImage);
        return PaletteBuilder.canCreatePalette(imageTypeSpecifier);
    }

    protected RenderedImage getIndexedImage() {
        IndexColorModel indexColorModel = this.getIndexColorModel();
        BufferedImage bufferedImage = new BufferedImage(this.src.getWidth(), this.src.getHeight(), 13, indexColorModel);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = this.src.getMinX();
        int n2 = this.src.getMinY();
        int n3 = 0;
        while (n3 < bufferedImage.getHeight()) {
            int n4 = 0;
            while (n4 < bufferedImage.getWidth()) {
                Color color = this.getSrcColor(n4 + n, n3 + n2);
                writableRaster.setSample(n4, n3, 0, this.findColorIndex(this.root, color));
                ++n4;
            }
            ++n3;
        }
        return bufferedImage;
    }

    protected PaletteBuilder(RenderedImage renderedImage) {
        this(renderedImage, 256);
    }

    protected PaletteBuilder(RenderedImage renderedImage, int n) {
        this.src = renderedImage;
        this.srcColorModel = renderedImage.getColorModel();
        this.srcRaster = renderedImage.getData();
        this.transparency = this.srcColorModel.getTransparency();
        if (this.transparency != 1) {
            this.requiredSize = n - 1;
            this.transColor = new ColorNode();
            this.transColor.isLeaf = true;
        } else {
            this.requiredSize = n;
        }
    }

    private Color getSrcColor(int n, int n2) {
        int n3 = this.srcColorModel.getRGB(this.srcRaster.getDataElements(n, n2, null));
        return new Color(n3, this.transparency != 1);
    }

    protected int findColorIndex(ColorNode colorNode, Color color) {
        if (this.transparency != 1 && color.getAlpha() != 255) {
            return 0;
        }
        if (colorNode.isLeaf) {
            return colorNode.paletteIndex;
        }
        int n = this.getBranchIndex(color, colorNode.level);
        return this.findColorIndex(colorNode.children[n], color);
    }

    protected void buildPalette() {
        this.reduceList = new ColorNode[9];
        int n = 0;
        while (n < this.reduceList.length) {
            this.reduceList[n] = null;
            ++n;
        }
        this.numNodes = 0;
        this.maxNodes = 0;
        this.root = null;
        this.currSize = 0;
        this.currLevel = 8;
        n = this.src.getWidth();
        int n2 = this.src.getHeight();
        int n3 = this.src.getMinX();
        int n4 = this.src.getMinY();
        int n5 = 0;
        while (n5 < n2) {
            int n6 = 0;
            while (n6 < n) {
                Color color = this.getSrcColor(n - n6 + n3 - 1, n2 - n5 + n4 - 1);
                if (this.transparency != 1 && color.getAlpha() != 255) {
                    this.transColor = this.insertNode(this.transColor, color, 0);
                } else {
                    this.root = this.insertNode(this.root, color, 0);
                }
                if (this.currSize > this.requiredSize) {
                    this.reduceTree();
                }
                ++n6;
            }
            ++n5;
        }
    }

    protected ColorNode insertNode(ColorNode colorNode, Color color, int n) {
        if (colorNode == null) {
            colorNode = new ColorNode();
            ++this.numNodes;
            if (this.numNodes > this.maxNodes) {
                this.maxNodes = this.numNodes;
            }
            colorNode.level = n;
            boolean bl = colorNode.isLeaf = n > 8;
            if (colorNode.isLeaf) {
                ++this.currSize;
            }
        }
        ++colorNode.colorCount;
        colorNode.red += (long)color.getRed();
        colorNode.green += (long)color.getGreen();
        colorNode.blue += (long)color.getBlue();
        if (!colorNode.isLeaf) {
            int n2 = this.getBranchIndex(color, n);
            if (colorNode.children[n2] == null) {
                ++colorNode.childCount;
                if (colorNode.childCount == 2) {
                    colorNode.nextReducible = this.reduceList[n];
                    this.reduceList[n] = colorNode;
                }
            }
            colorNode.children[n2] = this.insertNode(colorNode.children[n2], color, n + 1);
        }
        return colorNode;
    }

    protected IndexColorModel getIndexColorModel() {
        int n = this.currSize;
        if (this.transparency != 1) {
            ++n;
        }
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        int n2 = 0;
        this.palette = new ColorNode[n];
        if (this.transparency != 1) {
            ++n2;
        }
        this.findPaletteEntry(this.root, n2, byArray, byArray2, byArray3);
        IndexColorModel indexColorModel = null;
        indexColorModel = this.transparency != 1 ? new IndexColorModel(8, n, byArray, byArray2, byArray3, 0) : new IndexColorModel(8, this.currSize, byArray, byArray2, byArray3);
        return indexColorModel;
    }

    protected int findPaletteEntry(ColorNode colorNode, int n, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (colorNode.isLeaf) {
            byArray[n] = (byte)(colorNode.red / (long)colorNode.colorCount);
            byArray2[n] = (byte)(colorNode.green / (long)colorNode.colorCount);
            byArray3[n] = (byte)(colorNode.blue / (long)colorNode.colorCount);
            colorNode.paletteIndex = n;
            this.palette[n] = colorNode;
            ++n;
        } else {
            int n2 = 0;
            while (n2 < 8) {
                if (colorNode.children[n2] != null) {
                    n = this.findPaletteEntry(colorNode.children[n2], n, byArray, byArray2, byArray3);
                }
                ++n2;
            }
        }
        return n;
    }

    protected int getBranchIndex(Color color, int n) {
        if (n > 8 || n < 0) {
            throw new IllegalArgumentException("Invalid octree node depth: " + n);
        }
        int n2 = 8 - n;
        int n3 = 1 & (0xFF & color.getRed()) >> n2;
        int n4 = 1 & (0xFF & color.getGreen()) >> n2;
        int n5 = 1 & (0xFF & color.getBlue()) >> n2;
        int n6 = n3 << 2 | n4 << 1 | n5;
        return n6;
    }

    protected void reduceTree() {
        int n = this.reduceList.length - 1;
        while (this.reduceList[n] == null && n >= 0) {
            --n;
        }
        ColorNode colorNode = this.reduceList[n];
        if (colorNode == null) {
            return;
        }
        ColorNode colorNode2 = colorNode;
        int n2 = colorNode2.colorCount;
        while (colorNode2.nextReducible != null) {
            if (n2 > colorNode2.nextReducible.colorCount) {
                colorNode = colorNode2;
                n2 = colorNode2.colorCount;
            }
            colorNode2 = colorNode2.nextReducible;
        }
        if (colorNode == this.reduceList[n]) {
            this.reduceList[n] = colorNode.nextReducible;
        } else {
            colorNode2 = colorNode.nextReducible;
            colorNode.nextReducible = colorNode2.nextReducible;
            colorNode = colorNode2;
        }
        if (colorNode.isLeaf) {
            return;
        }
        int n3 = colorNode.getLeafChildCount();
        colorNode.isLeaf = true;
        this.currSize -= n3 - 1;
        int cfr_ignored_0 = colorNode.level;
        int n4 = 0;
        while (n4 < 8) {
            colorNode.children[n4] = this.freeTree(colorNode.children[n4]);
            ++n4;
        }
        colorNode.childCount = 0;
    }

    protected ColorNode freeTree(ColorNode colorNode) {
        if (colorNode == null) {
            return null;
        }
        int n = 0;
        while (n < 8) {
            colorNode.children[n] = this.freeTree(colorNode.children[n]);
            ++n;
        }
        --this.numNodes;
        return null;
    }

    protected class ColorNode {
        public boolean isLeaf = false;
        public int childCount = 0;
        ColorNode[] children = new ColorNode[8];
        public int colorCount;
        public long red;
        public long blue;
        public long green;
        public int paletteIndex;
        public int level = 0;
        ColorNode nextReducible;

        public ColorNode() {
            int n = 0;
            while (n < 8) {
                this.children[n] = null;
                ++n;
            }
            this.colorCount = 0;
            this.blue = 0L;
            this.green = 0L;
            this.red = 0L;
            this.paletteIndex = 0;
        }

        public int getLeafChildCount() {
            if (this.isLeaf) {
                return 0;
            }
            int n = 0;
            int n2 = 0;
            while (n2 < this.children.length) {
                if (this.children[n2] != null) {
                    n = this.children[n2].isLeaf ? ++n : (n += this.children[n2].getLeafChildCount());
                }
                ++n2;
            }
            return n;
        }

        public int getRGB() {
            int n = (int)this.red / this.colorCount;
            int n2 = (int)this.green / this.colorCount;
            int n3 = (int)this.blue / this.colorCount;
            int n4 = 0xFF000000 | (0xFF & n) << 16 | (0xFF & n2) << 8 | 0xFF & n3;
            return n4;
        }
    }
}

