/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.common;

import java.io.PrintStream;

public class LZWStringTable {
    private static final int RES_CODES = 2;
    private static final short HASH_FREE = -1;
    private static final short NEXT_FIRST = -1;
    private static final int MAXBITS = 12;
    private static final int MAXSTR = 4096;
    private static final short HASHSIZE = 9973;
    private static final short HASHSTEP = 2039;
    byte[] strChr_ = new byte[4096];
    short[] strNxt_ = new short[4096];
    short[] strHsh_;
    short numStrings_;
    int[] strLen_ = new int[4096];

    public LZWStringTable() {
        this.strHsh_ = new short[9973];
    }

    public int AddCharString(short s, byte by) {
        if (this.numStrings_ >= 4096) {
            return 65535;
        }
        int n = LZWStringTable.Hash(s, by);
        while (this.strHsh_[n] != -1) {
            n = (n + 2039) % 9973;
        }
        this.strHsh_[n] = this.numStrings_;
        this.strChr_[this.numStrings_] = by;
        if (s == -1) {
            this.strNxt_[this.numStrings_] = -1;
            this.strLen_[this.numStrings_] = 1;
        } else {
            this.strNxt_[this.numStrings_] = s;
            this.strLen_[this.numStrings_] = this.strLen_[s] + 1;
        }
        short s2 = this.numStrings_;
        this.numStrings_ = (short)(s2 + 1);
        return s2;
    }

    public short FindCharString(short s, byte by) {
        short s2;
        if (s == -1) {
            return (short)(by & 0xFF);
        }
        int n = LZWStringTable.Hash(s, by);
        while ((s2 = this.strHsh_[n]) != -1) {
            if (this.strNxt_[s2] == s && this.strChr_[s2] == by) {
                return s2;
            }
            n = (n + 2039) % 9973;
        }
        return -1;
    }

    public void ClearTable(int n) {
        this.numStrings_ = 0;
        int n2 = 0;
        while (n2 < 9973) {
            this.strHsh_[n2] = -1;
            ++n2;
        }
        n2 = (1 << n) + 2;
        int n3 = 0;
        while (n3 < n2) {
            this.AddCharString((short)-1, (byte)n3);
            ++n3;
        }
    }

    public static int Hash(short s, byte by) {
        return (((short)(by << 8) ^ s) & 0xFFFF) % 9973;
    }

    public int expandCode(byte[] byArray, int n, short s, int n2) {
        if (n == -2 && n2 == 1) {
            n2 = 0;
        }
        if (s == -1 || n2 == this.strLen_[s]) {
            return 0;
        }
        int n3 = byArray.length - n;
        int n4 = this.strLen_[s] - n2;
        int n5 = n3 > n4 ? n4 : n3;
        int n6 = n4 - n5;
        int n7 = n + n5;
        while (n7 > n && s != -1) {
            if (--n6 < 0) {
                byArray[--n7] = this.strChr_[s];
            }
            s = this.strNxt_[s];
        }
        if (n4 > n5) {
            return -n5;
        }
        return n5;
    }

    public void dump(PrintStream printStream) {
        int n = 258;
        while (n < this.numStrings_) {
            printStream.println(" strNxt_[" + n + "] = " + this.strNxt_[n] + " strChr_ " + Integer.toHexString(this.strChr_[n] & 0xFF) + " strLen_ " + Integer.toHexString(this.strLen_[n]));
            ++n;
        }
    }
}

