/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.common;

import com.sun.media.imageioimpl.common.BitFile;
import com.sun.media.imageioimpl.common.LZWStringTable;
import java.io.IOException;
import java.io.PrintStream;
import javax.imageio.stream.ImageOutputStream;

public class LZWCompressor {
    int codeSize_;
    int clearCode_;
    int endOfInfo_;
    int numBits_;
    int limit_;
    short prefix_;
    BitFile bf_;
    LZWStringTable lzss_;
    boolean tiffFudge_;

    public LZWCompressor(ImageOutputStream imageOutputStream, int n, boolean bl) throws IOException {
        this.bf_ = new BitFile(imageOutputStream, !bl);
        this.codeSize_ = n;
        this.tiffFudge_ = bl;
        this.clearCode_ = 1 << this.codeSize_;
        this.endOfInfo_ = this.clearCode_ + 1;
        this.numBits_ = this.codeSize_ + 1;
        this.limit_ = (1 << this.numBits_) - 1;
        if (this.tiffFudge_) {
            --this.limit_;
        }
        this.prefix_ = (short)-1;
        this.lzss_ = new LZWStringTable();
        this.lzss_.ClearTable(this.codeSize_);
        this.bf_.writeBits(this.clearCode_, this.numBits_);
    }

    public void compress(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            byte by = byArray[n4];
            short s = this.lzss_.FindCharString(this.prefix_, by);
            if (s != -1) {
                this.prefix_ = s;
            } else {
                this.bf_.writeBits(this.prefix_, this.numBits_);
                if (this.lzss_.AddCharString(this.prefix_, by) > this.limit_) {
                    if (this.numBits_ == 12) {
                        this.bf_.writeBits(this.clearCode_, this.numBits_);
                        this.lzss_.ClearTable(this.codeSize_);
                        this.numBits_ = this.codeSize_ + 1;
                    } else {
                        ++this.numBits_;
                    }
                    this.limit_ = (1 << this.numBits_) - 1;
                    if (this.tiffFudge_) {
                        --this.limit_;
                    }
                }
                this.prefix_ = (short)((short)by & 0xFF);
            }
            ++n4;
        }
    }

    public void flush() throws IOException {
        if (this.prefix_ != -1) {
            this.bf_.writeBits(this.prefix_, this.numBits_);
        }
        this.bf_.writeBits(this.endOfInfo_, this.numBits_);
        this.bf_.flush();
    }

    public void dump(PrintStream printStream) {
        this.lzss_.dump(printStream);
    }
}

