/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.common;

import com.sun.media.imageioimpl.common.BogusColorSpace;
import com.sun.media.imageioimpl.common.I18N;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

public class ImageUtil {
    public static final ColorModel createColorModel(SampleModel sampleModel) {
        if (sampleModel == null) {
            throw new IllegalArgumentException("sampleModel == null!");
        }
        int n = sampleModel.getDataType();
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                return null;
            }
        }
        ColorModel colorModel = null;
        int[] nArray = sampleModel.getSampleSize();
        if (sampleModel instanceof ComponentSampleModel) {
            int n2 = sampleModel.getNumBands();
            ColorSpace colorSpace = null;
            colorSpace = n2 <= 2 ? ColorSpace.getInstance(1003) : (n2 <= 4 ? ColorSpace.getInstance(1000) : new BogusColorSpace(n2));
            boolean bl = n2 == 2 || n2 == 4;
            boolean bl2 = false;
            int n3 = bl ? 3 : 1;
            colorModel = new ComponentColorModel(colorSpace, nArray, bl, bl2, n3, n);
        } else {
            if (sampleModel.getNumBands() <= 4 && sampleModel instanceof SinglePixelPackedSampleModel) {
                SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
                int[] nArray2 = singlePixelPackedSampleModel.getBitMasks();
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = nArray2.length;
                if (n8 <= 2) {
                    n5 = n6 = nArray2[0];
                    n4 = n6;
                    if (n8 == 2) {
                        n7 = nArray2[1];
                    }
                } else {
                    n4 = nArray2[0];
                    n5 = nArray2[1];
                    n6 = nArray2[2];
                    if (n8 == 4) {
                        n7 = nArray2[3];
                    }
                }
                int n9 = 0;
                int n10 = 0;
                while (n10 < nArray.length) {
                    n9 += nArray[n10];
                    ++n10;
                }
                return new DirectColorModel(n9, n4, n5, n6, n7);
            }
            if (sampleModel instanceof MultiPixelPackedSampleModel) {
                int n11 = nArray[0];
                int n12 = 1 << n11;
                byte[] byArray = new byte[n12];
                int n13 = 0;
                while (n13 < n12) {
                    byArray[n13] = (byte)(n13 * 255 / (n12 - 1));
                    ++n13;
                }
                colorModel = new IndexColorModel(n11, n12, byArray, byArray, byArray);
            }
        }
        return colorModel;
    }

    public static byte[] getPackedBinaryData(Raster raster, Rectangle rectangle) {
        byte[] byArray;
        block29: {
            int n;
            int n2;
            int n3;
            int n4;
            DataBuffer dataBuffer;
            int n5;
            int n6;
            block27: {
                block30: {
                    block28: {
                        SampleModel sampleModel = raster.getSampleModel();
                        if (!ImageUtil.isBinary(sampleModel)) {
                            throw new IllegalArgumentException(I18N.getString("ImageUtil0"));
                        }
                        int n7 = rectangle.x;
                        int n8 = rectangle.y;
                        n6 = rectangle.width;
                        n5 = rectangle.height;
                        dataBuffer = raster.getDataBuffer();
                        int n9 = n7 - raster.getSampleModelTranslateX();
                        int n10 = n8 - raster.getSampleModelTranslateY();
                        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                        n4 = multiPixelPackedSampleModel.getScanlineStride();
                        n3 = dataBuffer.getOffset() + multiPixelPackedSampleModel.getOffset(n9, n10);
                        n2 = multiPixelPackedSampleModel.getBitOffset(n9);
                        n = (n6 + 7) / 8;
                        if (dataBuffer instanceof DataBufferByte && n3 == 0 && n2 == 0 && n == n4 && ((DataBufferByte)dataBuffer).getData().length == n * n5) {
                            return ((DataBufferByte)dataBuffer).getData();
                        }
                        byArray = new byte[n * n5];
                        int n11 = 0;
                        if (n2 != 0) break block27;
                        if (!(dataBuffer instanceof DataBufferByte)) break block28;
                        byte[] byArray2 = ((DataBufferByte)dataBuffer).getData();
                        int n12 = n;
                        int n13 = 0;
                        int n14 = 0;
                        while (n14 < n5) {
                            System.arraycopy(byArray2, n3, byArray, n13, n12);
                            n13 += n12;
                            n3 += n4;
                            ++n14;
                        }
                        break block29;
                    }
                    if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block30;
                    short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                    int n15 = 0;
                    while (n15 < n5) {
                        int n16 = n6;
                        int n17 = n3;
                        while (n16 > 8) {
                            short s = sArray[n17++];
                            byArray[n11++] = (byte)(s >>> 8 & 0xFF);
                            byArray[n11++] = (byte)(s & 0xFF);
                            n16 -= 16;
                        }
                        if (n16 > 0) {
                            byArray[n11++] = (byte)(sArray[n17] >>> 8 & 0xFF);
                        }
                        n3 += n4;
                        ++n15;
                    }
                    break block29;
                }
                if (!(dataBuffer instanceof DataBufferInt)) break block29;
                int[] nArray = ((DataBufferInt)dataBuffer).getData();
                int n18 = 0;
                while (n18 < n5) {
                    int n19;
                    int n20 = n6;
                    int n21 = n3;
                    while (n20 > 24) {
                        n19 = nArray[n21++];
                        byArray[n11++] = (byte)(n19 >>> 24 & 0xFF);
                        byArray[n11++] = (byte)(n19 >>> 16 & 0xFF);
                        byArray[n11++] = (byte)(n19 >>> 8 & 0xFF);
                        byArray[n11++] = (byte)(n19 & 0xFF);
                        n20 -= 32;
                    }
                    n19 = 24;
                    while (n20 > 0) {
                        byArray[n11++] = (byte)(nArray[n21] >>> n19 & 0xFF);
                        n19 -= 8;
                        n20 -= 8;
                    }
                    n3 += n4;
                    ++n18;
                }
                break block29;
            }
            if (dataBuffer instanceof DataBufferByte) {
                byte[] byArray3 = ((DataBufferByte)dataBuffer).getData();
                if ((n2 & 7) == 0) {
                    int n22 = n;
                    int n23 = 0;
                    int n24 = 0;
                    while (n24 < n5) {
                        System.arraycopy(byArray3, n3, byArray, n23, n22);
                        n23 += n22;
                        n3 += n4;
                        ++n24;
                    }
                } else {
                    int n25 = n2 & 7;
                    int n26 = 8 - n25;
                    int n27 = 0;
                    while (n27 < n5) {
                        int n28 = n3;
                        int n29 = n6;
                        while (n29 > 0) {
                            byArray[n11++] = n29 > n26 ? (byte)((byArray3[n28++] & 0xFF) << n25 | (byArray3[n28] & 0xFF) >>> n26) : (byte)((byArray3[n28] & 0xFF) << n25);
                            n29 -= 8;
                        }
                        n3 += n4;
                        ++n27;
                    }
                }
            } else if (dataBuffer instanceof DataBufferShort || dataBuffer instanceof DataBufferUShort) {
                short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                int n30 = 0;
                while (n30 < n5) {
                    int n31 = n2;
                    int n32 = 0;
                    while (n32 < n6) {
                        int n33 = n3 + n31 / 16;
                        int n34 = n31 % 16;
                        int n35 = sArray[n33] & 0xFFFF;
                        if (n34 <= 8) {
                            byArray[n11++] = (byte)(n35 >>> 8 - n34);
                        } else {
                            int n36 = n34 - 8;
                            int n37 = sArray[n33 + 1] & 0xFFFF;
                            byArray[n11++] = (byte)(n35 << n36 | n37 >>> 16 - n36);
                        }
                        n32 += 8;
                        n31 += 8;
                    }
                    n3 += n4;
                    ++n30;
                }
            } else if (dataBuffer instanceof DataBufferInt) {
                int[] nArray = ((DataBufferInt)dataBuffer).getData();
                int n38 = 0;
                while (n38 < n5) {
                    int n39 = n2;
                    int n40 = 0;
                    while (n40 < n6) {
                        int n41 = n3 + n39 / 32;
                        int n42 = n39 % 32;
                        int n43 = nArray[n41];
                        if (n42 <= 24) {
                            byArray[n11++] = (byte)(n43 >>> 24 - n42);
                        } else {
                            int n44 = n42 - 24;
                            int n45 = nArray[n41 + 1];
                            byArray[n11++] = (byte)(n43 << n44 | n45 >>> 32 - n44);
                        }
                        n40 += 8;
                        n39 += 8;
                    }
                    n3 += n4;
                    ++n38;
                }
            }
        }
        return byArray;
    }

    public static byte[] getUnpackedBinaryData(Raster raster, Rectangle rectangle) {
        byte[] byArray;
        block8: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            DataBuffer dataBuffer;
            int n6;
            int n7;
            block9: {
                block7: {
                    SampleModel sampleModel = raster.getSampleModel();
                    if (!ImageUtil.isBinary(sampleModel)) {
                        throw new IllegalArgumentException(I18N.getString("ImageUtil0"));
                    }
                    n7 = rectangle.x;
                    n6 = rectangle.y;
                    int n8 = rectangle.width;
                    int n9 = rectangle.height;
                    dataBuffer = raster.getDataBuffer();
                    int n10 = n7 - raster.getSampleModelTranslateX();
                    int n11 = n6 - raster.getSampleModelTranslateY();
                    MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                    n5 = multiPixelPackedSampleModel.getScanlineStride();
                    n4 = dataBuffer.getOffset() + multiPixelPackedSampleModel.getOffset(n10, n11);
                    n3 = multiPixelPackedSampleModel.getBitOffset(n10);
                    byArray = new byte[n8 * n9];
                    n2 = n6 + n9;
                    n = n7 + n8;
                    int n12 = 0;
                    if (!(dataBuffer instanceof DataBufferByte)) break block7;
                    byte[] byArray2 = ((DataBufferByte)dataBuffer).getData();
                    int n13 = n6;
                    while (n13 < n2) {
                        int n14 = n4 * 8 + n3;
                        int n15 = n7;
                        while (n15 < n) {
                            byte by = byArray2[n14 / 8];
                            byArray[n12++] = (byte)(by >>> (7 - n14 & 7) & 1);
                            ++n14;
                            ++n15;
                        }
                        n4 += n5;
                        ++n13;
                    }
                    break block8;
                }
                if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block9;
                short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                int n16 = n6;
                while (n16 < n2) {
                    int n17 = n4 * 16 + n3;
                    int n18 = n7;
                    while (n18 < n) {
                        short s = sArray[n17 / 16];
                        byArray[n12++] = (byte)(s >>> 15 - n17 % 16 & 1);
                        ++n17;
                        ++n18;
                    }
                    n4 += n5;
                    ++n16;
                }
                break block8;
            }
            if (!(dataBuffer instanceof DataBufferInt)) break block8;
            int[] nArray = ((DataBufferInt)dataBuffer).getData();
            int n19 = n6;
            while (n19 < n2) {
                int n20 = n4 * 32 + n3;
                int n21 = n7;
                while (n21 < n) {
                    int n22 = nArray[n20 / 32];
                    byArray[n12++] = (byte)(n22 >>> 31 - n20 % 32 & 1);
                    ++n20;
                    ++n21;
                }
                n4 += n5;
                ++n19;
            }
        }
        return byArray;
    }

    public static void setPackedBinaryData(byte[] byArray, WritableRaster writableRaster, Rectangle rectangle) {
        block43: {
            int n;
            int n2;
            int n3;
            int n4;
            DataBuffer dataBuffer;
            int n5;
            int n6;
            block41: {
                block44: {
                    block42: {
                        SampleModel sampleModel = writableRaster.getSampleModel();
                        if (!ImageUtil.isBinary(sampleModel)) {
                            throw new IllegalArgumentException(I18N.getString("ImageUtil0"));
                        }
                        int n7 = rectangle.x;
                        int n8 = rectangle.y;
                        n6 = rectangle.width;
                        n5 = rectangle.height;
                        dataBuffer = writableRaster.getDataBuffer();
                        int n9 = n7 - writableRaster.getSampleModelTranslateX();
                        int n10 = n8 - writableRaster.getSampleModelTranslateY();
                        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                        n4 = multiPixelPackedSampleModel.getScanlineStride();
                        n3 = dataBuffer.getOffset() + multiPixelPackedSampleModel.getOffset(n9, n10);
                        n2 = multiPixelPackedSampleModel.getBitOffset(n9);
                        n = 0;
                        if (n2 != 0) break block41;
                        if (!(dataBuffer instanceof DataBufferByte)) break block42;
                        byte[] byArray2 = ((DataBufferByte)dataBuffer).getData();
                        if (byArray2 == byArray) {
                            return;
                        }
                        int n11 = (n6 + 7) / 8;
                        int n12 = 0;
                        int n13 = 0;
                        while (n13 < n5) {
                            System.arraycopy(byArray, n12, byArray2, n3, n11);
                            n12 += n11;
                            n3 += n4;
                            ++n13;
                        }
                        break block43;
                    }
                    if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block44;
                    short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                    int n14 = 0;
                    while (n14 < n5) {
                        int n15 = n6;
                        int n16 = n3;
                        while (n15 > 8) {
                            sArray[n16++] = (short)((byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
                            n15 -= 16;
                        }
                        if (n15 > 0) {
                            sArray[n16++] = (short)((byArray[n++] & 0xFF) << 8);
                        }
                        n3 += n4;
                        ++n14;
                    }
                    break block43;
                }
                if (!(dataBuffer instanceof DataBufferInt)) break block43;
                int[] nArray = ((DataBufferInt)dataBuffer).getData();
                int n17 = 0;
                while (n17 < n5) {
                    int n18 = n6;
                    int n19 = n3;
                    while (n18 > 24) {
                        nArray[n19++] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                        n18 -= 32;
                    }
                    int n20 = 24;
                    while (n18 > 0) {
                        int n21 = n19;
                        nArray[n21] = nArray[n21] | (byArray[n++] & 0xFF) << n20;
                        n20 -= 8;
                        n18 -= 8;
                    }
                    n3 += n4;
                    ++n17;
                }
                break block43;
            }
            int n22 = (n6 + 7) / 8;
            int n23 = 0;
            if (dataBuffer instanceof DataBufferByte) {
                byte[] byArray3 = ((DataBufferByte)dataBuffer).getData();
                if ((n2 & 7) == 0) {
                    int n24 = 0;
                    while (n24 < n5) {
                        System.arraycopy(byArray, n23, byArray3, n3, n22);
                        n23 += n22;
                        n3 += n4;
                        ++n24;
                    }
                } else {
                    int n25 = n2 & 7;
                    int n26 = 8 - n25;
                    int n27 = 8 + n26;
                    byte by = (byte)(255 << n26);
                    byte by2 = ~by;
                    int n28 = 0;
                    while (n28 < n5) {
                        int n29 = n3;
                        int n30 = n6;
                        while (n30 > 0) {
                            byte by3 = byArray[n++];
                            if (n30 > n27) {
                                byArray3[n29] = (byte)(byArray3[n29] & by | (by3 & 0xFF) >>> n25);
                                byArray3[++n29] = (byte)((by3 & 0xFF) << n26);
                            } else if (n30 > n26) {
                                byArray3[n29] = (byte)(byArray3[n29] & by | (by3 & 0xFF) >>> n25);
                                byArray3[++n29] = (byte)(byArray3[n29] & by2 | (by3 & 0xFF) << n26);
                            } else {
                                int n31 = (1 << n26 - n30) - 1;
                                byArray3[n29] = (byte)(byArray3[n29] & (by | n31) | (by3 & 0xFF) >>> n25 & ~n31);
                            }
                            n30 -= 8;
                        }
                        n3 += n4;
                        ++n28;
                    }
                }
            } else if (dataBuffer instanceof DataBufferShort || dataBuffer instanceof DataBufferUShort) {
                short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                int n32 = n2 & 7;
                int n33 = 8 - n32;
                int n34 = 16 + n33;
                short s = (short)(~(255 << n33));
                short s2 = (short)(65535 << n33);
                short s3 = ~s2;
                int n35 = 0;
                while (n35 < n5) {
                    int n36 = n2;
                    int n37 = n6;
                    int n38 = 0;
                    while (n38 < n6) {
                        int n39 = n3 + (n36 >> 4);
                        int n40 = n36 & 0xF;
                        int n41 = byArray[n++] & 0xFF;
                        if (n40 <= 8) {
                            if (n37 < 8) {
                                n41 &= 255 << 8 - n37;
                            }
                            sArray[n39] = (short)(sArray[n39] & s | n41 << n33);
                        } else if (n37 > n34) {
                            sArray[n39] = (short)(sArray[n39] & s2 | n41 >>> n32 & 0xFFFF);
                            sArray[++n39] = (short)(n41 << n33 & 0xFFFF);
                        } else if (n37 > n33) {
                            sArray[n39] = (short)(sArray[n39] & s2 | n41 >>> n32 & 0xFFFF);
                            sArray[++n39] = (short)(sArray[n39] & s3 | n41 << n33 & 0xFFFF);
                        } else {
                            int n42 = (1 << n33 - n37) - 1;
                            sArray[n39] = (short)(sArray[n39] & (s2 | n42) | n41 >>> n32 & 0xFFFF & ~n42);
                        }
                        n38 += 8;
                        n36 += 8;
                        n37 -= 8;
                    }
                    n3 += n4;
                    ++n35;
                }
            } else if (dataBuffer instanceof DataBufferInt) {
                int[] nArray = ((DataBufferInt)dataBuffer).getData();
                int n43 = n2 & 7;
                int n44 = 8 - n43;
                int n45 = 32 + n44;
                int n46 = -1 << n44;
                int n47 = ~n46;
                int n48 = 0;
                while (n48 < n5) {
                    int n49 = n2;
                    int n50 = n6;
                    int n51 = 0;
                    while (n51 < n6) {
                        int n52;
                        int n53 = n3 + (n49 >> 5);
                        int n54 = n49 & 0x1F;
                        int n55 = byArray[n++] & 0xFF;
                        if (n54 <= 24) {
                            n52 = 24 - n54;
                            if (n50 < 8) {
                                n55 &= 255 << 8 - n50;
                            }
                            nArray[n53] = nArray[n53] & ~(255 << n52) | n55 << n52;
                        } else if (n50 > n45) {
                            nArray[n53] = nArray[n53] & n46 | n55 >>> n43;
                            nArray[++n53] = n55 << n44;
                        } else if (n50 > n44) {
                            nArray[n53] = nArray[n53] & n46 | n55 >>> n43;
                            nArray[++n53] = nArray[n53] & n47 | n55 << n44;
                        } else {
                            n52 = (1 << n44 - n50) - 1;
                            nArray[n53] = nArray[n53] & (n46 | n52) | n55 >>> n43 & ~n52;
                        }
                        n51 += 8;
                        n49 += 8;
                        n50 -= 8;
                    }
                    n3 += n4;
                    ++n48;
                }
            }
        }
    }

    public static void setUnpackedBinaryData(byte[] byArray, WritableRaster writableRaster, Rectangle rectangle) {
        block11: {
            int n;
            int n2;
            int n3;
            int n4;
            DataBuffer dataBuffer;
            int n5;
            int n6;
            block12: {
                block10: {
                    SampleModel sampleModel = writableRaster.getSampleModel();
                    if (!ImageUtil.isBinary(sampleModel)) {
                        throw new IllegalArgumentException(I18N.getString("ImageUtil0"));
                    }
                    int n7 = rectangle.x;
                    int n8 = rectangle.y;
                    n6 = rectangle.width;
                    n5 = rectangle.height;
                    dataBuffer = writableRaster.getDataBuffer();
                    int n9 = n7 - writableRaster.getSampleModelTranslateX();
                    int n10 = n8 - writableRaster.getSampleModelTranslateY();
                    MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                    n4 = multiPixelPackedSampleModel.getScanlineStride();
                    n3 = dataBuffer.getOffset() + multiPixelPackedSampleModel.getOffset(n9, n10);
                    n2 = multiPixelPackedSampleModel.getBitOffset(n9);
                    n = 0;
                    if (!(dataBuffer instanceof DataBufferByte)) break block10;
                    byte[] byArray2 = ((DataBufferByte)dataBuffer).getData();
                    int n11 = 0;
                    while (n11 < n5) {
                        int n12 = n3 * 8 + n2;
                        int n13 = 0;
                        while (n13 < n6) {
                            if (byArray[n++] != 0) {
                                int n14 = n12 / 8;
                                byArray2[n14] = (byte)(byArray2[n14] | (byte)(1 << (7 - n12 & 7)));
                            }
                            ++n12;
                            ++n13;
                        }
                        n3 += n4;
                        ++n11;
                    }
                    break block11;
                }
                if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block12;
                short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                int n15 = 0;
                while (n15 < n5) {
                    int n16 = n3 * 16 + n2;
                    int n17 = 0;
                    while (n17 < n6) {
                        if (byArray[n++] != 0) {
                            int n18 = n16 / 16;
                            sArray[n18] = (short)(sArray[n18] | (short)(1 << 15 - n16 % 16));
                        }
                        ++n16;
                        ++n17;
                    }
                    n3 += n4;
                    ++n15;
                }
                break block11;
            }
            if (!(dataBuffer instanceof DataBufferInt)) break block11;
            int[] nArray = ((DataBufferInt)dataBuffer).getData();
            int n19 = 0;
            while (n19 < n5) {
                int n20 = n3 * 32 + n2;
                int n21 = 0;
                while (n21 < n6) {
                    if (byArray[n++] != 0) {
                        int n22 = n20 / 32;
                        nArray[n22] = nArray[n22] | 1 << 31 - n20 % 32;
                    }
                    ++n20;
                    ++n21;
                }
                n3 += n4;
                ++n19;
            }
        }
    }

    public static boolean isBinary(SampleModel sampleModel) {
        return sampleModel instanceof MultiPixelPackedSampleModel && ((MultiPixelPackedSampleModel)sampleModel).getPixelBitStride() == 1 && sampleModel.getNumBands() == 1;
    }

    public static ColorModel createColorModel(ColorSpace colorSpace, SampleModel sampleModel) {
        ColorModel colorModel = null;
        if (sampleModel == null) {
            throw new IllegalArgumentException(I18N.getString("ImageUtil1"));
        }
        int n = sampleModel.getNumBands();
        if (n < 1 || n > 4) {
            return null;
        }
        int n2 = sampleModel.getDataType();
        if (sampleModel instanceof ComponentSampleModel) {
            if (n2 < 0 || n2 > 5) {
                return null;
            }
            if (colorSpace == null) {
                colorSpace = n <= 2 ? ColorSpace.getInstance(1003) : ColorSpace.getInstance(1000);
            }
            boolean bl = n == 2 || n == 4;
            int n3 = bl ? 3 : 1;
            boolean bl2 = false;
            int n4 = DataBuffer.getDataTypeSize(n2);
            int[] nArray = new int[n];
            int n5 = 0;
            while (n5 < n) {
                nArray[n5] = n4;
                ++n5;
            }
            colorModel = new ComponentColorModel(colorSpace, nArray, bl, bl2, n3, n2);
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
            int[] nArray = singlePixelPackedSampleModel.getBitMasks();
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            n = nArray.length;
            if (n <= 2) {
                n7 = n8 = nArray[0];
                n6 = n8;
                if (n == 2) {
                    n9 = nArray[1];
                }
            } else {
                n6 = nArray[0];
                n7 = nArray[1];
                n8 = nArray[2];
                if (n == 4) {
                    n9 = nArray[3];
                }
            }
            int[] nArray2 = singlePixelPackedSampleModel.getSampleSize();
            int n10 = 0;
            int n11 = 0;
            while (n11 < nArray2.length) {
                n10 += nArray2[n11];
                ++n11;
            }
            if (colorSpace == null) {
                colorSpace = ColorSpace.getInstance(1000);
            }
            colorModel = new DirectColorModel(colorSpace, n10, n6, n7, n8, n9, false, sampleModel.getDataType());
        } else if (sampleModel instanceof MultiPixelPackedSampleModel) {
            int n12 = ((MultiPixelPackedSampleModel)sampleModel).getPixelBitStride();
            int n13 = 1 << n12;
            byte[] byArray = new byte[n13];
            int n14 = 0;
            while (n14 < n13) {
                byArray[n14] = (byte)(255 * n14 / (n13 - 1));
                ++n14;
            }
            colorModel = new IndexColorModel(n12, n13, byArray, byArray, byArray);
        }
        return colorModel;
    }

    public static int getElementSize(SampleModel sampleModel) {
        int n = DataBuffer.getDataTypeSize(sampleModel.getDataType());
        if (sampleModel instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
            return multiPixelPackedSampleModel.getSampleSize(0) * multiPixelPackedSampleModel.getNumBands();
        }
        if (sampleModel instanceof ComponentSampleModel) {
            return sampleModel.getNumBands() * n;
        }
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            return n;
        }
        return n * sampleModel.getNumBands();
    }

    public static long getTileSize(SampleModel sampleModel) {
        int n = DataBuffer.getDataTypeSize(sampleModel.getDataType());
        if (sampleModel instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
            return (multiPixelPackedSampleModel.getScanlineStride() * multiPixelPackedSampleModel.getHeight() + (multiPixelPackedSampleModel.getDataBitOffset() + n - 1) / n) * ((n + 7) / 8);
        }
        if (sampleModel instanceof ComponentSampleModel) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
            int[] nArray = componentSampleModel.getBandOffsets();
            int n2 = nArray[0];
            int n3 = 1;
            while (n3 < nArray.length) {
                n2 = Math.max(n2, nArray[n3]);
                ++n3;
            }
            long l = 0L;
            int n4 = componentSampleModel.getPixelStride();
            int n5 = componentSampleModel.getScanlineStride();
            if (n2 >= 0) {
                l += (long)(n2 + 1);
            }
            if (n4 > 0) {
                l += (long)(n4 * (sampleModel.getWidth() - 1));
            }
            if (n5 > 0) {
                l += (long)(n5 * (sampleModel.getHeight() - 1));
            }
            int[] nArray2 = componentSampleModel.getBankIndices();
            n2 = nArray2[0];
            int n6 = 1;
            while (n6 < nArray2.length) {
                n2 = Math.max(n2, nArray2[n6]);
                ++n6;
            }
            return l * (long)(n2 + 1) * (long)((n + 7) / 8);
        }
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
            long l = singlePixelPackedSampleModel.getScanlineStride() * (singlePixelPackedSampleModel.getHeight() - 1) + singlePixelPackedSampleModel.getWidth();
            return l * (long)((n + 7) / 8);
        }
        return 0L;
    }

    public static long getBandSize(SampleModel sampleModel) {
        int n = DataBuffer.getDataTypeSize(sampleModel.getDataType());
        if (sampleModel instanceof ComponentSampleModel) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
            int n2 = componentSampleModel.getPixelStride();
            int n3 = componentSampleModel.getScanlineStride();
            long l = Math.min(n2, n3);
            if (n2 > 0) {
                l += (long)(n2 * (sampleModel.getWidth() - 1));
            }
            if (n3 > 0) {
                l += (long)(n3 * (sampleModel.getHeight() - 1));
            }
            return l * (long)((n + 7) / 8);
        }
        return ImageUtil.getTileSize(sampleModel);
    }

    public static boolean isGrayscaleMapping(IndexColorModel indexColorModel) {
        int n;
        if (indexColorModel == null) {
            throw new IllegalArgumentException("icm == null!");
        }
        int n2 = indexColorModel.getMapSize();
        byte[] byArray = new byte[n2];
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        boolean bl = true;
        int n3 = 0;
        while (n3 < n2) {
            n = n3 * 255 / (n2 - 1);
            if (byArray[n3] != n || byArray2[n3] != n || byArray3[n3] != n) {
                bl = false;
                break;
            }
            ++n3;
        }
        if (!bl) {
            bl = true;
            n3 = 0;
            n = n2 - 1;
            while (n3 < n2) {
                byte by = (byte)(n * 255 / (n2 - 1));
                if (byArray[n3] != by || byArray2[n3] != by || byArray3[n3] != by) {
                    bl = false;
                    break;
                }
                ++n3;
                --n;
            }
        }
        return bl;
    }

    public static boolean isIndicesForGrayscale(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (byArray.length != byArray2.length || byArray.length != byArray3.length) {
            return false;
        }
        int n = byArray.length;
        if (n != 256) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            byte by = (byte)n2;
            if (byArray[n2] != by || byArray2[n2] != by || byArray3[n2] != by) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static String convertObjectToString(Object object) {
        if (object == null) {
            return "";
        }
        String string = "";
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            int n = 0;
            while (n < byArray.length) {
                string = String.valueOf(string) + byArray[n] + " ";
                ++n;
            }
            return string;
        }
        if (object instanceof int[]) {
            int[] nArray = (int[])object;
            int n = 0;
            while (n < nArray.length) {
                string = String.valueOf(string) + nArray[n] + " ";
                ++n;
            }
            return string;
        }
        if (object instanceof short[]) {
            short[] sArray = (short[])object;
            int n = 0;
            while (n < sArray.length) {
                string = String.valueOf(string) + sArray[n] + " ";
                ++n;
            }
            return string;
        }
        return object.toString();
    }

    public static final void canEncodeImage(ImageWriter imageWriter, ImageTypeSpecifier imageTypeSpecifier) throws IIOException {
        ImageWriterSpi imageWriterSpi = imageWriter.getOriginatingProvider();
        if (imageTypeSpecifier != null && imageWriterSpi != null && !imageWriterSpi.canEncodeImage(imageTypeSpecifier)) {
            throw new IIOException(String.valueOf(I18N.getString("ImageUtil2")) + " " + imageWriter.getClass().getName());
        }
    }

    public static final void canEncodeImage(ImageWriter imageWriter, ColorModel colorModel, SampleModel sampleModel) throws IIOException {
        ImageTypeSpecifier imageTypeSpecifier = null;
        if (colorModel != null && sampleModel != null) {
            imageTypeSpecifier = new ImageTypeSpecifier(colorModel, sampleModel);
        }
        ImageUtil.canEncodeImage(imageWriter, imageTypeSpecifier);
    }

    public static final boolean imageIsContiguous(RenderedImage renderedImage) {
        SampleModel sampleModel;
        Object object;
        if (renderedImage instanceof BufferedImage) {
            object = ((BufferedImage)renderedImage).getRaster();
            sampleModel = ((Raster)object).getSampleModel();
        } else {
            sampleModel = renderedImage.getSampleModel();
        }
        if (sampleModel instanceof ComponentSampleModel) {
            object = (ComponentSampleModel)sampleModel;
            if (((ComponentSampleModel)object).getPixelStride() != ((SampleModel)object).getNumBands()) {
                return false;
            }
            int[] nArray = ((ComponentSampleModel)object).getBandOffsets();
            int n = 0;
            while (n < nArray.length) {
                if (nArray[n] != n) {
                    return false;
                }
                ++n;
            }
            int[] nArray2 = ((ComponentSampleModel)object).getBankIndices();
            int n2 = 0;
            while (n2 < nArray.length) {
                if (nArray2[n2] != 0) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return ImageUtil.isBinary(sampleModel);
    }

    public static final ImageTypeSpecifier getDestinationType(ImageReadParam imageReadParam, Iterator iterator) throws IIOException {
        if (iterator == null || !iterator.hasNext()) {
            throw new IllegalArgumentException("imageTypes null or empty!");
        }
        ImageTypeSpecifier imageTypeSpecifier = null;
        if (imageReadParam != null) {
            imageTypeSpecifier = imageReadParam.getDestinationType();
        }
        if (imageTypeSpecifier == null) {
            Object e = iterator.next();
            if (!(e instanceof ImageTypeSpecifier)) {
                throw new IllegalArgumentException("Non-ImageTypeSpecifier retrieved from imageTypes!");
            }
            imageTypeSpecifier = (ImageTypeSpecifier)e;
        } else {
            boolean bl = false;
            while (iterator.hasNext()) {
                ImageTypeSpecifier imageTypeSpecifier2 = (ImageTypeSpecifier)iterator.next();
                if (!imageTypeSpecifier2.equals(imageTypeSpecifier)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new IIOException("Destination type from ImageReadParam does not match!");
            }
        }
        return imageTypeSpecifier;
    }

    public static boolean isNonStandardICCColorSpace(ColorSpace colorSpace) {
        boolean bl = false;
        try {
            bl = colorSpace instanceof ICC_ColorSpace && !colorSpace.isCS_sRGB() && !colorSpace.equals(ColorSpace.getInstance(1004)) && !colorSpace.equals(ColorSpace.getInstance(1003)) && !colorSpace.equals(ColorSpace.getInstance(1001)) && !colorSpace.equals(ColorSpace.getInstance(1002));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return bl;
    }

    public static List getJDKImageReaderWriterSPI(ServiceRegistry serviceRegistry, String string, boolean bl) {
        String string2;
        Class clazz;
        IIORegistry iIORegistry = (IIORegistry)serviceRegistry;
        if (bl) {
            clazz = ImageReaderSpi.class;
            string2 = " image reader";
        } else {
            clazz = ImageWriterSpi.class;
            string2 = " image writer";
        }
        Iterator<ImageReaderSpi> iterator = iIORegistry.getServiceProviders(clazz, true);
        String string3 = "standard " + string + string2;
        String string4 = "com.sun.media.imageioimpl";
        Locale locale = Locale.getDefault();
        ArrayList<ImageReaderWriterSpi> arrayList = new ArrayList<ImageReaderWriterSpi>();
        block0: while (iterator.hasNext()) {
            ImageReaderWriterSpi imageReaderWriterSpi = iterator.next();
            if (!imageReaderWriterSpi.getVendorName().startsWith("Sun Microsystems") || !string3.equalsIgnoreCase(imageReaderWriterSpi.getDescription(locale)) || imageReaderWriterSpi.getPluginClassName().startsWith(string4)) continue;
            String[] stringArray = imageReaderWriterSpi.getFormatNames();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equalsIgnoreCase(string)) {
                    arrayList.add(imageReaderWriterSpi);
                    continue block0;
                }
                ++n;
            }
        }
        return arrayList;
    }

    public static void processOnRegistration(ServiceRegistry serviceRegistry, Class clazz, String string, ImageReaderWriterSpi imageReaderWriterSpi, int n, int n2) {
        String string2 = System.getProperty("java.vendor");
        String string3 = System.getProperty("java.specification.version");
        int n3 = string3.indexOf("1.");
        string3 = string3.substring(n3 + 2);
        int n4 = Integer.parseInt(string3);
        if (string2.equals("Sun Microsystems Inc.")) {
            List list = imageReaderWriterSpi instanceof ImageReaderSpi ? ImageUtil.getJDKImageReaderWriterSPI(serviceRegistry, string, true) : ImageUtil.getJDKImageReaderWriterSPI(serviceRegistry, string, false);
            if (n4 >= n && list.size() != 0) {
                serviceRegistry.deregisterServiceProvider(imageReaderWriterSpi, clazz);
            } else {
                int n5 = 0;
                while (n5 < list.size()) {
                    if (n4 >= n2) {
                        serviceRegistry.setOrdering(clazz, list.get(n5), imageReaderWriterSpi);
                    } else {
                        serviceRegistry.setOrdering(clazz, imageReaderWriterSpi, list.get(n5));
                    }
                    ++n5;
                }
            }
        }
    }

    public static int readMultiByteInteger(ImageInputStream imageInputStream) throws IOException {
        byte by = imageInputStream.readByte();
        int n = by & 0x7F;
        while ((by & 0x80) == 128) {
            n <<= 7;
            by = imageInputStream.readByte();
            n |= by & 0x7F;
        }
        return n;
    }
}

