/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.common;

import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;

public class BitFile {
    ImageOutputStream output_;
    byte[] buffer_;
    int index_;
    int bitsLeft_;
    boolean blocks_ = false;

    public BitFile(ImageOutputStream imageOutputStream, boolean bl) {
        this.output_ = imageOutputStream;
        this.blocks_ = bl;
        this.buffer_ = new byte[256];
        this.index_ = 0;
        this.bitsLeft_ = 8;
    }

    public void flush() throws IOException {
        int n = this.index_ + (this.bitsLeft_ == 8 ? 0 : 1);
        if (n > 0) {
            if (this.blocks_) {
                this.output_.write(n);
            }
            this.output_.write(this.buffer_, 0, n);
            this.buffer_[0] = 0;
            this.index_ = 0;
            this.bitsLeft_ = 8;
        }
    }

    public void writeBits(int n, int n2) throws IOException {
        int n3 = 255;
        do {
            if (this.index_ == 254 && this.bitsLeft_ == 0 || this.index_ > 254) {
                if (this.blocks_) {
                    this.output_.write(n3);
                }
                this.output_.write(this.buffer_, 0, n3);
                this.buffer_[0] = 0;
                this.index_ = 0;
                this.bitsLeft_ = 8;
            }
            if (n2 <= this.bitsLeft_) {
                if (this.blocks_) {
                    int n4 = this.index_;
                    this.buffer_[n4] = (byte)(this.buffer_[n4] | (n & (1 << n2) - 1) << 8 - this.bitsLeft_);
                    this.bitsLeft_ -= n2;
                    n2 = 0;
                    continue;
                }
                int n5 = this.index_;
                this.buffer_[n5] = (byte)(this.buffer_[n5] | (n & (1 << n2) - 1) << this.bitsLeft_ - n2);
                this.bitsLeft_ -= n2;
                n2 = 0;
                continue;
            }
            if (this.blocks_) {
                int n6 = this.index_++;
                this.buffer_[n6] = (byte)(this.buffer_[n6] | (n & (1 << this.bitsLeft_) - 1) << 8 - this.bitsLeft_);
                n >>= this.bitsLeft_;
                n2 -= this.bitsLeft_;
                this.buffer_[this.index_] = 0;
                this.bitsLeft_ = 8;
                continue;
            }
            int n7 = n >>> n2 - this.bitsLeft_ & (1 << this.bitsLeft_) - 1;
            int n8 = this.index_++;
            this.buffer_[n8] = (byte)(this.buffer_[n8] | n7);
            n2 -= this.bitsLeft_;
            this.buffer_[this.index_] = 0;
            this.bitsLeft_ = 8;
        } while (n2 != 0);
    }
}

