/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageio.stream;

import com.sun.media.imageio.stream.I18N;
import com.sun.media.imageioimpl.common.ImageUtil;
import java.awt.Dimension;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteOrder;
import java.util.StringTokenizer;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.IIOByteBuffer;
import javax.imageio.stream.ImageInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RawImageInputStream
implements ImageInputStream {
    private static final String[] preDefinedColorSpaces = new String[]{"GRAY", "sRGB", "LINEAR_RGB", "PYCC", "CIEXYZ"};
    private static final int[] preDefinedTypes = new int[]{1003, 1000, 1004, 1002, 1001};
    private ImageInputStream source;
    private ImageTypeSpecifier type;
    private long[] imageOffsets;
    private Dimension[] imageDimensions;

    private static String getAttribute(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        return (node = namedNodeMap.getNamedItem(string)) != null ? node.getNodeValue() : null;
    }

    private static boolean getBoolean(Node node, String string) {
        String string2 = RawImageInputStream.getAttribute(node, string);
        return string2 == null ? false : new Boolean(string2);
    }

    private static int getInt(Node node, String string) {
        String string2 = RawImageInputStream.getAttribute(node, string);
        return string2 == null ? 0 : new Integer(string2);
    }

    private static byte[] getByteArray(Node node, String string) {
        String string2 = RawImageInputStream.getAttribute(node, string);
        if (string2 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        int n = stringTokenizer.countTokens();
        if (n == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreElements()) {
            byArray[n2++] = new Byte(stringTokenizer.nextToken());
        }
        return byArray;
    }

    private static int[] getIntArray(Node node, String string) {
        String string2 = RawImageInputStream.getAttribute(node, string);
        if (string2 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        int n = stringTokenizer.countTokens();
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreElements()) {
            nArray[n2++] = new Integer(stringTokenizer.nextToken());
        }
        return nArray;
    }

    private static int getTransparency(String string) {
        if ("BITMASK".equals(string)) {
            return 2;
        }
        if ("OPAQUE".equals(string)) {
            return 1;
        }
        if ("TRANSLUCENT".equals(string)) {
            return 3;
        }
        return 0;
    }

    private static ColorSpace getColorSpace(Node node) throws IOException {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if ("colorSpace".equals(node2.getNodeName())) {
                String string = node2.getNodeValue();
                int n2 = 0;
                while (n2 < preDefinedColorSpaces.length) {
                    if (preDefinedColorSpaces[n2].equals(string)) {
                        return ColorSpace.getInstance(preDefinedTypes[n2]);
                    }
                    ++n2;
                }
                InputStream inputStream = new URL(string).openStream();
                ICC_ColorSpace iCC_ColorSpace = new ICC_ColorSpace(ICC_Profile.getInstance(inputStream));
                inputStream.close();
                return iCC_ColorSpace;
            }
            ++n;
        }
        return null;
    }

    public RawImageInputStream(ImageInputStream imageInputStream, ImageTypeSpecifier imageTypeSpecifier, long[] lArray, Dimension[] dimensionArray) {
        if (lArray == null || dimensionArray == null || lArray.length != dimensionArray.length) {
            throw new IllegalArgumentException(I18N.getString("RawImageInputStream0"));
        }
        this.source = imageInputStream;
        this.type = imageTypeSpecifier;
        this.imageOffsets = lArray;
        this.imageDimensions = dimensionArray;
    }

    public RawImageInputStream(ImageInputStream imageInputStream, SampleModel sampleModel, long[] lArray, Dimension[] dimensionArray) {
        if (lArray == null || dimensionArray == null || lArray.length != dimensionArray.length) {
            throw new IllegalArgumentException(I18N.getString("RawImageInputStream0"));
        }
        this.source = imageInputStream;
        ColorModel colorModel = ImageUtil.createColorModel(sampleModel);
        if (colorModel == null) {
            throw new IllegalArgumentException(I18N.getString("RawImageInputStream4"));
        }
        this.type = new ImageTypeSpecifier(colorModel, sampleModel);
        this.imageOffsets = lArray;
        this.imageDimensions = dimensionArray;
    }

    public RawImageInputStream(ImageInputStream imageInputStream, InputSource inputSource) throws SAXException, IOException {
        Object object;
        Object object2;
        this.source = imageInputStream;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(true);
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(I18N.getString("RawImageInputStream1"), parserConfigurationException);
        }
        Document document = documentBuilder.parse(inputSource);
        NodeList nodeList = document.getElementsByTagName("byteOrder");
        String string = nodeList.item(0).getNodeValue();
        if ("NETWORK".equals(string)) {
            this.setByteOrder(ByteOrder.BIG_ENDIAN);
            this.source.setByteOrder(ByteOrder.BIG_ENDIAN);
        } else if ("REVERSE".equals(string)) {
            this.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            this.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        }
        nodeList = document.getElementsByTagName("offset");
        int n = nodeList.getLength();
        this.imageOffsets = new long[n];
        int n2 = 0;
        while (n2 < n) {
            this.imageOffsets[n2] = new Long(nodeList.item(n2).getNodeValue());
            ++n2;
        }
        nodeList = document.getElementsByTagName("width");
        NodeList nodeList2 = document.getElementsByTagName("height");
        n = nodeList.getLength();
        if (n != nodeList2.getLength()) {
            throw new IllegalArgumentException(I18N.getString("RawImageInputStream2"));
        }
        this.imageDimensions = new Dimension[n];
        int n3 = 0;
        while (n3 < n) {
            object2 = nodeList.item(n3).getNodeValue();
            object = nodeList2.item(n3).getNodeValue();
            this.imageDimensions[n3] = new Dimension(new Integer((String)object2), new Integer((String)object));
            ++n3;
        }
        SampleModel sampleModel = null;
        nodeList = document.getElementsByTagName("ComponentSampleModel");
        if (nodeList.getLength() > 0) {
            object2 = nodeList.item(0);
            object = RawImageInputStream.getIntArray((Node)object2, "bankIndices");
            sampleModel = object == null ? new ComponentSampleModel(RawImageInputStream.getInt((Node)object2, "dataType"), RawImageInputStream.getInt((Node)object2, "w"), RawImageInputStream.getInt((Node)object2, "h"), RawImageInputStream.getInt((Node)object2, "pixelStride"), RawImageInputStream.getInt((Node)object2, "scanlineStride"), RawImageInputStream.getIntArray((Node)object2, "bandOffsets")) : new ComponentSampleModel(RawImageInputStream.getInt((Node)object2, "dataType"), RawImageInputStream.getInt((Node)object2, "w"), RawImageInputStream.getInt((Node)object2, "h"), RawImageInputStream.getInt((Node)object2, "pixelStride"), RawImageInputStream.getInt((Node)object2, "scanlineStride"), (int[])object, RawImageInputStream.getIntArray((Node)object2, "bandOffsets"));
        }
        if ((nodeList = document.getElementsByTagName("MultiPixelPackedSampleModel")).getLength() > 0) {
            object2 = nodeList.item(0);
            sampleModel = new MultiPixelPackedSampleModel(RawImageInputStream.getInt((Node)object2, "dataType"), RawImageInputStream.getInt((Node)object2, "w"), RawImageInputStream.getInt((Node)object2, "h"), RawImageInputStream.getInt((Node)object2, "numberOfBits"), RawImageInputStream.getInt((Node)object2, "scanlineStride"), RawImageInputStream.getInt((Node)object2, "dataBitOffset"));
        }
        if ((nodeList = document.getElementsByTagName("SinglePixelPackedSampleModel")).getLength() > 0) {
            object2 = nodeList.item(0);
            sampleModel = new SinglePixelPackedSampleModel(RawImageInputStream.getInt((Node)object2, "dataType"), RawImageInputStream.getInt((Node)object2, "w"), RawImageInputStream.getInt((Node)object2, "h"), RawImageInputStream.getInt((Node)object2, "scanlineStride"), RawImageInputStream.getIntArray((Node)object2, "bitMasks"));
        }
        object2 = null;
        nodeList = document.getElementsByTagName("ComponentColorModel");
        if (nodeList.getLength() > 0) {
            object = nodeList.item(0);
            object2 = new ComponentColorModel(RawImageInputStream.getColorSpace((Node)object), RawImageInputStream.getIntArray((Node)object, "bits"), RawImageInputStream.getBoolean((Node)object, "hasAlpha"), RawImageInputStream.getBoolean((Node)object, "isAlphaPremultiplied"), RawImageInputStream.getTransparency(RawImageInputStream.getAttribute((Node)object, "transparency")), RawImageInputStream.getInt((Node)object, "transferType"));
        }
        if ((nodeList = document.getElementsByTagName("DirectColorModel")).getLength() > 0) {
            object = nodeList.item(0);
            object2 = new DirectColorModel(RawImageInputStream.getColorSpace((Node)object), RawImageInputStream.getInt((Node)object, "bits"), RawImageInputStream.getInt((Node)object, "rmask"), RawImageInputStream.getInt((Node)object, "gmask"), RawImageInputStream.getInt((Node)object, "bmask"), RawImageInputStream.getInt((Node)object, "amask"), false, 1);
        }
        if ((nodeList = document.getElementsByTagName("IndexColorModel")).getLength() > 0) {
            object = nodeList.item(0);
            byte[] byArray = RawImageInputStream.getByteArray((Node)object, "a");
            object2 = byArray == null ? new IndexColorModel(RawImageInputStream.getInt((Node)object, "bits"), RawImageInputStream.getInt((Node)object, "size"), RawImageInputStream.getByteArray((Node)object, "r"), RawImageInputStream.getByteArray((Node)object, "g"), RawImageInputStream.getByteArray((Node)object, "b")) : new IndexColorModel(RawImageInputStream.getInt((Node)object, "bits"), RawImageInputStream.getInt((Node)object, "size"), RawImageInputStream.getByteArray((Node)object, "r"), RawImageInputStream.getByteArray((Node)object, "g"), RawImageInputStream.getByteArray((Node)object, "b"), byArray);
        }
        this.type = new ImageTypeSpecifier((ColorModel)object2, sampleModel);
        if (this.imageDimensions.length == 0) {
            this.imageDimensions = new Dimension[this.imageOffsets.length];
            this.imageDimensions[0] = new Dimension(sampleModel.getWidth(), sampleModel.getHeight());
            int n4 = 1;
            while (n4 < this.imageDimensions.length) {
                this.imageDimensions[n4] = this.imageDimensions[0];
                ++n4;
            }
        }
    }

    public ImageTypeSpecifier getImageType() {
        return this.type;
    }

    public long getImageOffset(int n) {
        if (n < 0 || n >= this.imageOffsets.length) {
            throw new IllegalArgumentException(I18N.getString("RawImageInputStream3"));
        }
        return this.imageOffsets[n];
    }

    public Dimension getImageDimension(int n) {
        if (n < 0 || n >= this.imageOffsets.length) {
            throw new IllegalArgumentException(I18N.getString("RawImageInputStream3"));
        }
        return this.imageDimensions[n];
    }

    public int getNumImages() {
        return this.imageOffsets.length;
    }

    @Override
    public void setByteOrder(ByteOrder byteOrder) {
        this.source.setByteOrder(byteOrder);
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.source.getByteOrder();
    }

    @Override
    public int read() throws IOException {
        return this.source.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.source.read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.source.read(byArray, n, n2);
    }

    @Override
    public void readBytes(IIOByteBuffer iIOByteBuffer, int n) throws IOException {
        this.source.readBytes(iIOByteBuffer, n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.source.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.source.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.source.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.source.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.source.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.source.readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.source.readInt();
    }

    @Override
    public long readUnsignedInt() throws IOException {
        return this.source.readUnsignedInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.source.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.source.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.source.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        return this.source.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.source.readUTF();
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.source.readFully(byArray, n, n2);
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.source.readFully(byArray);
    }

    @Override
    public void readFully(short[] sArray, int n, int n2) throws IOException {
        this.source.readFully(sArray, n, n2);
    }

    @Override
    public void readFully(char[] cArray, int n, int n2) throws IOException {
        this.source.readFully(cArray, n, n2);
    }

    @Override
    public void readFully(int[] nArray, int n, int n2) throws IOException {
        this.source.readFully(nArray, n, n2);
    }

    @Override
    public void readFully(long[] lArray, int n, int n2) throws IOException {
        this.source.readFully(lArray, n, n2);
    }

    @Override
    public void readFully(float[] fArray, int n, int n2) throws IOException {
        this.source.readFully(fArray, n, n2);
    }

    @Override
    public void readFully(double[] dArray, int n, int n2) throws IOException {
        this.source.readFully(dArray, n, n2);
    }

    @Override
    public long getStreamPosition() throws IOException {
        return this.source.getStreamPosition();
    }

    @Override
    public int getBitOffset() throws IOException {
        return this.source.getBitOffset();
    }

    @Override
    public void setBitOffset(int n) throws IOException {
        this.source.setBitOffset(n);
    }

    @Override
    public int readBit() throws IOException {
        return this.source.readBit();
    }

    @Override
    public long readBits(int n) throws IOException {
        return this.source.readBits(n);
    }

    @Override
    public long length() throws IOException {
        return this.source.length();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.source.skipBytes(n);
    }

    @Override
    public long skipBytes(long l) throws IOException {
        return this.source.skipBytes(l);
    }

    @Override
    public void seek(long l) throws IOException {
        this.source.seek(l);
    }

    @Override
    public void mark() {
        this.source.mark();
    }

    @Override
    public void reset() throws IOException {
        this.source.reset();
    }

    @Override
    public void flushBefore(long l) throws IOException {
        this.source.flushBefore(l);
    }

    @Override
    public void flush() throws IOException {
        this.source.flush();
    }

    @Override
    public long getFlushedPosition() {
        return this.source.getFlushedPosition();
    }

    @Override
    public boolean isCached() {
        return this.source.isCached();
    }

    @Override
    public boolean isCachedMemory() {
        return this.source.isCachedMemory();
    }

    @Override
    public boolean isCachedFile() {
        return this.source.isCachedFile();
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }
}

