/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageio.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFColorConverter;
import com.sun.media.imageio.plugins.tiff.TIFFCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageWriter;
import java.util.Locale;
import javax.imageio.ImageWriteParam;

public class TIFFImageWriteParam
extends ImageWriteParam {
    TIFFCompressor compressor = null;
    TIFFColorConverter colorConverter = null;
    int photometricInterpretation;
    private boolean appendedCompressionType = false;

    public TIFFImageWriteParam(Locale locale) {
        super(locale);
        this.canWriteCompressed = true;
        this.canWriteTiles = true;
        this.compressionTypes = TIFFImageWriter.TIFFCompressionTypes;
    }

    @Override
    public boolean isCompressionLossless() {
        if (this.getCompressionMode() != 2) {
            throw new IllegalStateException("Compression mode not MODE_EXPLICIT!");
        }
        if (this.compressionType == null) {
            throw new IllegalStateException("No compression type set!");
        }
        if (this.compressor != null && this.compressionType.equals(this.compressor.getCompressionType())) {
            return this.compressor.isCompressionLossless();
        }
        int n = 0;
        while (n < this.compressionTypes.length) {
            if (this.compressionType.equals(this.compressionTypes[n])) {
                return TIFFImageWriter.isCompressionLossless[n];
            }
            ++n;
        }
        return false;
    }

    public void setTIFFCompressor(TIFFCompressor tIFFCompressor) {
        if (this.getCompressionMode() != 2) {
            throw new IllegalStateException("Compression mode not MODE_EXPLICIT!");
        }
        this.compressor = tIFFCompressor;
        if (this.appendedCompressionType) {
            int n = this.compressionTypes.length - 1;
            String[] stringArray = new String[n];
            System.arraycopy(this.compressionTypes, 0, stringArray, 0, n);
            this.compressionTypes = stringArray;
            this.appendedCompressionType = false;
        }
        if (tIFFCompressor != null) {
            String string = tIFFCompressor.getCompressionType();
            int n = this.compressionTypes.length;
            boolean bl = true;
            int n2 = 0;
            while (n2 < n) {
                if (string.equals(this.compressionTypes[n2])) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (bl) {
                String[] stringArray = new String[n + 1];
                System.arraycopy(this.compressionTypes, 0, stringArray, 0, n);
                stringArray[n] = string;
                this.compressionTypes = stringArray;
                this.appendedCompressionType = true;
            }
        }
    }

    public TIFFCompressor getTIFFCompressor() {
        if (this.getCompressionMode() != 2) {
            throw new IllegalStateException("Compression mode not MODE_EXPLICIT!");
        }
        return this.compressor;
    }

    public void setColorConverter(TIFFColorConverter tIFFColorConverter, int n) {
        this.colorConverter = tIFFColorConverter;
        this.photometricInterpretation = n;
    }

    public TIFFColorConverter getColorConverter() {
        return this.colorConverter;
    }

    public int getPhotometricInterpretation() {
        if (this.colorConverter == null) {
            throw new IllegalStateException("Color converter not set!");
        }
        return this.photometricInterpretation;
    }

    public void unsetColorConverter() {
        this.colorConverter = null;
    }
}

