/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageio.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFColorConverter;
import com.sun.media.imageioimpl.common.BogusColorSpace;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.SimpleCMYKColorSpace;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.IIOException;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public abstract class TIFFDecompressor {
    private static final boolean DEBUG = false;
    protected ImageReader reader;
    protected IIOMetadata metadata;
    protected int photometricInterpretation;
    protected int compression;
    protected boolean planar;
    protected int samplesPerPixel;
    protected int[] bitsPerSample;
    protected int[] sampleFormat = new int[]{1};
    protected int[] extraSamples;
    protected char[] colorMap;
    protected ImageInputStream stream;
    protected long offset;
    protected int byteCount;
    protected int srcMinX;
    protected int srcMinY;
    protected int srcWidth;
    protected int srcHeight;
    protected int sourceXOffset;
    protected int dstXOffset;
    protected int sourceYOffset;
    protected int dstYOffset;
    protected int subsampleX;
    protected int subsampleY;
    protected int[] sourceBands;
    protected int[] destinationBands;
    protected BufferedImage rawImage;
    protected BufferedImage image;
    protected int dstMinX;
    protected int dstMinY;
    protected int dstWidth;
    protected int dstHeight;
    protected int activeSrcMinX;
    protected int activeSrcMinY;
    protected int activeSrcWidth;
    protected int activeSrcHeight;
    protected TIFFColorConverter colorConverter;
    boolean isBilevel;
    boolean isContiguous;
    boolean isImageSimple;
    boolean adjustBitDepths;
    int[][] bitDepthScale;
    private boolean isFirstBitDepthTable = true;
    private boolean planarCache = false;
    private int[] destBitsPerSampleCache = null;
    private int[] sourceBandsCache = null;
    private int[] bitsPerSampleCache = null;
    private int[] destinationBandsCache = null;

    static SampleModel createInterleavedSM(int n, int n2) {
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = n3;
            ++n3;
        }
        return new PixelInterleavedSampleModel(n, 1, 1, n2, n2, nArray);
    }

    static ColorModel createComponentCM(ColorSpace colorSpace, int n, int n2, boolean bl, boolean bl2) {
        ComponentColorModel componentColorModel;
        int n3;
        int n4 = n3 = bl ? 3 : 1;
        if (n2 == 4 || n2 == 5) {
            componentColorModel = new ComponentColorModel(colorSpace, bl, bl2, n3, n2);
        } else {
            int n5;
            int[] nArray = new int[n];
            if (n2 == 0) {
                n5 = 8;
            } else if (n2 == 2 || n2 == 1) {
                n5 = 16;
            } else if (n2 == 3) {
                n5 = 32;
            } else {
                throw new IllegalArgumentException("dataType = " + n2);
            }
            int n6 = 0;
            while (n6 < n) {
                nArray[n6] = n5;
                ++n6;
            }
            componentColorModel = new ComponentColorModel(colorSpace, nArray, bl, bl2, n3, n2);
        }
        return componentColorModel;
    }

    private static int createMask(int[] nArray, int n) {
        int n2 = (1 << nArray[n]) - 1;
        int n3 = n + 1;
        while (n3 < nArray.length) {
            n2 <<= nArray[n3];
            ++n3;
        }
        return n2;
    }

    private static int getDataTypeFromNumBits(int n, boolean bl) {
        int n2 = n <= 8 ? 0 : (n <= 16 ? (bl ? 2 : 1) : 3);
        return n2;
    }

    private static boolean areIntArraysEqual(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray2 == null) {
            return nArray == null && nArray2 == null;
        }
        if (nArray.length != nArray2.length) {
            return false;
        }
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (nArray[n2] != nArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static int getDataTypeSize(int n) throws IIOException {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 8;
                break;
            }
            case 1: 
            case 2: {
                n2 = 16;
                break;
            }
            case 3: 
            case 4: {
                n2 = 32;
                break;
            }
            case 5: {
                n2 = 64;
                break;
            }
            default: {
                throw new IIOException("Unknown data type " + n);
            }
        }
        return n2;
    }

    private static int getBitsPerPixel(SampleModel sampleModel) {
        int n = 0;
        int[] nArray = sampleModel.getSampleSize();
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            n += nArray[n3];
            ++n3;
        }
        return n;
    }

    private static boolean areSampleSizesEqual(SampleModel sampleModel) {
        boolean bl = true;
        int[] nArray = sampleModel.getSampleSize();
        int n = nArray[0];
        int n2 = nArray.length;
        int n3 = 1;
        while (n3 < n2) {
            if (nArray[n3] != n) {
                bl = false;
                break;
            }
            ++n3;
        }
        return bl;
    }

    private static boolean isDataBufferBitContiguous(SampleModel sampleModel) throws IIOException {
        int n = TIFFDecompressor.getDataTypeSize(sampleModel.getDataType());
        if (sampleModel instanceof ComponentSampleModel) {
            int n2 = sampleModel.getNumBands();
            int n3 = 0;
            while (n3 < n2) {
                if (sampleModel.getSampleSize(n3) != n) {
                    return false;
                }
                ++n3;
            }
        } else if (sampleModel instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
            if (n % multiPixelPackedSampleModel.getPixelBitStride() != 0) {
                return false;
            }
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel cfr_ignored_0 = (SinglePixelPackedSampleModel)sampleModel;
            int n4 = sampleModel.getNumBands();
            int n5 = 0;
            int n6 = 0;
            while (n6 < n4) {
                n5 += sampleModel.getSampleSize(n6);
                ++n6;
            }
            if (n5 != n) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private static void reformatData(byte[] byArray, int n, int n2, short[] sArray, int[] nArray, int n3, int n4) throws IIOException {
        if (sArray != null) {
            int n5 = 0;
            int n6 = n / 2;
            int n7 = n % 2;
            int n8 = 0;
            while (n8 < n2) {
                int n9 = n3;
                int n10 = 0;
                while (n10 < n6) {
                    sArray[n9++] = (short)((byArray[n5++] & 0xFF) << 8 | byArray[n5++] & 0xFF);
                    ++n10;
                }
                if (n7 != 0) {
                    sArray[n9++] = (short)((byArray[n5++] & 0xFF) << 8);
                }
                n3 += n4;
                ++n8;
            }
        } else if (nArray != null) {
            int n11 = 0;
            int n12 = n / 4;
            int n13 = n % 4;
            int n14 = 0;
            while (n14 < n2) {
                int n15 = n3;
                int n16 = 0;
                while (n16 < n12) {
                    nArray[n15++] = (byArray[n11++] & 0xFF) << 24 | (byArray[n11++] & 0xFF) << 16 | (byArray[n11++] & 0xFF) << 8 | byArray[n11++] & 0xFF;
                    ++n16;
                }
                if (n13 != 0) {
                    n16 = 24;
                    int n17 = 0;
                    int n18 = 0;
                    while (n18 < n13) {
                        n17 |= (byArray[n11++] & 0xFF) << n16;
                        n16 -= 8;
                        ++n18;
                    }
                    nArray[n15++] = n17;
                }
                n3 += n4;
                ++n14;
            }
        } else {
            throw new IIOException("shortData == null && intData == null!");
        }
    }

    private static void reformatDiscontiguousData(byte[] byArray, int n, int n2, int n3, WritableRaster writableRaster) throws IOException {
        SampleModel sampleModel = writableRaster.getSampleModel();
        int n4 = sampleModel.getNumBands();
        int[] nArray = sampleModel.getSampleSize();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(byteArrayInputStream);
        long l = 0L;
        int n5 = writableRaster.getMinY();
        int n6 = 0;
        while (n6 < n3) {
            memoryCacheImageInputStream.seek(l);
            int n7 = writableRaster.getMinX();
            int n8 = 0;
            while (n8 < n2) {
                int n9 = 0;
                while (n9 < n4) {
                    long l2 = memoryCacheImageInputStream.readBits(nArray[n9]);
                    writableRaster.setSample(n7, n5, n9, (int)l2);
                    ++n9;
                }
                ++n8;
                ++n7;
            }
            l += (long)n;
            ++n6;
            ++n5;
        }
    }

    public static ImageTypeSpecifier getRawImageTypeSpecifier(int n, int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3, char[] cArray) {
        int n4;
        int n5;
        if (n3 == 1 && (nArray[0] == 1 || nArray[0] == 2 || nArray[0] == 4 || nArray[0] == 8 || nArray[0] == 16)) {
            if (cArray == null) {
                boolean bl;
                boolean bl2 = bl = nArray2[0] == 2;
                int n6 = nArray[0] <= 8 ? 0 : (nArray2[0] == 2 ? 2 : 1);
                return ImageTypeSpecifier.createGrayscale(nArray[0], n6, bl);
            }
            int n7 = 1 << nArray[0];
            byte[] byArray = new byte[n7];
            byte[] byArray2 = new byte[n7];
            byte[] byArray3 = new byte[n7];
            byte[] byArray4 = null;
            int n8 = 0;
            while (n8 < n7) {
                byArray[n8] = (byte)(cArray[n8] * 255 / 65535);
                byArray2[n8] = (byte)(cArray[n7 + n8] * 255 / 65535);
                byArray3[n8] = (byte)(cArray[2 * n7 + n8] * 255 / 65535);
                ++n8;
            }
            n8 = nArray[0] == 8 ? 0 : 1;
            return ImageTypeSpecifier.createIndexed(byArray, byArray2, byArray3, byArray4, nArray[0], n8);
        }
        if (n3 == 2 && nArray[0] == 8 && nArray[1] == 8) {
            int n9 = 0;
            boolean bl = false;
            if (nArray3 != null && nArray3[0] == 1) {
                bl = true;
            }
            return ImageTypeSpecifier.createGrayscale(8, n9, false, bl);
        }
        if (n3 == 2 && nArray[0] == 16 && nArray[1] == 16) {
            int n10 = nArray2[0] == 2 ? 2 : 1;
            boolean bl = false;
            if (nArray3 != null && nArray3[0] == 1) {
                bl = true;
            }
            boolean bl3 = n10 == 2;
            return ImageTypeSpecifier.createGrayscale(16, n10, bl3, bl);
        }
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        if (n3 == 3 && nArray[0] == 8 && nArray[1] == 8 && nArray[2] == 8) {
            int[] nArray4 = new int[]{0, 1, 2};
            int n11 = 0;
            ColorSpace colorSpace2 = n == 6 && n2 != 7 && n2 != 6 || n == 8 ? ColorSpace.getInstance(1004) : colorSpace;
            return ImageTypeSpecifier.createInterleaved(colorSpace2, nArray4, n11, false, false);
        }
        if (n3 == 4 && nArray[0] == 8 && nArray[1] == 8 && nArray[2] == 8 && nArray[3] == 8) {
            boolean bl;
            ColorSpace colorSpace3;
            int[] nArray5 = new int[]{0, 1, 2, 3};
            int n12 = 0;
            boolean bl4 = false;
            if (n == 5) {
                colorSpace3 = SimpleCMYKColorSpace.getInstance();
                bl = false;
            } else {
                colorSpace3 = colorSpace;
                bl = true;
                if (nArray3 != null && nArray3[0] == 1) {
                    bl4 = true;
                }
            }
            return ImageTypeSpecifier.createInterleaved(colorSpace3, nArray5, n12, bl, bl4);
        }
        if (n3 == 3 && nArray[0] == 16 && nArray[1] == 16 && nArray[2] == 16) {
            int[] nArray6 = new int[]{0, 1, 2};
            int n13 = nArray2[0] == 2 ? 2 : 1;
            return ImageTypeSpecifier.createInterleaved(colorSpace, nArray6, n13, false, false);
        }
        if (n3 == 4 && nArray[0] == 16 && nArray[1] == 16 && nArray[2] == 16 && nArray[3] == 16) {
            int[] nArray7 = new int[]{0, 1, 2, 3};
            int n14 = nArray2[0] == 2 ? 2 : 1;
            boolean bl = false;
            if (nArray3 != null && nArray3[0] == 1) {
                bl = true;
            }
            return ImageTypeSpecifier.createInterleaved(colorSpace, nArray7, n14, true, bl);
        }
        if (n == 5 && (nArray[0] == 1 || nArray[0] == 2 || nArray[0] == 4)) {
            ColorSpace colorSpace4 = null;
            colorSpace4 = n3 == 4 ? SimpleCMYKColorSpace.getInstance() : new BogusColorSpace(n3);
            ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace4, nArray, false, false, 1, 0);
            return new ImageTypeSpecifier(componentColorModel, ((ColorModel)componentColorModel).createCompatibleSampleModel(1, 1));
        }
        int n15 = 0;
        int n16 = 0;
        while (n16 < nArray.length) {
            n15 += nArray[n16];
            ++n16;
        }
        if (!(n3 != 3 && n3 != 4 || n15 != 8 && n15 != 16)) {
            n16 = TIFFDecompressor.createMask(nArray, 0);
            int n17 = TIFFDecompressor.createMask(nArray, 1);
            int n18 = TIFFDecompressor.createMask(nArray, 2);
            int n19 = n3 == 4 ? TIFFDecompressor.createMask(nArray, 3) : 0;
            int n20 = n15 == 8 ? 0 : 1;
            boolean bl = false;
            if (nArray3 != null && nArray3[0] == 1) {
                bl = true;
            }
            return ImageTypeSpecifier.createPacked(colorSpace, n16, n17, n18, n19, n20, bl);
        }
        if (nArray[0] % 8 == 0) {
            n16 = 1;
            n5 = 1;
            while (n5 < nArray.length) {
                if (nArray[n5] != nArray[n5 - 1]) {
                    n16 = 0;
                    break;
                }
                ++n5;
            }
            if (n16 != 0) {
                n5 = -1;
                n4 = 0;
                switch (nArray[0]) {
                    case 8: {
                        if (nArray2[0] == 3) break;
                        n5 = 0;
                        n4 = 1;
                        break;
                    }
                    case 16: {
                        if (nArray2[0] == 3) break;
                        n5 = nArray2[0] == 2 ? 2 : 1;
                        n4 = 1;
                        break;
                    }
                    case 32: {
                        n5 = nArray2[0] == 3 ? 4 : 3;
                        n4 = 1;
                    }
                }
                if (n4 != 0) {
                    ColorModel colorModel;
                    SampleModel sampleModel = TIFFDecompressor.createInterleavedSM(n5, n3);
                    if (n3 >= 1 && n3 <= 4 && (n5 == 3 || n5 == 4)) {
                        ColorSpace colorSpace5 = n3 <= 2 ? ColorSpace.getInstance(1003) : colorSpace;
                        boolean bl = n3 % 2 == 0;
                        boolean bl5 = false;
                        if (bl && nArray3 != null && nArray3[0] == 1) {
                            bl5 = true;
                        }
                        colorModel = TIFFDecompressor.createComponentCM(colorSpace5, n3, n5, bl, bl5);
                    } else {
                        BogusColorSpace bogusColorSpace = new BogusColorSpace(n3);
                        colorModel = TIFFDecompressor.createComponentCM(bogusColorSpace, n3, n5, false, false);
                    }
                    return new ImageTypeSpecifier(colorModel, sampleModel);
                }
            }
        }
        if (cArray == null && nArray2[0] != 3) {
            n16 = 0;
            n5 = 0;
            while (n5 < nArray.length) {
                if (nArray[n5] > n16) {
                    n16 = nArray[n5];
                }
                ++n5;
            }
            int n21 = n5 = nArray2[0] == 2 ? 1 : 0;
            if (n3 == 1) {
                n4 = TIFFDecompressor.getDataTypeFromNumBits(n16, n5 != 0);
                return ImageTypeSpecifier.createGrayscale(n16, n4, n5 != 0);
            }
            if (n3 == 2) {
                n4 = 0;
                if (nArray3 != null && nArray3[0] == 1) {
                    n4 = 1;
                }
                int n22 = TIFFDecompressor.getDataTypeFromNumBits(n16, n5 != 0);
                return ImageTypeSpecifier.createGrayscale(n16, n22, false, n4 != 0);
            }
            if (n3 == 3 || n3 == 4) {
                if (n15 <= 32 && n5 == 0) {
                    n4 = TIFFDecompressor.createMask(nArray, 0);
                    int n23 = TIFFDecompressor.createMask(nArray, 1);
                    int n24 = TIFFDecompressor.createMask(nArray, 2);
                    int n25 = n3 == 4 ? TIFFDecompressor.createMask(nArray, 3) : 0;
                    int n26 = TIFFDecompressor.getDataTypeFromNumBits(n15, false);
                    boolean bl = false;
                    if (nArray3 != null && nArray3[0] == 1) {
                        bl = true;
                    }
                    return ImageTypeSpecifier.createPacked(colorSpace, n4, n23, n24, n25, n26, bl);
                }
                if (n3 == 3) {
                    int[] nArray8 = new int[3];
                    nArray8[1] = 1;
                    nArray8[2] = 2;
                    int[] nArray9 = nArray8;
                    int n27 = TIFFDecompressor.getDataTypeFromNumBits(n16, n5 != 0);
                    return ImageTypeSpecifier.createInterleaved(colorSpace, nArray9, n27, false, false);
                }
                if (n3 == 4) {
                    int[] nArray10 = new int[4];
                    nArray10[1] = 1;
                    nArray10[2] = 2;
                    nArray10[3] = 3;
                    int[] nArray11 = nArray10;
                    int n28 = TIFFDecompressor.getDataTypeFromNumBits(n16, n5 != 0);
                    boolean bl = false;
                    if (nArray3 != null && nArray3[0] == 1) {
                        bl = true;
                    }
                    return ImageTypeSpecifier.createInterleaved(colorSpace, nArray11, n28, true, bl);
                }
            } else {
                n4 = TIFFDecompressor.getDataTypeFromNumBits(n16, n5 != 0);
                SampleModel sampleModel = TIFFDecompressor.createInterleavedSM(n4, n3);
                BogusColorSpace bogusColorSpace = new BogusColorSpace(n3);
                ColorModel colorModel = TIFFDecompressor.createComponentCM(bogusColorSpace, n3, n4, false, false);
                return new ImageTypeSpecifier(colorModel, sampleModel);
            }
        }
        return null;
    }

    public void setReader(ImageReader imageReader) {
        this.reader = imageReader;
    }

    public void setMetadata(IIOMetadata iIOMetadata) {
        this.metadata = iIOMetadata;
    }

    public void setPhotometricInterpretation(int n) {
        this.photometricInterpretation = n;
    }

    public void setCompression(int n) {
        this.compression = n;
    }

    public void setPlanar(boolean bl) {
        this.planar = bl;
    }

    public void setSamplesPerPixel(int n) {
        this.samplesPerPixel = n;
    }

    public void setBitsPerSample(int[] nArray) {
        this.bitsPerSample = nArray == null ? null : (int[])nArray.clone();
    }

    public void setSampleFormat(int[] nArray) {
        int[] nArray2;
        if (nArray == null) {
            int[] nArray3 = new int[1];
            nArray2 = nArray3;
            nArray3[0] = 1;
        } else {
            nArray2 = (int[])nArray.clone();
        }
        this.sampleFormat = nArray2;
    }

    public void setExtraSamples(int[] nArray) {
        this.extraSamples = nArray == null ? null : (int[])nArray.clone();
    }

    public void setColorMap(char[] cArray) {
        this.colorMap = cArray == null ? null : (char[])cArray.clone();
    }

    public void setStream(ImageInputStream imageInputStream) {
        this.stream = imageInputStream;
    }

    public void setOffset(long l) {
        this.offset = l;
    }

    public void setByteCount(int n) {
        this.byteCount = n;
    }

    public void setSrcMinX(int n) {
        this.srcMinX = n;
    }

    public void setSrcMinY(int n) {
        this.srcMinY = n;
    }

    public void setSrcWidth(int n) {
        this.srcWidth = n;
    }

    public void setSrcHeight(int n) {
        this.srcHeight = n;
    }

    public void setSourceXOffset(int n) {
        this.sourceXOffset = n;
    }

    public void setDstXOffset(int n) {
        this.dstXOffset = n;
    }

    public void setSourceYOffset(int n) {
        this.sourceYOffset = n;
    }

    public void setDstYOffset(int n) {
        this.dstYOffset = n;
    }

    public void setSubsampleX(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("subsampleX <= 0!");
        }
        this.subsampleX = n;
    }

    public void setSubsampleY(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("subsampleY <= 0!");
        }
        this.subsampleY = n;
    }

    public void setSourceBands(int[] nArray) {
        this.sourceBands = nArray == null ? null : (int[])nArray.clone();
    }

    public void setDestinationBands(int[] nArray) {
        this.destinationBands = nArray == null ? null : (int[])nArray.clone();
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public void setDstMinX(int n) {
        this.dstMinX = n;
    }

    public void setDstMinY(int n) {
        this.dstMinY = n;
    }

    public void setDstWidth(int n) {
        this.dstWidth = n;
    }

    public void setDstHeight(int n) {
        this.dstHeight = n;
    }

    public void setActiveSrcMinX(int n) {
        this.activeSrcMinX = n;
    }

    public void setActiveSrcMinY(int n) {
        this.activeSrcMinY = n;
    }

    public void setActiveSrcWidth(int n) {
        this.activeSrcWidth = n;
    }

    public void setActiveSrcHeight(int n) {
        this.activeSrcHeight = n;
    }

    public void setColorConverter(TIFFColorConverter tIFFColorConverter) {
        this.colorConverter = tIFFColorConverter;
    }

    public ImageTypeSpecifier getRawImageType() {
        ImageTypeSpecifier imageTypeSpecifier = TIFFDecompressor.getRawImageTypeSpecifier(this.photometricInterpretation, this.compression, this.samplesPerPixel, this.bitsPerSample, this.sampleFormat, this.extraSamples, this.colorMap);
        return imageTypeSpecifier;
    }

    public BufferedImage createRawImage() {
        if (this.planar) {
            int n = this.bitsPerSample[this.sourceBands[0]];
            int n2 = this.sampleFormat[0] == 3 ? 4 : (n <= 8 ? 0 : (n <= 16 ? (this.sampleFormat[0] == 2 ? 2 : 1) : 3));
            ColorSpace colorSpace = ColorSpace.getInstance(1003);
            ImageTypeSpecifier imageTypeSpecifier = null;
            if (n == 1 || n == 2 || n == 4) {
                int n3 = n;
                int n4 = 1 << n3;
                byte[] byArray = new byte[n4];
                byte[] byArray2 = new byte[n4];
                byte[] byArray3 = new byte[n4];
                int n5 = 0;
                while (n5 < byArray.length) {
                    byArray[n5] = 0;
                    byArray2[n5] = 0;
                    byArray3[n5] = 0;
                    ++n5;
                }
                IndexColorModel indexColorModel = new IndexColorModel(n3, n4, byArray, byArray2, byArray3);
                MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(0, 1, 1, n3);
                imageTypeSpecifier = new ImageTypeSpecifier(indexColorModel, multiPixelPackedSampleModel);
            } else {
                imageTypeSpecifier = ImageTypeSpecifier.createInterleaved(colorSpace, new int[1], n2, false, false);
            }
            return imageTypeSpecifier.createBufferedImage(this.srcWidth, this.srcHeight);
        }
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageType();
        if (imageTypeSpecifier == null) {
            return null;
        }
        BufferedImage bufferedImage = imageTypeSpecifier.createBufferedImage(this.srcWidth, this.srcHeight);
        return bufferedImage;
    }

    public abstract void decodeRaw(byte[] var1, int var2, int var3, int var4) throws IOException;

    public void decodeRaw(short[] sArray, int n, int n2, int n3) throws IOException {
        int n4 = (this.srcWidth * n2 + 7) / 8;
        int n5 = n4 / 2;
        byte[] byArray = new byte[n4 * this.srcHeight];
        this.decodeRaw(byArray, 0, n2, n4);
        int n6 = 0;
        if (this.stream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
            int n7 = 0;
            while (n7 < this.srcHeight) {
                int n8 = 0;
                while (n8 < n5) {
                    short s;
                    byte by = byArray[n6++];
                    byte by2 = byArray[n6++];
                    sArray[n + n8] = s = (short)(by << 8 | by2 & 0xFF);
                    ++n8;
                }
                n += n3;
                ++n7;
            }
        } else {
            int n9 = 0;
            while (n9 < this.srcHeight) {
                int n10 = 0;
                while (n10 < n5) {
                    short s;
                    byte by = byArray[n6++];
                    byte by3 = byArray[n6++];
                    sArray[n + n10] = s = (short)(by3 << 8 | by & 0xFF);
                    ++n10;
                }
                n += n3;
                ++n9;
            }
        }
    }

    public void decodeRaw(int[] nArray, int n, int n2, int n3) throws IOException {
        int n4 = n2 / 32;
        int n5 = this.srcWidth * n4;
        int n6 = n5 * 4;
        byte[] byArray = new byte[n6 * this.srcHeight];
        this.decodeRaw(byArray, 0, n2, n6);
        int n7 = 0;
        if (this.stream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
            int n8 = 0;
            while (n8 < this.srcHeight) {
                int n9 = 0;
                while (n9 < n5) {
                    int n10;
                    int n11 = byArray[n7++] & 0xFF;
                    int n12 = byArray[n7++] & 0xFF;
                    int n13 = byArray[n7++] & 0xFF;
                    int n14 = byArray[n7++] & 0xFF;
                    nArray[n + n9] = n10 = n11 << 24 | n12 << 16 | n13 << 8 | n14;
                    ++n9;
                }
                n += n3;
                ++n8;
            }
        } else {
            int n15 = 0;
            while (n15 < this.srcHeight) {
                int n16 = 0;
                while (n16 < n5) {
                    int n17;
                    int n18 = byArray[n7++] & 0xFF;
                    int n19 = byArray[n7++] & 0xFF;
                    int n20 = byArray[n7++] & 0xFF;
                    int n21 = byArray[n7++] & 0xFF;
                    nArray[n + n16] = n17 = n21 << 24 | n20 << 16 | n19 << 8 | n18;
                    ++n16;
                }
                n += n3;
                ++n15;
            }
        }
    }

    public void decodeRaw(float[] fArray, int n, int n2, int n3) throws IOException {
        int n4 = n2 / 32;
        int n5 = this.srcWidth * n4;
        int n6 = n5 * 4;
        byte[] byArray = new byte[n6 * this.srcHeight];
        this.decodeRaw(byArray, 0, n2, n6);
        int n7 = 0;
        if (this.stream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
            int n8 = 0;
            while (n8 < this.srcHeight) {
                int n9 = 0;
                while (n9 < n5) {
                    float f;
                    int n10 = byArray[n7++] & 0xFF;
                    int n11 = byArray[n7++] & 0xFF;
                    int n12 = byArray[n7++] & 0xFF;
                    int n13 = byArray[n7++] & 0xFF;
                    int n14 = n10 << 24 | n11 << 16 | n12 << 8 | n13;
                    fArray[n + n9] = f = Float.intBitsToFloat(n14);
                    ++n9;
                }
                n += n3;
                ++n8;
            }
        } else {
            int n15 = 0;
            while (n15 < this.srcHeight) {
                int n16 = 0;
                while (n16 < n5) {
                    float f;
                    int n17 = byArray[n7++] & 0xFF;
                    int n18 = byArray[n7++] & 0xFF;
                    int n19 = byArray[n7++] & 0xFF;
                    int n20 = byArray[n7++] & 0xFF;
                    int n21 = n20 << 24 | n19 << 16 | n18 << 8 | n17;
                    fArray[n + n16] = f = Float.intBitsToFloat(n21);
                    ++n16;
                }
                n += n3;
                ++n15;
            }
        }
    }

    public void beginDecoding() {
        int n;
        int n2;
        int n3;
        this.adjustBitDepths = false;
        int n4 = this.destinationBands.length;
        int[] nArray = null;
        if (this.planar) {
            n3 = this.bitsPerSample.length;
            nArray = new int[n3];
            n2 = this.image.getSampleModel().getSampleSize(0);
            n = 0;
            while (n < n3) {
                nArray[n] = n2;
                ++n;
            }
        } else {
            nArray = this.image.getSampleModel().getSampleSize();
        }
        if (this.photometricInterpretation != 5 || this.bitsPerSample[0] != 1 && this.bitsPerSample[0] != 2 && this.bitsPerSample[0] != 4) {
            n3 = 0;
            while (n3 < n4) {
                if (nArray[this.destinationBands[n3]] != this.bitsPerSample[this.sourceBands[n3]]) {
                    this.adjustBitDepths = true;
                    break;
                }
                ++n3;
            }
        }
        if (this.adjustBitDepths) {
            if (!(!this.isFirstBitDepthTable && this.planar == this.planarCache && TIFFDecompressor.areIntArraysEqual(nArray, this.destBitsPerSampleCache) && TIFFDecompressor.areIntArraysEqual(this.sourceBands, this.sourceBandsCache) && TIFFDecompressor.areIntArraysEqual(this.bitsPerSample, this.bitsPerSampleCache) && TIFFDecompressor.areIntArraysEqual(this.destinationBands, this.destinationBandsCache))) {
                this.isFirstBitDepthTable = false;
                this.planarCache = this.planar;
                this.destBitsPerSampleCache = (int[])nArray.clone();
                this.sourceBandsCache = this.sourceBands == null ? null : (int[])this.sourceBands.clone();
                this.bitsPerSampleCache = this.bitsPerSample == null ? null : (int[])this.bitsPerSample.clone();
                this.destinationBandsCache = this.destinationBands == null ? null : (int[])this.destinationBands.clone();
                this.bitDepthScale = new int[n4][];
                n3 = 0;
                while (n3 < n4) {
                    n2 = (1 << this.bitsPerSample[this.sourceBands[n3]]) - 1;
                    n = n2 / 2;
                    int n5 = (1 << nArray[this.destinationBands[n3]]) - 1;
                    this.bitDepthScale[n3] = new int[n2 + 1];
                    int n6 = 0;
                    while (n6 <= n2) {
                        this.bitDepthScale[n3][n6] = (n6 * n5 + n) / n2;
                        ++n6;
                    }
                    ++n3;
                }
            }
        } else {
            this.bitDepthScale = null;
        }
        n3 = 0;
        n2 = 0;
        if (n4 == this.samplesPerPixel) {
            n3 = 1;
            n2 = 1;
            n = 0;
            while (n < n4) {
                if (this.sourceBands[n] != n) {
                    n3 = 0;
                }
                if (this.destinationBands[n] != n) {
                    n2 = 0;
                }
                ++n;
            }
        }
        this.isBilevel = ImageUtil.isBinary(this.image.getRaster().getSampleModel());
        this.isContiguous = this.isBilevel ? true : ImageUtil.imageIsContiguous(this.image);
        this.isImageSimple = this.colorConverter == null && this.subsampleX == 1 && this.subsampleY == 1 && this.srcWidth == this.dstWidth && this.srcHeight == this.dstHeight && this.dstMinX + this.dstWidth <= this.image.getWidth() && this.dstMinY + this.dstHeight <= this.image.getHeight() && n3 != 0 && n2 != 0 && !this.adjustBitDepths;
    }

    public void decode() throws IOException {
        Object object;
        int n;
        Object object2;
        Object object3;
        boolean bl;
        byte[] byArray = null;
        short[] sArray = null;
        int[] nArray = null;
        float[] fArray = null;
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        this.rawImage = null;
        if (this.isImageSimple) {
            if (this.isBilevel) {
                this.rawImage = this.image;
            } else if (this.isContiguous) {
                this.rawImage = this.image.getSubimage(this.dstMinX, this.dstMinY, this.dstWidth, this.dstHeight);
            }
        }
        boolean bl2 = bl = this.rawImage != null;
        if (this.rawImage == null) {
            this.rawImage = this.createRawImage();
            if (this.rawImage == null) {
                throw new IIOException("Couldn't create image buffer!");
            }
        }
        WritableRaster writableRaster = this.rawImage.getRaster();
        if (this.isBilevel) {
            object3 = this.isImageSimple ? new Rectangle(this.dstMinX, this.dstMinY, this.dstWidth, this.dstHeight) : writableRaster.getBounds();
            byArray = ImageUtil.getPackedBinaryData(writableRaster, (Rectangle)object3);
            n2 = 0;
            n3 = 1;
            n4 = (((Rectangle)object3).width + 7) / 8;
        } else {
            DataBuffer dataBuffer;
            object3 = writableRaster.getSampleModel();
            object2 = writableRaster.getDataBuffer();
            n = 0;
            if (object3 instanceof ComponentSampleModel) {
                object = (ComponentSampleModel)object3;
                n2 = ((ComponentSampleModel)object).getOffset(-writableRaster.getSampleModelTranslateX(), -writableRaster.getSampleModelTranslateY());
                n4 = ((ComponentSampleModel)object).getScanlineStride();
                if (object2 instanceof DataBufferByte) {
                    dataBuffer = (DataBufferByte)object2;
                    byArray = ((DataBufferByte)dataBuffer).getData();
                    n3 = ((ComponentSampleModel)object).getPixelStride() * 8;
                    n = 1;
                } else if (object2 instanceof DataBufferUShort) {
                    dataBuffer = (DataBufferUShort)object2;
                    sArray = ((DataBufferUShort)dataBuffer).getData();
                    n3 = ((ComponentSampleModel)object).getPixelStride() * 16;
                    n = 1;
                } else if (object2 instanceof DataBufferShort) {
                    dataBuffer = (DataBufferShort)object2;
                    sArray = ((DataBufferShort)dataBuffer).getData();
                    n3 = ((ComponentSampleModel)object).getPixelStride() * 16;
                    n = 1;
                } else if (object2 instanceof DataBufferInt) {
                    dataBuffer = (DataBufferInt)object2;
                    nArray = ((DataBufferInt)dataBuffer).getData();
                    n3 = ((ComponentSampleModel)object).getPixelStride() * 32;
                    n = 1;
                } else if (object2 instanceof DataBufferFloat) {
                    dataBuffer = (DataBufferFloat)object2;
                    fArray = ((DataBufferFloat)dataBuffer).getData();
                    n3 = ((ComponentSampleModel)object).getPixelStride() * 32;
                    n = 1;
                }
            } else if (object3 instanceof MultiPixelPackedSampleModel) {
                object = (MultiPixelPackedSampleModel)object3;
                n2 = ((MultiPixelPackedSampleModel)object).getOffset(-writableRaster.getSampleModelTranslateX(), -writableRaster.getSampleModelTranslateY());
                n3 = ((MultiPixelPackedSampleModel)object).getPixelBitStride();
                n4 = ((MultiPixelPackedSampleModel)object).getScanlineStride();
                if (object2 instanceof DataBufferByte) {
                    dataBuffer = (DataBufferByte)object2;
                    byArray = ((DataBufferByte)dataBuffer).getData();
                    n = 1;
                } else if (object2 instanceof DataBufferUShort) {
                    dataBuffer = (DataBufferUShort)object2;
                    sArray = ((DataBufferUShort)dataBuffer).getData();
                    n = 1;
                } else if (object2 instanceof DataBufferInt) {
                    dataBuffer = (DataBufferInt)object2;
                    nArray = ((DataBufferInt)dataBuffer).getData();
                    n = 1;
                }
            } else if (object3 instanceof SinglePixelPackedSampleModel) {
                object = (SinglePixelPackedSampleModel)object3;
                n2 = ((SinglePixelPackedSampleModel)object).getOffset(-writableRaster.getSampleModelTranslateX(), -writableRaster.getSampleModelTranslateY());
                n4 = ((SinglePixelPackedSampleModel)object).getScanlineStride();
                if (object2 instanceof DataBufferByte) {
                    dataBuffer = (DataBufferByte)object2;
                    byArray = ((DataBufferByte)dataBuffer).getData();
                    n3 = 8;
                    n = 1;
                } else if (object2 instanceof DataBufferUShort) {
                    dataBuffer = (DataBufferUShort)object2;
                    sArray = ((DataBufferUShort)dataBuffer).getData();
                    n3 = 16;
                    n = 1;
                } else if (object2 instanceof DataBufferInt) {
                    dataBuffer = (DataBufferInt)object2;
                    nArray = ((DataBufferInt)dataBuffer).getData();
                    n3 = 32;
                    n = 1;
                }
            }
            if (n == 0) {
                throw new IIOException("Unsupported raw image type: SampleModel = " + object3 + "; DataBuffer = " + object2);
            }
        }
        if (this.isBilevel) {
            this.decodeRaw(byArray, n2, n3, n4);
        } else {
            object3 = writableRaster.getSampleModel();
            if (TIFFDecompressor.isDataBufferBitContiguous((SampleModel)object3)) {
                if (byArray != null) {
                    this.decodeRaw(byArray, n2, n3, n4);
                } else if (fArray != null) {
                    this.decodeRaw(fArray, n2, n3, n4);
                } else if (sArray != null) {
                    if (TIFFDecompressor.areSampleSizesEqual((SampleModel)object3) && ((SampleModel)object3).getSampleSize(0) == 16) {
                        this.decodeRaw(sArray, n2, n3, n4);
                    } else {
                        int n5 = TIFFDecompressor.getBitsPerPixel((SampleModel)object3);
                        n = (n5 * this.srcWidth + 7) / 8;
                        object = new byte[n * this.srcHeight];
                        this.decodeRaw((byte[])object, 0, n5, n);
                        TIFFDecompressor.reformatData((byte[])object, n, this.srcHeight, sArray, null, n2, n4);
                    }
                } else if (nArray != null) {
                    if (TIFFDecompressor.areSampleSizesEqual((SampleModel)object3) && ((SampleModel)object3).getSampleSize(0) == 32) {
                        this.decodeRaw(nArray, n2, n3, n4);
                    } else {
                        int n6 = TIFFDecompressor.getBitsPerPixel((SampleModel)object3);
                        n = (n6 * this.srcWidth + 7) / 8;
                        object = new byte[n * this.srcHeight];
                        this.decodeRaw((byte[])object, 0, n6, n);
                        TIFFDecompressor.reformatData((byte[])object, n, this.srcHeight, null, nArray, n2, n4);
                    }
                }
            } else {
                int n7 = TIFFDecompressor.getBitsPerPixel((SampleModel)object3);
                n = (n7 * this.srcWidth + 7) / 8;
                object = new byte[n * this.srcHeight];
                this.decodeRaw((byte[])object, 0, n7, n);
                TIFFDecompressor.reformatDiscontiguousData((byte[])object, n, this.srcWidth, this.srcHeight, writableRaster);
            }
        }
        if (this.colorConverter != null) {
            float f;
            float f2;
            object3 = new float[3];
            if (byArray != null) {
                int n8 = 0;
                while (n8 < this.dstHeight) {
                    n = n2;
                    int n9 = 0;
                    while (n9 < this.dstWidth) {
                        float f3 = byArray[n] & 0xFF;
                        f2 = byArray[n + 1] & 0xFF;
                        f = byArray[n + 2] & 0xFF;
                        this.colorConverter.toRGB(f3, f2, f, (float[])object3);
                        byArray[n] = (byte)((int)object3[0]);
                        byArray[n + 1] = (byte)((int)object3[1]);
                        byArray[n + 2] = (byte)((int)object3[2]);
                        n += 3;
                        ++n9;
                    }
                    n2 += n4;
                    ++n8;
                }
            } else if (sArray != null) {
                if (this.sampleFormat[0] == 2) {
                    int n10 = 0;
                    while (n10 < this.dstHeight) {
                        n = n2;
                        int n11 = 0;
                        while (n11 < this.dstWidth) {
                            float f4 = sArray[n];
                            f2 = sArray[n + 1];
                            f = sArray[n + 2];
                            this.colorConverter.toRGB(f4, f2, f, (float[])object3);
                            sArray[n] = (short)((int)object3[0]);
                            sArray[n + 1] = (short)((int)object3[1]);
                            sArray[n + 2] = (short)((int)object3[2]);
                            n += 3;
                            ++n11;
                        }
                        n2 += n4;
                        ++n10;
                    }
                } else {
                    int n12 = 0;
                    while (n12 < this.dstHeight) {
                        n = n2;
                        int n13 = 0;
                        while (n13 < this.dstWidth) {
                            float f5 = sArray[n] & 0xFFFF;
                            f2 = sArray[n + 1] & 0xFFFF;
                            f = sArray[n + 2] & 0xFFFF;
                            this.colorConverter.toRGB(f5, f2, f, (float[])object3);
                            sArray[n] = (short)((int)object3[0]);
                            sArray[n + 1] = (short)((int)object3[1]);
                            sArray[n + 2] = (short)((int)object3[2]);
                            n += 3;
                            ++n13;
                        }
                        n2 += n4;
                        ++n12;
                    }
                }
            } else if (nArray != null) {
                int n14 = 0;
                while (n14 < this.dstHeight) {
                    n = n2;
                    int n15 = 0;
                    while (n15 < this.dstWidth) {
                        float f6 = nArray[n];
                        f2 = nArray[n + 1];
                        f = nArray[n + 2];
                        this.colorConverter.toRGB(f6, f2, f, (float[])object3);
                        nArray[n] = (int)object3[0];
                        nArray[n + 1] = (int)object3[1];
                        nArray[n + 2] = (int)object3[2];
                        n += 3;
                        ++n15;
                    }
                    n2 += n4;
                    ++n14;
                }
            } else if (fArray != null) {
                int n16 = 0;
                while (n16 < this.dstHeight) {
                    n = n2;
                    int n17 = 0;
                    while (n17 < this.dstWidth) {
                        float f7 = fArray[n];
                        f2 = fArray[n + 1];
                        f = fArray[n + 2];
                        this.colorConverter.toRGB(f7, f2, f, (float[])object3);
                        fArray[n] = (float)object3[0];
                        fArray[n + 1] = (float)object3[1];
                        fArray[n + 2] = (float)object3[2];
                        n += 3;
                        ++n17;
                    }
                    n2 += n4;
                    ++n16;
                }
            }
        }
        if (this.photometricInterpretation == 0) {
            if (byArray != null) {
                int n18 = (this.srcWidth * n3 + 7) / 8;
                int n19 = 0;
                while (n19 < this.srcHeight) {
                    n = n2 + n19 * n4;
                    int n20 = 0;
                    while (n20 < n18) {
                        int n21 = n + n20;
                        byArray[n21] = (byte)(byArray[n21] ^ 0xFF);
                        ++n20;
                    }
                    ++n19;
                }
            } else if (sArray != null) {
                int n22 = (this.srcWidth * n3 + 15) / 16;
                if (this.sampleFormat[0] == 2) {
                    int n23 = 0;
                    while (n23 < this.srcHeight) {
                        n = n2 + n23 * n4;
                        int n24 = 0;
                        while (n24 < n22) {
                            int n25 = n + n24;
                            sArray[n25] = (short)(Short.MAX_VALUE - sArray[n25]);
                            ++n24;
                        }
                        ++n23;
                    }
                } else {
                    int n26 = 0;
                    while (n26 < this.srcHeight) {
                        n = n2 + n26 * n4;
                        int n27 = 0;
                        while (n27 < n22) {
                            int n28 = n + n27;
                            sArray[n28] = (short)(sArray[n28] ^ 0xFFFF);
                            ++n27;
                        }
                        ++n26;
                    }
                }
            } else if (nArray != null) {
                int n29 = (this.srcWidth * n3 + 15) / 16;
                int n30 = 0;
                while (n30 < this.srcHeight) {
                    n = n2 + n30 * n4;
                    int n31 = 0;
                    while (n31 < n29) {
                        int n32 = n + n31;
                        nArray[n32] = Integer.MAX_VALUE - nArray[n32];
                        ++n31;
                    }
                    ++n30;
                }
            } else if (fArray != null) {
                int n33 = (this.srcWidth * n3 + 15) / 16;
                int n34 = 0;
                while (n34 < this.srcHeight) {
                    n = n2 + n34 * n4;
                    int n35 = 0;
                    while (n35 < n33) {
                        int n36 = n + n35;
                        fArray[n36] = 1.0f - fArray[n36];
                        ++n35;
                    }
                    ++n34;
                }
            }
        }
        if (this.isBilevel) {
            Rectangle rectangle = this.isImageSimple ? new Rectangle(this.dstMinX, this.dstMinY, this.dstWidth, this.dstHeight) : writableRaster.getBounds();
            ImageUtil.setPackedBinaryData(byArray, writableRaster, rectangle);
        }
        if (bl) {
            return;
        }
        WritableRaster writableRaster2 = this.rawImage.getRaster();
        object2 = writableRaster2.createChild(0, 0, this.srcWidth, this.srcHeight, this.srcMinX, this.srcMinY, this.planar ? null : this.sourceBands);
        WritableRaster writableRaster3 = this.image.getRaster();
        WritableRaster writableRaster4 = writableRaster3.createWritableChild(this.dstMinX, this.dstMinY, this.dstWidth, this.dstHeight, this.dstMinX, this.dstMinY, this.destinationBands);
        if (this.subsampleX == 1 && this.subsampleY == 1 && !this.adjustBitDepths) {
            object2 = ((Raster)object2).createChild(this.activeSrcMinX, this.activeSrcMinY, this.activeSrcWidth, this.activeSrcHeight, this.dstMinX, this.dstMinY, null);
            writableRaster4.setRect((Raster)object2);
        } else if (this.subsampleX == 1 && !this.adjustBitDepths) {
            int n37 = this.activeSrcMinY;
            int n38 = this.dstMinY;
            while (n37 < this.srcMinY + this.srcHeight) {
                Raster raster = ((Raster)object2).createChild(this.activeSrcMinX, n37, this.activeSrcWidth, 1, this.dstMinX, n38, null);
                writableRaster4.setRect(raster);
                n37 += this.subsampleY;
                ++n38;
            }
        } else {
            int[] nArray2 = ((Raster)object2).getPixel(this.srcMinX, this.srcMinY, (int[])null);
            int n39 = nArray2.length;
            int n40 = this.activeSrcMinY;
            int n41 = this.dstMinY;
            while (n40 < this.activeSrcMinY + this.activeSrcHeight) {
                int n42 = this.activeSrcMinX;
                int n43 = this.dstMinX;
                while (n42 < this.activeSrcMinX + this.activeSrcWidth) {
                    ((Raster)object2).getPixel(n42, n40, nArray2);
                    if (this.adjustBitDepths) {
                        int n44 = 0;
                        while (n44 < n39) {
                            nArray2[n44] = this.bitDepthScale[n44][nArray2[n44]];
                            ++n44;
                        }
                    }
                    writableRaster4.setPixel(n43, n41, nArray2);
                    n42 += this.subsampleX;
                    ++n43;
                }
                n40 += this.subsampleY;
                ++n41;
            }
        }
    }
}

