/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageio.plugins.tiff;

import com.sun.media.imageioimpl.plugins.tiff.TIFFImageWriter;
import java.io.IOException;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;

public abstract class TIFFCompressor {
    protected ImageWriter writer;
    protected IIOMetadata metadata;
    protected String compressionType;
    protected int compressionTagValue;
    protected boolean isCompressionLossless;
    protected ImageOutputStream stream;

    public TIFFCompressor(String string, int n, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("compressionType == null");
        }
        if (n < 1) {
            throw new IllegalArgumentException("compressionTagValue < 1");
        }
        this.compressionType = string;
        int n2 = -1;
        String[] stringArray = TIFFImageWriter.compressionTypes;
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            if (stringArray[n4].equals(string)) {
                n2 = n4;
                break;
            }
            ++n4;
        }
        if (n2 != -1) {
            this.compressionTagValue = TIFFImageWriter.compressionNumbers[n2];
            this.isCompressionLossless = TIFFImageWriter.isCompressionLossless[n2];
        } else {
            this.compressionTagValue = n;
            this.isCompressionLossless = bl;
        }
    }

    public String getCompressionType() {
        return this.compressionType;
    }

    public int getCompressionTagValue() {
        return this.compressionTagValue;
    }

    public boolean isCompressionLossless() {
        return this.isCompressionLossless;
    }

    public void setStream(ImageOutputStream imageOutputStream) {
        this.stream = imageOutputStream;
    }

    public ImageOutputStream getStream() {
        return this.stream;
    }

    public void setWriter(ImageWriter imageWriter) {
        this.writer = imageWriter;
    }

    public ImageWriter getWriter() {
        return this.writer;
    }

    public void setMetadata(IIOMetadata iIOMetadata) {
        this.metadata = iIOMetadata;
    }

    public IIOMetadata getMetadata() {
        return this.metadata;
    }

    public abstract int encode(byte[] var1, int var2, int var3, int var4, int[] var5, int var6) throws IOException;
}

