/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal.ui.dialogs;

import com.deltawalker.App;
import com.deltawalker.PrefKey;
import com.deltawalker.image.internal.ui.ImageContextId;
import com.deltawalker.ui.ControlUtil;
import com.deltawalker.ui.OverlayPrefStore;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.dialogs.PrefProviderPage;
import com.deltopia.jface.util.DialogUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class ImagePrefPage
extends PrefProviderPage
implements IWorkbenchPreferencePage {
    private static final OverlayPrefStore.OverlayKey[] OVERLAY_KEYS = new OverlayPrefStore.OverlayKey[]{new OverlayPrefStore.OverlayKey(OverlayPrefStore.BOOLEAN, PrefKey.I_EXPAND_INFO.toString()), new OverlayPrefStore.OverlayKey(OverlayPrefStore.BOOLEAN, PrefKey.I_SHOW_SINGLE_PANNER.toString())};
    private static final String VALUE_DATA = "VALUE";
    private final Listener listener = new Listener(){

        public void handleEvent(Event event) {
            Widget widget = event.widget;
            String string = (String)widget.getData();
            if (widget instanceof Button) {
                Object object = widget.getData(ImagePrefPage.VALUE_DATA);
                if (object instanceof Integer) {
                    if (((Button)widget).getSelection()) {
                        ImagePrefPage.this.overlayPrefs.setValue(string, ((Integer)object).intValue());
                    }
                } else {
                    ImagePrefPage.this.overlayPrefs.setValue(string, ((Button)widget).getSelection());
                }
            }
        }
    };
    private OverlayPrefStore overlayPrefs;

    private Button createBooleanButton(Composite composite, int n, String string) {
        Button button = new Button(composite, n);
        button.setData((Object)string);
        button.addListener(13, this.listener);
        return button;
    }

    protected Control createContents(Composite composite) {
        UIUtil.setHelpContextId((Control)composite, (String)ImageContextId.IMAGE_PREF_PAGE);
        this.overlayPrefs = new OverlayPrefStore(this.getPreferenceStore(), OVERLAY_KEYS);
        this.overlayPrefs.load();
        this.overlayPrefs.start();
        Composite composite2 = DialogUtil.createPageComposite((Composite)composite);
        this.createControls(composite2);
        Dialog.applyDialogFont((Control)composite2);
        this.initializeFromPrefs();
        return composite2;
    }

    private void createControls(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        this.createDisplayControls(composite);
        DialogUtil.insertSpace((Composite)composite);
        new PreferenceLinkArea(composite, 0, "org.eclipse.ui.preferencePages.ColorsAndFonts", "'<a>Checkered Background Colors</a>'", (IWorkbenchPreferenceContainer)this.getContainer(), null);
    }

    private void createDisplayControls(Composite composite) {
        Composite composite2 = DialogUtil.createPageComposite((Composite)composite);
        ((GridLayout)composite2.getLayout()).numColumns = 3;
        Button button = this.createBooleanButton(composite2, 32, PrefKey.I_SHOW_SINGLE_PANNER.toString());
        button.setText("Show single panner");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        button.setLayoutData((Object)gridData);
    }

    public void dispose() {
        try {
            this.overlayPrefs.stop();
        }
        finally {
            super.dispose();
        }
    }

    public void init(IWorkbench iWorkbench) {
    }

    private void initializeFromPrefs() {
        Control[] controlArray;
        Control[] controlArray2 = controlArray = ControlUtil.getChildren((Control)this.getControl(), Button.class);
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray2[n2];
            Button button = (Button)control;
            int n3 = button.getStyle();
            if (32 == (n3 & 0x20) || 16 == (n3 & 0x10)) {
                String string = (String)button.getData();
                Object object = button.getData(VALUE_DATA);
                if (object instanceof Integer) {
                    button.setSelection(((Integer)object).intValue() == this.overlayPrefs.getInt(string));
                } else {
                    button.setSelection(this.overlayPrefs.getBoolean(string));
                }
                button.notifyListeners(13, null);
            }
            ++n2;
        }
        controlArray = ControlUtil.getChildren((Control)this.getControl(), Spinner.class);
        int n4 = 0;
        while (n4 < controlArray.length) {
            Spinner spinner = (Spinner)controlArray[n4];
            String string = (String)spinner.getData();
            spinner.setSelection(this.overlayPrefs.getInt(string));
            spinner.notifyListeners(13, null);
            ++n4;
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.overlayPrefs.loadDefaults();
        this.initializeFromPrefs();
        if (!this.isSessionPage()) {
            App.instance().stateBoss().saveState();
        }
    }

    public void performHelp() {
        UIUtil.showHelp((String)"image-comparisons", (UIUtil.HelpContext)UIUtil.HelpContext.PREF_PAGE);
    }

    public boolean performOk() {
        this.overlayPrefs.propagate();
        if (!this.isSessionPage()) {
            App.instance().stateBoss().saveState();
        }
        return true;
    }
}

