/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal.ui;

import com.deltawalker.image.internal.ImageInfo;
import com.deltawalker.image.internal.Scale;
import com.deltawalker.image.internal.common.IFunctionInt;
import com.deltawalker.image.internal.common.PiecewiseLinearFunctionInt;
import com.deltopia.StringUtil;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

final class Zoom
implements Comparable<Zoom> {
    private static final DecimalFormat _DECIMAL;
    public static final Zoom ACTUAL_SIZE;
    private static final double[] COARSE_FACTORS;
    private static final double COEFF_INT = 1000.0;
    private static final ZoomComparator COMPARATOR;
    private static final double[] FACTORS;
    public static final Zoom FIT_IMAGE;
    private static final IFunctionInt FUNCTION_INT;
    private static final Set<Zoom> LIST_ALL;
    private static final TreeSet<Zoom> LIST_REAL;
    private static final Set<Zoom> LIST_REAL_ROUGH;
    public static final Zoom MAX;
    public static final Zoom MIN;
    private final String name;
    private final Preset preset;
    private final Scale scale;

    static {
        Preset[] presetArray;
        _DECIMAL = new DecimalFormat();
        ACTUAL_SIZE = new Zoom(Scale.NO);
        COARSE_FACTORS = new double[]{0.25, 0.5, 1.0, 2.0, 4.0, 8.0, 16.0};
        COMPARATOR = new ZoomComparator();
        FACTORS = new double[]{0.1, 0.25, 0.5, 0.75, 1.0, 1.25, 1.5, 1.75, 2.0, 4.0, 8.0, 16.0};
        FIT_IMAGE = Zoom.fromPreset(Preset.FIT);
        Arrays.sort(COARSE_FACTORS);
        TreeSet<Zoom> treeSet = new TreeSet<Zoom>(COMPARATOR);
        LIST_ALL = new TreeSet<Zoom>(COMPARATOR);
        TreeSet<Zoom> treeSet2 = new TreeSet<Zoom>(COMPARATOR);
        Object object = presetArray = Preset.values();
        int n = presetArray.length;
        int n2 = 0;
        while (n2 < n) {
            Preset preset = object[n2];
            LIST_ALL.add(new Zoom(preset));
            ++n2;
        }
        int n3 = 0;
        while (n3 < FACTORS.length) {
            double d = FACTORS[n3];
            object = new Zoom(d);
            treeSet.add((Zoom)object);
            LIST_ALL.add((Zoom)object);
            int n4 = Arrays.binarySearch(COARSE_FACTORS, d);
            if (n4 >= 0) {
                treeSet2.add((Zoom)object);
            }
            ++n3;
        }
        LIST_REAL = treeSet;
        LIST_REAL_ROUGH = Collections.unmodifiableSet(treeSet2);
        MIN = treeSet.first();
        MAX = treeSet.last();
        n3 = (int)(MAX.getScale().getValueAsDouble() * 1000.0);
        int n5 = (int)(MIN.getScale().getValueAsDouble() * 1000.0);
        n = (int)(ACTUAL_SIZE.getScale().getValueAsDouble() * 1000.0);
        FUNCTION_INT = new PiecewiseLinearFunctionInt(1, n5, 500, n, 1000, n3);
    }

    public static Zoom fromPreset(Preset preset) throws NullPointerException {
        if (preset == null) {
            throw new NullPointerException("preset");
        }
        return new Zoom(preset);
    }

    public static Zoom fromScale(Scale scale) throws NullPointerException {
        if (scale == null) {
            throw new NullPointerException("scale");
        }
        return new Zoom(scale);
    }

    public static Zoom fromString(String string) throws IllegalArgumentException {
        Preset preset = Preset.fromString(string);
        if (preset != null) {
            return new Zoom(preset);
        }
        try {
            Number number = _DECIMAL.parse(string);
            return new Zoom(number.doubleValue() / 100.0);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Cannot parse zoom from:  " + string, parseException);
        }
    }

    public static final Zoom[] getListPredefinedAll() {
        return LIST_ALL.toArray(new Zoom[LIST_ALL.size()]);
    }

    public static final String[] getListPredefinedAllAsStr() {
        String[] stringArray = new String[LIST_ALL.size()];
        int n = 0;
        for (Zoom zoom : LIST_ALL) {
            stringArray[n++] = zoom.displayName();
        }
        return stringArray;
    }

    public static final Collection<Zoom> getListPredefinedScale() {
        return Collections.unmodifiableSet(LIST_REAL);
    }

    public static final String[] getListPredefinedScaleAsStr() {
        String[] stringArray = new String[LIST_REAL.size()];
        int n = 0;
        for (Zoom zoom : LIST_REAL) {
            stringArray[n++] = zoom.displayName();
        }
        return stringArray;
    }

    public static final Collection<Zoom> getListPredefinedScaleRough() {
        return LIST_REAL_ROUGH;
    }

    private static final Zoom getPredefined(Zoom zoom, int n) {
        assert (zoom != null);
        assert (zoom.hasScale());
        Zoom zoom2 = null;
        Iterator<Zoom> iterator = LIST_REAL.iterator();
        while (iterator.hasNext()) {
            Zoom zoom3 = iterator.next();
            int n2 = zoom3.compareTo(zoom);
            if (n == 0) {
                if (n2 == 0) {
                    return zoom3;
                }
                if (n2 > 0) {
                    return null;
                }
            } else if (n < 0) {
                if (n2 >= 0) {
                    return zoom2;
                }
                if (!iterator.hasNext()) {
                    return zoom3;
                }
            } else if (n2 > 0) {
                return zoom3;
            }
            zoom2 = zoom3;
        }
        return null;
    }

    private static int scaleToInt(Scale scale) {
        assert (scale != null);
        return FUNCTION_INT.getX((int)(scale.getValueAsDouble() * 1000.0));
    }

    public static Zoom zoomFromInt(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("Non-positive zoom");
        }
        return Zoom.fromScale(Scale.create((double)FUNCTION_INT.getY(n) / 1000.0));
    }

    private Zoom(double d) {
        this(Scale.create(d));
    }

    private Zoom(Preset preset) {
        if (preset == null) {
            throw new NullPointerException("preset");
        }
        this.preset = preset;
        this.scale = Preset.ACTUAL_SIZE == preset ? Scale.NO : null;
        this.name = preset.description;
    }

    private Zoom(Scale scale) {
        if (scale == null) {
            throw new NullPointerException("scale");
        }
        this.preset = null;
        this.scale = scale;
        _DECIMAL.setMaximumFractionDigits(2);
        this.name = String.valueOf(_DECIMAL.format(100.0 * scale.getValueAsDouble())) + "%";
    }

    @Override
    public int compareTo(Zoom zoom) {
        if (zoom == null) {
            throw new NullPointerException("zoom");
        }
        return COMPARATOR.compare(this, zoom);
    }

    public String displayName() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Zoom zoom = (Zoom)object;
        return !(this.hasScale() ? !this.scale.equals(zoom.scale) : this.preset != zoom.preset);
    }

    public Scale getScale() throws IllegalStateException {
        if (!this.hasScale()) {
            throw new IllegalStateException("Cannot use zoom " + this);
        }
        return this.scale;
    }

    public int getScaleAsInt() throws IllegalStateException {
        return Zoom.scaleToInt(this.getScale());
    }

    public Scale getScaleFor(ImageInfo imageInfo, Dimension dimension) throws NullPointerException {
        return this.getScaleFor(imageInfo.width, imageInfo.height, dimension.width, dimension.height);
    }

    public Scale getScaleFor(int n, int n2, int n3, int n4) {
        Scale scale;
        if (n3 <= 0 || n4 <= 0) {
            throw new IllegalArgumentException("Empty component " + n3 + 'x' + n4);
        }
        if (this.hasScale()) {
            return this.getScale();
        }
        switch (this.preset) {
            case FIT: {
                scale = Scale.create(n, n2, n3, n4);
                break;
            }
            case FIT_WIDTH: {
                scale = Scale.create(n, n3);
                break;
            }
            case FIT_HEIGHT: {
                scale = Scale.create(n2, n4);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid preset " + this);
            }
        }
        return scale;
    }

    public Zoom getZoomReal(int n, int n2, int n3, int n4) {
        if (this.hasScale()) {
            return this;
        }
        return new Zoom(this.getScaleFor(n, n2, n3, n4));
    }

    public int hashCode() {
        return this.hasScale() ? this.scale.hashCode() : this.preset.hashCode();
    }

    public boolean hasScale() {
        return this.scale != null;
    }

    public String toString() {
        return this.name.endsWith("%") ? this.name.substring(0, this.name.length() - 1) : this.name;
    }

    public Zoom zoomIn() {
        return Zoom.getPredefined(this, 1);
    }

    public Zoom zoomOut() {
        return Zoom.getPredefined(this, -1);
    }

    static final class Preset
    extends Enum<Preset> {
        public static final /* enum */ Preset ACTUAL_SIZE = new Preset("1:1");
        public static final /* enum */ Preset FIT = new Preset("Fit");
        public static final /* enum */ Preset FIT_HEIGHT = new Preset("Fit Height");
        public static final /* enum */ Preset FIT_WIDTH = new Preset("Fit Width");
        private final String description;
        private static final /* synthetic */ Preset[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Preset[]{ACTUAL_SIZE, FIT, FIT_HEIGHT, FIT_WIDTH};
        }

        public static Preset fromString(String string) {
            Preset[] presetArray;
            assert (!StringUtil.isEmpty((String)string));
            Preset[] presetArray2 = presetArray = Preset.values();
            int n = presetArray.length;
            int n2 = 0;
            while (n2 < n) {
                Preset preset = presetArray2[n2];
                if (preset.description.equals(string)) {
                    return preset;
                }
                ++n2;
            }
            return null;
        }

        private Preset(String string2) {
            this.description = string2;
        }

        public String toString() {
            return this.description;
        }

        public static Preset[] values() {
            Preset[] presetArray = ENUM$VALUES;
            int n = presetArray.length;
            Preset[] presetArray2 = new Preset[n];
            System.arraycopy(ENUM$VALUES, 0, presetArray2, 0, n);
            return presetArray2;
        }

        public static Preset valueOf(String string) {
            return Enum.valueOf(Preset.class, string);
        }
    }

    private static class ZoomComparator
    implements Comparator<Zoom> {
        private ZoomComparator() {
        }

        @Override
        public int compare(Zoom zoom, Zoom zoom2) {
            int n = zoom.scale != null ? (zoom2.scale != null ? zoom.scale.compareTo(zoom2.scale) : 1) : (zoom2.scale == null ? zoom.preset.description.compareTo(zoom2.preset.description) : -1);
            return n;
        }
    }
}

