/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal.ui;

import com.deltawalker.image.internal.Scale;
import com.deltawalker.image.internal.common.SwtGeometryUtil;
import com.deltawalker.image.internal.ui.IImageRenderProviderPanner;
import com.deltawalker.image.internal.ui.ImageCanvasBase;
import com.deltawalker.script.Role;
import com.deltopia.ui.swt.Border;
import com.deltopia.ui.swt.BorderDoubleLine;
import com.deltopia.ui.swt.CloseRenderer;
import com.deltopia.ui.swt.IVerticalScrollBarOwner;
import com.deltopia.util.Const;
import java.awt.Rectangle;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImagePanner
extends ImageCanvasBase {
    private static final Logger LOG = LoggerFactory.getLogger(ImagePanner.class);
    boolean canAlpha = true;
    CloseRenderer closer;
    private final MouseHandler onMouse;
    private Border outlineMove;
    private Border outlineStill;
    private boolean panning = false;
    private Rectangle rcProject = new Rectangle(0, 0, 0, 0);

    public ImagePanner(Composite composite, Role role, int n, IVerticalScrollBarOwner iVerticalScrollBarOwner) {
        super(composite, role, n, true, iVerticalScrollBarOwner);
        this.outlineStill = new BorderDoubleLine((Device)this.getDisplay(), 2, 1, 0, 0);
        this.outlineMove = new BorderDoubleLine((Device)this.getDisplay(), 2, 7, 0, 0);
        this.onMouse = new MouseHandler();
        this.addMouseListener(this.onMouse);
        this.addMouseMoveListener(this.onMouse);
        this.addMouseTrackListener(this.onMouse);
        try {
            GC gC = new GC((Drawable)this);
            int n2 = gC.getAlpha();
            gC.setAlpha(80);
            gC.setAlpha(n2);
        }
        catch (SWTException sWTException) {
            this.canAlpha = false;
            LOG.error("No alpha support: ", (Throwable)sWTException);
        }
    }

    private Rectangle computeProjectionBounds() {
        Rectangle rectangle = this.imageProvider().getVisibleRect(this.role);
        java.awt.Point point = this.getOrigin();
        rectangle.translate(point.x, point.y);
        Rectangle rectangle2 = this.getClientRect();
        rectangle = rectangle.intersection(rectangle2);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Projection " + rectangle);
        }
        return rectangle;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.outlineStill != null) {
            this.outlineStill.dispose();
            this.outlineStill = null;
        }
        if (this.outlineMove != null) {
            this.outlineMove.dispose();
            this.outlineMove = null;
        }
    }

    @Override
    IImageRenderProviderPanner imageProvider() {
        return (IImageRenderProviderPanner)super.imageProvider();
    }

    public void move(int n, int n2) {
        Rectangle rectangle = SwtGeometryUtil.rectSwt2Awt(this.getParent().getClientArea());
        if (rectangle.isEmpty()) {
            return;
        }
        org.eclipse.swt.graphics.Rectangle rectangle2 = this.getBounds();
        int n3 = Math.max(rectangle.x, Math.min(rectangle2.x + n, rectangle.x + rectangle.width - rectangle2.width));
        int n4 = Math.max(rectangle.y, Math.min(rectangle2.y + n2, rectangle.y + rectangle.height - rectangle2.height));
        if (n3 != rectangle2.x || n4 != rectangle2.y) {
            this.setLocation(n3, n4);
            org.eclipse.swt.graphics.Rectangle rectangle3 = this.getClientArea();
            Point point = this.getSize();
            java.awt.Point point2 = new java.awt.Point(rectangle3.width - point.x, rectangle3.height - point.y - 15);
            boolean bl = n3 > point2.x - 5 && n4 > point2.y - 5;
            this.getImageFacade().setDockPanner(bl);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Move panner to : " + n3 + 'x' + n4 + " canvas=" + rectangle + ", panner=" + rectangle2);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Cannot move panner to : " + n3 + 'x' + n4 + " canvas=" + rectangle + ", panner=" + rectangle2);
        }
    }

    @Override
    protected void paint(GC gC) {
        block8: {
            try {
                Rectangle rectangle;
                if (!this.hasImage()) {
                    return;
                }
                super.paint(gC);
                this.closer.drawClose(gC, this.getDisplay());
                if (this.panning && !this.rcProject.isEmpty()) {
                    this.outlineMove.paintBorder((Control)this, gC, this.rcProject);
                }
                if ((rectangle = this.computeProjectionBounds()).isEmpty()) break block8;
                this.outlineStill.paintBorder((Control)this, gC, rectangle);
                if (!this.canAlpha) {
                    return;
                }
                int n = gC.getAlpha();
                Color color = gC.getBackground();
                gC.setAlpha(80);
                gC.setBackground(this.getDisplay().getSystemColor(16));
                Rectangle rectangle2 = this.imageBounds();
                Region region = new Region((Device)this.getDisplay());
                Region region2 = new Region((Device)this.getDisplay());
                try {
                    region.add(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    region.subtract(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    gC.setClipping(region);
                    gC.fillRectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    org.eclipse.swt.graphics.Rectangle rectangle3 = this.getOutermostClientArea();
                    region2.add(rectangle3);
                    region2.subtract(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    gC.setAlpha(30);
                    gC.setClipping(region2);
                    gC.setBackground(this.getDisplay().getSystemColor(9));
                    gC.fillRoundRectangle(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, Const.ARC_M.x, Const.ARC_M.y);
                }
                finally {
                    region.dispose();
                    region2.dispose();
                }
                gC.setClipping(null);
                gC.setBackground(color);
                gC.setAlpha(n);
            }
            catch (Throwable throwable) {
                LOG.error("Error painting panner " + (Object)((Object)this), throwable);
            }
        }
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.closer = new CloseRenderer(new org.eclipse.swt.graphics.Rectangle(n - 16 - 3, 6, 16, 16));
    }

    private class MouseHandler
    implements MouseListener,
    MouseMoveListener,
    MouseTrackListener {
        private final java.awt.Point ptOffset = new java.awt.Point(0, 0);
        private Point ptOldLocation = null;

        private MouseHandler() {
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            ImagePanner.this.getImageFacade().moveImage(0, 0);
        }

        public void mouseDown(MouseEvent mouseEvent) {
            ImagePanner.this.rcProject = ImagePanner.this.computeProjectionBounds();
            if (mouseEvent.button == 1 && ImagePanner.this.hasImage()) {
                if (ImagePanner.this.closer.isInside(new Point(mouseEvent.x, mouseEvent.y))) {
                    ImagePanner.this.closer.setState(CloseRenderer.State.HIT);
                    this.redrawClose();
                }
                if (ImagePanner.this.rcProject.contains(mouseEvent.x, mouseEvent.y)) {
                    ImagePanner.this.panning = true;
                    this.ptOffset.x = mouseEvent.x - ((ImagePanner)ImagePanner.this).rcProject.x;
                    this.ptOffset.y = mouseEvent.y - ((ImagePanner)ImagePanner.this).rcProject.y;
                } else {
                    this.ptOldLocation = ImagePanner.this.toDisplay(mouseEvent.x, mouseEvent.y);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Start move panner: " + this.ptOldLocation);
                    }
                }
            }
        }

        public void mouseEnter(MouseEvent mouseEvent) {
            ImagePanner.this.closer.setState(CloseRenderer.State.NORMAL);
            this.redrawClose();
        }

        public void mouseExit(MouseEvent mouseEvent) {
            ImagePanner.this.closer.setState(CloseRenderer.State.NONE);
            this.redrawClose();
        }

        public void mouseHover(MouseEvent mouseEvent) {
        }

        public void mouseMove(MouseEvent mouseEvent) {
            CloseRenderer.State state;
            if (ImagePanner.this.panning) {
                ((ImagePanner)ImagePanner.this).rcProject.x = mouseEvent.x - this.ptOffset.x;
                ((ImagePanner)ImagePanner.this).rcProject.y = mouseEvent.y - this.ptOffset.y;
                ImagePanner.this.redraw();
            } else if (this.ptOldLocation != null) {
                Point point = ImagePanner.this.toDisplay(mouseEvent.x, mouseEvent.y);
                int n = point.x - this.ptOldLocation.x;
                int n2 = point.y - this.ptOldLocation.y;
                if (n != 0 || n2 != 0) {
                    this.ptOldLocation.x = point.x;
                    this.ptOldLocation.y = point.y;
                    ImagePanner.this.getImageFacade().movePanner(n, n2);
                }
            }
            boolean bl = ImagePanner.this.closer.isInside(new Point(mouseEvent.x, mouseEvent.y));
            CloseRenderer.State state2 = ImagePanner.this.closer.getState();
            CloseRenderer.State state3 = bl ? (state2 == CloseRenderer.State.HIT ? CloseRenderer.State.HIT : CloseRenderer.State.HOT) : (state = CloseRenderer.State.NORMAL);
            if (state != ImagePanner.this.closer.getState()) {
                ImagePanner.this.closer.setState(state);
                this.redrawClose();
            }
        }

        public void mouseUp(MouseEvent mouseEvent) {
            this.updateMove(mouseEvent);
            ImagePanner.this.panning = false;
            this.ptOldLocation = null;
            if (mouseEvent.button == 1 && ImagePanner.this.closer.isInside(new Point(mouseEvent.x, mouseEvent.y))) {
                ImagePanner.this.getImageFacade().showPanner(false, true);
            }
        }

        private void redrawClose() {
            org.eclipse.swt.graphics.Rectangle rectangle = ImagePanner.this.closer.bounds();
            ImagePanner.this.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
        }

        private void updateMove(MouseEvent mouseEvent) {
            if (ImagePanner.this.panning) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Image move from panner: " + mouseEvent);
                }
                java.awt.Point point = ImagePanner.this.rcProject.getLocation();
                java.awt.Point point2 = ImagePanner.this.getOrigin();
                point.translate(-point2.x, -point2.y);
                Scale scale = ImagePanner.this.imageProvider().getRelativeScale(ImagePanner.this.role);
                point = scale.divide(point);
                ImagePanner.this.getImageFacade().moveImage(-point.x, -point.y);
            }
        }
    }
}

