/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal.ui;

import com.deltawalker.Relation;
import com.deltawalker.image.internal.IImageProvider;
import com.deltawalker.image.internal.ImageDoc;
import com.deltawalker.image.internal.ImageInfo;
import com.deltawalker.image.internal.ui.ImageDiffView;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Delta;
import com.deltawalker.script.Role;
import com.deltawalker.ui.DeltaPart;
import com.deltopia.StringUtil;
import com.deltopia.eclipse.util.SizeFormatter;
import com.deltopia.eclipse.util.TimeFormatter;
import com.deltopia.util.Const;
import com.deltopia.util.OS;
import java.awt.Dimension;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class ImageInfoSection
extends Composite {
    Map<Field, String> fields = new Hashtable<Field, String>();
    public Canvas info;
    private Role role;
    private ImageDiffView view;
    private final Map<Role, ImageInfoSection> infos;

    public ImageInfoSection(Composite composite, Map<Role, ImageInfoSection> map) {
        super(composite, 0x40140000);
        this.infos = map;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.createInfoCanvas();
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = OS.OSX ? 20 : 24;
        this.setLayoutData(gridData);
    }

    public void composeImageSummary(ImageDiffView imageDiffView, Role role) {
        this.view = imageDiffView;
        this.role = role;
        ImageDoc imageDoc = imageDiffView.doc(role);
        IResource iResource = imageDoc.resource();
        IImageProvider iImageProvider = imageDiffView.imageProvider(role);
        if (iResource != null && iImageProvider != null) {
            ImageInfo imageInfo = iImageProvider.info();
            this.fields.put(Field.FORMAT, imageInfo.format.displayName().toUpperCase());
            this.fields.put(Field.DATE, TimeFormatter.formatShort((long)iResource.getLastModifiedTime()));
            this.fields.put(Field.SIZE, SizeFormatter.format((long)iResource.getSize(), (int)2));
            Dimension dimension = imageInfo.getSize();
            this.fields.put(Field.RESOLUTION, String.valueOf(dimension.width) + "x" + dimension.height);
            this.fields.put(Field.DEPTH, String.valueOf(Integer.toString(imageInfo.colorModel.getPixelSize())) + " bits");
            this.fields.put(Field.TRANSPARENCY, this.getTransparencyName(imageInfo.colorModel.getTransparency()));
        }
        this.redraw();
    }

    private void createInfoCanvas() {
        this.info = new Canvas((Composite)this, 0x40140000);
        this.info.setLayoutData((Object)new GridData(4, 128, true, false));
        final Display display = this.getDisplay();
        this.info.setForeground(display.getSystemColor(24));
        this.info.setBackground(display.getSystemColor(25));
        this.info.addPaintListener(new PaintListener(){

            private void drawBackground(GC gC) {
                Color color = gC.getForeground();
                Rectangle rectangle = ImageInfoSection.this.getClientArea();
                gC.setForeground(display.getSystemColor(16));
                gC.drawRoundRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, Const.ARC.x, Const.ARC.y);
                gC.setForeground(color);
                Color color2 = gC.getBackground();
                gC.fillRoundRectangle(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2, Const.ARC.x, Const.ARC.y);
                gC.setBackground(color2);
            }

            private void drawField(GC gC, Field field, Point point) {
                String string = ImageInfoSection.this.fields.get((Object)field);
                if (!StringUtil.isEmpty((String)string)) {
                    Point point2 = gC.stringExtent(string);
                    if (ImageInfoSection.this.isFieldDifferent(field)) {
                        this.drawFieldBackground(gC, point.x, point.y, point2.x, point2.y, field);
                    }
                    gC.drawString(string, point.x + 1, point.y, true);
                    point.x += point2.x;
                }
            }

            private void drawFieldBackground(GC gC, int n, int n2, int n3, int n4, Field field) {
                Color color = gC.getForeground();
                Color color2 = ImageInfoSection.this.view.deltaColor().colorFor(Delta.Kind.CHANGED, DeltaPart.BORDER);
                gC.setForeground(color2);
                gC.drawRoundRectangle(n - 2, n2 - 2, n3 + 5, n4 + 4, Const.ARC.x, Const.ARC.y);
                gC.setForeground(color);
                Color color3 = gC.getBackground();
                gC.setBackground(ImageInfoSection.this.view.deltaColor().colorFor(Delta.Kind.CHANGED, DeltaPart.BG));
                gC.fillRoundRectangle(n - 1, n2 - 1, n3 + 4, n4 + 3, Const.ARC.x, Const.ARC.y);
                gC.setBackground(color3);
            }

            public void paintControl(PaintEvent paintEvent) {
                GC gC = paintEvent.gc;
                Point point = new Point(5, 4);
                Set<Field> set = Field.fields();
                for (Field field : set) {
                    this.drawField(gC, field, point);
                    point.x += 20;
                }
            }
        });
    }

    public String fieldValue(Field field) {
        return this.fields.get((Object)field);
    }

    private String getTransparencyName(int n) {
        switch (n) {
            case 1: {
                return "Opaque";
            }
            case 2: {
                return "Transparent";
            }
            case 3: {
                return "Translucent";
            }
        }
        throw new IllegalArgumentException("transparency");
    }

    boolean isFieldDifferent(Field field) {
        String string = this.fields.get((Object)field);
        boolean bl = false;
        Set set = Relation.others((Role)this.role, (boolean)this.view.isThreeWay());
        for (Role role : set) {
            if (string.equals(this.infos.get(role).fieldValue(field))) continue;
            bl = true;
            break;
        }
        return bl;
    }

    static enum Field {
        DATE,
        DEPTH,
        FORMAT,
        RESOLUTION,
        SIZE,
        TRANSPARENCY;

        private static final Set<Field> FIELDS;

        static {
            LinkedHashSet<Field> linkedHashSet = new LinkedHashSet<Field>(Field.values().length);
            linkedHashSet.add(FORMAT);
            linkedHashSet.add(DATE);
            linkedHashSet.add(SIZE);
            linkedHashSet.add(RESOLUTION);
            linkedHashSet.add(DEPTH);
            linkedHashSet.add(TRANSPARENCY);
            FIELDS = Collections.unmodifiableSet(linkedHashSet);
        }

        public static Set<Field> fields() {
            return FIELDS;
        }
    }
}

