/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal.ui;

import com.deltawalker.BoldFontCache;
import com.deltawalker.PrefKey;
import com.deltawalker.Relation;
import com.deltawalker.image.internal.ui.ImageDiffView;
import com.deltawalker.image.internal.ui.ImageInfoSection;
import com.deltawalker.script.Role;
import com.deltawalker.ui.BaseExpandable;
import com.deltawalker.ui.DiffView;
import com.deltopia.interfaces.IMvcController;
import com.deltopia.interfaces.IMvcModel;
import com.deltopia.jface.util.DialogUtil;
import java.util.EnumMap;
import java.util.Map;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ImageInfoExpandable
extends BaseExpandable {
    private final Map<Role, ImageInfoSection> infos = new EnumMap<Role, ImageInfoSection>(Role.class);
    private final ImageDiffView view;

    public ImageInfoExpandable(Composite composite, int n, ImageDiffView imageDiffView) {
        super(composite, n, (DiffView)imageDiffView);
        this.view = imageDiffView;
        this.setMenu(composite.getMenu());
        this.setFont(BoldFontCache.get((Font)this.getFont()));
        this.setText("Info");
        ((GridLayout)this.client().getLayout()).numColumns = imageDiffView.isThreeWay() ? 3 : 2;
    }

    public void connect(IMvcModel iMvcModel, IMvcController iMvcController) {
        super.connect(iMvcModel, iMvcController);
        this.createInfoSections();
    }

    private ImageInfoSection createInfoSection(Role role) {
        Composite composite = DialogUtil.createSectionComposite((Composite)this.client());
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)DialogUtil.createGridLayout((int)(this.showSeparators() ? 3 : 2), (int)0, (int)0, (int)2));
        composite2.setLayoutData((Object)DialogUtil.createFillGridData());
        ImageInfoSection imageInfoSection = new ImageInfoSection(composite2, this.infos);
        imageInfoSection.composeImageSummary(this.view, role);
        return imageInfoSection;
    }

    protected boolean useInnerClient() {
        return false;
    }

    private void createInfoSections() {
        for (ImageInfoSection imageInfoSection : this.infos.values()) {
            imageInfoSection.getParent().getParent().dispose();
        }
        this.infos.clear();
        boolean bl = this.view.isThreeWay();
        ((GridLayout)this.client().getLayout()).numColumns = bl ? 3 : 2;
        for (Role role : Relation.roles((boolean)bl)) {
            this.infos.put(role, this.createInfoSection(role));
        }
    }

    protected String expandPrefKey() {
        return PrefKey.I_EXPAND_INFO.toString();
    }
}

