/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal.ui;

import com.deltawalker.Delta;
import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltawalker.Relation;
import com.deltawalker.image.internal.Context;
import com.deltawalker.image.internal.IImageProvider;
import com.deltawalker.image.internal.ITileList;
import com.deltawalker.image.internal.ITileListener;
import com.deltawalker.image.internal.ImageDiffDoc;
import com.deltawalker.image.internal.ImageDoc;
import com.deltawalker.image.internal.ImageInfo;
import com.deltawalker.image.internal.Scale;
import com.deltawalker.image.internal.common.GeomUtil;
import com.deltawalker.image.internal.common.operation.ImageDeltaKind;
import com.deltawalker.image.internal.ui.IImageFacade;
import com.deltawalker.image.internal.ui.IImageRenderProvider;
import com.deltawalker.image.internal.ui.IImageRenderProviderPanner;
import com.deltawalker.image.internal.ui.ImageCanvas;
import com.deltawalker.image.internal.ui.ImageContentArea;
import com.deltawalker.image.internal.ui.ImageDashboardCenter;
import com.deltawalker.image.internal.ui.ImageDiffController;
import com.deltawalker.image.internal.ui.ImageSash;
import com.deltawalker.image.internal.ui.Zoom;
import com.deltawalker.script.Role;
import com.deltawalker.ui.ContentArea;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.Sash;
import com.deltopia.interfaces.IMvcModel;
import com.deltopia.ui.Direction;
import com.deltopia.util.OS;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ImageDiffView
extends DiffView {
    private static final Logger LOG = LoggerFactory.getLogger(ImageDiffView.class);
    private ImageDashboardCenter dbCenter;
    private boolean dockPanner = true;
    private ImageDeltaKind dType = ImageDeltaKind.ALL;
    private final ImageFacade facade;
    private final MainRenderProvider mainProvider;
    private final PannerRenderProvider pannerProvider;
    private boolean singlePanner;
    private int threshold;
    private boolean zoomFromPrefs = true;
    private Zoom zoomReal = null;
    private Zoom zoomView = Zoom.fromPreset(Zoom.Preset.FIT);

    public ImageDiffView(Composite composite, int n) {
        super(composite, 0, n);
        if (LOG.isInfoEnabled()) {
            LOG.info("C-tor: " + ImageDiffView.class.getSimpleName());
        }
        this.facade = new ImageFacade();
        this.mainProvider = new MainRenderProvider();
        this.pannerProvider = new PannerRenderProvider();
        this.singlePanner = PrefUtil.getGlobalPrefs().getBoolean(PrefKey.I_SHOW_SINGLE_PANNER.toString());
    }

    public void addFocusListener(FocusListener focusListener) {
        super.addFocusListener(focusListener);
        for (Role role : Relation.roles((boolean)true)) {
            this.contentArea(role).addFocusListener(focusListener);
        }
    }

    public ImageContentArea contentArea(Role role) {
        return (ImageContentArea)super.contentArea(role);
    }

    protected void createBirdsEye(Composite composite) {
    }

    protected ContentArea createContentArea(Composite composite, Role role) {
        return new ImageContentArea(composite, 0, this, role);
    }

    protected ImageDiffController createController() {
        return new ImageDiffController();
    }

    protected void createDashboard(int n) {
        super.createDashboard(OS.WIN ? 0 : n);
    }

    protected Composite createDashboardCenter() {
        this.dbCenter = new ImageDashboardCenter((Composite)this.dashboard(), 0, this);
        return this.dbCenter;
    }

    protected void createGotoButtons(Composite composite) {
    }

    protected Sash createVerticalSash(Composite composite, Relation relation, boolean bl) {
        return new ImageSash(composite, this, EnumSet.of(Direction.HORIZONTAL), bl, null);
    }

    public ImageDoc doc(Role role) {
        return (ImageDoc)super.doc(role);
    }

    protected void doVerticalScroll(int n, int n2, int n3, Control control) {
        if (this.isSyncedVScrolling() || control == null) {
            double d = 1.0;
            ScrollBar scrollBar = this.commonScrollBar();
            int n4 = scrollBar.getMaximum() - scrollBar.getThumb();
            if (n4 > 0) {
                d = 1.0f / (float)n4;
            }
            this.inScrolling = true;
            try {
                int[] nArray = new int[Role.count()];
                if (this.isThreeWay()) {
                    nArray[Role.ONE.toInt()] = n2;
                    nArray[Role.REF.toInt()] = n;
                    nArray[Role.TWO.toInt()] = n3;
                } else {
                    nArray[Role.REF.toInt()] = n2;
                    nArray[Role.ONE.toInt()] = n;
                }
                for (Role role : this.roles()) {
                    this.doVerticalScroll((Scrollable)this.scrollable(role), nArray[role.toInt()], d);
                }
            }
            finally {
                this.inScrolling = false;
            }
        }
    }

    private void doVerticalScroll(Scrollable scrollable, int n, double d) {
        ScrollBar scrollBar = scrollable.getVerticalBar();
        if (scrollBar == null) {
            return;
        }
        double d2 = (double)(scrollBar.getMaximum() - scrollBar.getThumb()) * d * (double)n;
        int n2 = scrollBar.getMaximum() - scrollBar.getMinimum();
        if (n2 > 0) {
            scrollBar.setSelection((int)d2);
            scrollBar.notifyListeners(13, null);
        }
    }

    public ImageDiffDoc getInput() {
        return (ImageDiffDoc)super.getInput();
    }

    private Dimension getLargestSize() {
        Dimension dimension = new Dimension(0, 0);
        for (Role role : this.roles()) {
            ImageInfo imageInfo = this.imageInfo(role);
            if (imageInfo == null) continue;
            dimension.width = Math.max(dimension.width, imageInfo.width);
            dimension.height = Math.max(dimension.height, imageInfo.height);
        }
        return dimension;
    }

    private final Zoom getRealZoom() {
        if (this.zoomReal == null) {
            this.updateRealZoom(true);
            if (this.zoomReal == null) {
                LOG.warn("Cannot access real zoom yet " + this.zoomView);
                return null;
            }
        }
        assert (this.zoomReal.hasScale());
        return this.zoomReal;
    }

    public int getSashWidth() {
        return 5;
    }

    private Scale getScaleForZoom(Zoom zoom) {
        if (zoom.hasScale()) {
            return zoom.getScale();
        }
        Scale scale = null;
        for (Role role : this.roles()) {
            ImageInfo imageInfo = this.imageInfo(role);
            if (imageInfo == null) continue;
            Dimension dimension = this.contentArea(role).getMainSize();
            if (GeomUtil.isEmpty(dimension)) {
                return null;
            }
            Scale scale2 = zoom.getScaleFor(imageInfo, dimension);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Calculate scale '" + role + "': " + scale2 + " image=" + imageInfo.getSize() + " canvas=" + dimension);
            }
            if (scale2 == null || scale != null && scale2.compareTo(scale) >= 0) continue;
            scale = scale2;
        }
        return scale;
    }

    private Scale getScaleMain() {
        Zoom zoom = this.getRealZoom();
        return zoom != null ? zoom.getScale() : Scale.NO;
    }

    private Scale getScalePanner(Role role) {
        ImageInfo imageInfo = this.imageInfo(role);
        if (imageInfo == null) {
            return Scale.NO;
        }
        return Zoom.FIT_IMAGE.getScaleFor(imageInfo, this.contentArea(role).pannerSize());
    }

    public final int getThreshold() {
        return this.threshold;
    }

    public boolean hasDeltas(Set<Delta> set) {
        return false;
    }

    public ImageFacade imageFacade() {
        return this.facade;
    }

    private ImageInfo imageInfo(Role role) {
        return this.getInput().getImageDescriptor(role);
    }

    public IImageProvider imageProvider(Role role) {
        return this.getInput().getProvider(role, this.dType);
    }

    public final Dimension imageSize(Role role) {
        IImageProvider iImageProvider = this.imageProvider(role);
        return iImageProvider != null ? iImageProvider.info().getSize() : new Dimension(0, 0);
    }

    protected void initializeDashboard() {
        for (Role role : this.roles()) {
            this.contentArea(role).setImageFacade(this.facade);
        }
        if (this.dbCenter != null) {
            this.dbCenter.connect((IMvcModel)this.getInput(), null);
            this.dbCenter.layout(true, true);
        }
    }

    protected void inputChanged(Object object, Object object2) {
        super.inputChanged(object, object2);
        if (this.dbCenter != null) {
            this.dbCenter.connect((IMvcModel)object, null);
            this.dbCenter.layout(true, true);
            if (object instanceof ImageDiffDoc && !this.getInput().isEmpty()) {
                IPreferenceStore iPreferenceStore = this.getInput().preferences();
                this.threshold = iPreferenceStore.getInt(PrefKey.I_THRESHOLD_FACTOR.toString());
                if (this.dbCenter.actionsExpandable() != null) {
                    this.dbCenter.actionsExpandable().updateThresholdUI();
                }
            }
        }
    }

    protected boolean propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        Object object = propertyChangeEvent.getSource();
        if (object instanceof IPreferenceStore) {
            boolean bl = true;
            IPreferenceStore iPreferenceStore = (IPreferenceStore)object;
            if (string.equals(PrefKey.I_SHOW_PANNER.toString())) {
                this.facade.showPanner(iPreferenceStore.getBoolean(PrefKey.I_SHOW_PANNER.toString()), true);
            } else if (string.equals(PrefKey.I_SHOW_SINGLE_PANNER.toString())) {
                this.singlePanner = iPreferenceStore.getBoolean(PrefKey.I_SHOW_SINGLE_PANNER.toString());
                this.facade.showPanner(iPreferenceStore.getBoolean(PrefKey.I_SHOW_PANNER.toString()), true);
            } else {
                bl = super.propertyChange(propertyChangeEvent);
            }
            return bl;
        }
        return super.propertyChange(propertyChangeEvent);
    }

    public void removeFocusListener(FocusListener focusListener) {
        super.removeFocusListener(focusListener);
        for (Role role : Relation.roles((boolean)true)) {
            this.contentArea(role).removeFocusListener(focusListener);
        }
    }

    public final ImageCanvas scrollable(Role role) {
        return (ImageCanvas)super.scrollable(role);
    }

    protected Color scrollableBackgroundColor() {
        int n = OS.OSX ? 16 : 22;
        return this.rootComposite().getDisplay().getSystemColor(n);
    }

    protected void scrollOther(Role role, Role role2, ScrollBar scrollBar, int n) {
    }

    private void setDeltaKind(ImageDeltaKind imageDeltaKind) {
        if (imageDeltaKind == null) {
            throw new NullPointerException("dType");
        }
        if (imageDeltaKind == this.dType) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Change show type: " + (Object)((Object)this.dType) + " -> " + (Object)((Object)imageDeltaKind));
        }
        this.dType = imageDeltaKind;
        this.updateContent();
        for (Role role : this.roles()) {
            this.contentArea(role).refresh();
        }
    }

    public void setDockPanner(boolean bl) {
        this.dockPanner = bl;
    }

    private final void setThreshold(int n) {
        if (this.threshold == n) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Threshold is not changed " + n);
            }
            return;
        }
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("threshold " + n);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Change threshold from " + this.threshold + " to " + n);
        }
        this.threshold = n;
        IPreferenceStore iPreferenceStore = this.getInput().preferences();
        iPreferenceStore.putValue(PrefKey.I_THRESHOLD_FACTOR.toString(), Integer.valueOf(n).toString());
        for (Role role : this.roles()) {
            this.contentArea(role).refresh();
        }
    }

    private final void setZoom(Zoom zoom) {
        if (zoom.hasScale() && this.zoomView.equals(zoom)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Zoom is not changed: " + this.zoomView);
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set zoom: " + zoom);
        }
        this.zoomView = zoom;
        this.updateRealZoom(true);
    }

    public boolean shouldDockPanner() {
        return this.dockPanner;
    }

    public void updateCommonScrollBar() {
        int n;
        if (!this.syncVScroll) {
            return;
        }
        ScrollBar scrollBar = this.getReferenceScrollBar();
        if (scrollBar != null && (n = scrollBar.getThumb()) > 0) {
            this.sbCommon.setMinimum(scrollBar.getMinimum());
            this.sbCommon.setMaximum(scrollBar.getMaximum());
            int n2 = scrollBar.getIncrement();
            int n3 = scrollBar.getPageIncrement();
            this.sbCommon.setIncrement(n2);
            this.sbCommon.setPageIncrement(n3);
            this.sbCommon.setThumb(n);
            this.sbCommon.setSelection(scrollBar.getSelection());
        } else {
            this.sbCommon.setMinimum(0);
            this.sbCommon.setMaximum(1);
            this.sbCommon.setThumb(1);
            this.sbCommon.setSelection(0);
        }
    }

    protected void updateContent() {
        super.updateContent();
        for (Role role : this.roles()) {
            ImageContentArea imageContentArea = this.contentArea(role);
            imageContentArea.setImageFacade(this.facade);
            imageContentArea.setInput(null, null);
            IImageProvider iImageProvider = this.imageProvider(role);
            if (LOG.isInfoEnabled()) {
                LOG.info("Set provider " + role + ": " + iImageProvider);
            }
            if (iImageProvider == null || iImageProvider.info() == null) continue;
            imageContentArea.setInput(this.mainProvider, this.pannerProvider);
            ImageInfo imageInfo = iImageProvider.info();
            Scale scale = this.getScalePanner(role);
            Rectangle rectangle = scale.multiply(imageInfo.getBounds());
            imageContentArea.centerPanner(rectangle);
            imageContentArea.redraw();
        }
        this.updateRealZoom(true);
        if (this.facade != null) {
            Role role;
            role = this.getInput().preferences();
            boolean bl = role.getBoolean(PrefKey.I_SHOW_PANNER.toString());
            this.facade.showPanner(bl, true);
        }
    }

    private final void updateRealZoom(boolean bl) {
        if (this.getInput().isEmpty()) {
            return;
        }
        IPreferenceStore iPreferenceStore = this.getInput().preferences();
        if (this.zoomFromPrefs) {
            this.zoomView = Zoom.fromString(iPreferenceStore.getString(PrefKey.I_ZOOM_FACTOR.toString()));
            this.zoomFromPrefs = false;
        } else {
            iPreferenceStore.putValue(PrefKey.I_ZOOM_FACTOR.toString(), this.zoomView.toString());
        }
        Scale scale = this.getScaleForZoom(this.zoomView);
        if (scale == null) {
            this.zoomReal = null;
            return;
        }
        Zoom zoom = Zoom.fromScale(scale);
        if (zoom.equals(this.zoomReal)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Real zoom is not changed: " + this.zoomReal);
            }
            if (bl) {
                return;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Update real zoom=" + zoom);
        }
        this.zoomReal = zoom;
        if (this.dbCenter.actionsExpandable() != null) {
            this.dbCenter.actionsExpandable().updateZoomUI(this.zoomView, this.zoomReal);
        }
        for (Role role : this.roles()) {
            ImageContentArea imageContentArea = this.contentArea(role);
            imageContentArea.sizeChanged();
            imageContentArea.scrollable().sizeScrollBars();
            imageContentArea.updatePannerVisibility();
        }
        this.updateCommonScrollBar();
    }

    private abstract class BaseRenderProvider
    implements IImageRenderProvider {
        private final boolean canCancelRequests;

        protected BaseRenderProvider(boolean bl) {
            this.canCancelRequests = bl;
        }

        @Override
        public void addTileListener(Role role, ITileListener iTileListener) throws NullPointerException {
            IImageProvider iImageProvider = ImageDiffView.this.imageProvider(role);
            iImageProvider.addTileListener(iTileListener);
        }

        @Override
        public final Dimension displaySize(Role role) {
            Dimension dimension = ImageDiffView.this.imageSize(role);
            Scale scale = this.scale(role);
            Dimension dimension2 = scale.multiply(dimension);
            return dimension2;
        }

        @Override
        public final Dimension largestSize(Role role) {
            Dimension dimension = ImageDiffView.this.getLargestSize();
            if (GeomUtil.isEmpty(dimension)) {
                return dimension;
            }
            return this.scale(role).multiply(dimension);
        }

        @Override
        public void removeTileListener(Role role, ITileListener iTileListener) throws NullPointerException {
            IImageProvider iImageProvider = ImageDiffView.this.imageProvider(role);
            if (iImageProvider != null) {
                iImageProvider.removeTileListener(iTileListener);
            }
        }

        @Override
        public final ITileList requestTiles(ITileListener iTileListener, Role role, Rectangle rectangle, Point point) {
            Context context = new Context(this.scale(role), ImageDiffView.this.threshold, rectangle, point, this.canCancelRequests);
            IImageProvider iImageProvider = ImageDiffView.this.imageProvider(role);
            return iImageProvider.requestTiles(iTileListener, context);
        }

        protected abstract Scale scale(Role var1);
    }

    private class ImageFacade
    implements IImageFacade {
        private ImageFacade() {
        }

        @Override
        public void canvasSizeChanged() {
            ImageDiffView.this.updateRealZoom(false);
        }

        @Override
        public void moveImage(int n, int n2) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Move position to " + n + 'x' + n2);
            }
            for (Role role : ImageDiffView.this.roles()) {
                ImageDiffView.this.contentArea(role).setOrigin(n, n2);
                ImageCanvas imageCanvas = ImageDiffView.this.scrollable(role);
                if (ImageDiffView.this.isCommonScrollBarVisible()) {
                    ImageDiffView.this.commonScrollBar().setSelection(-n2);
                }
                imageCanvas.getVerticalBar().setSelection(-n2);
                imageCanvas.getHorizontalBar().setSelection(-n);
                imageCanvas.redraw();
            }
        }

        @Override
        public void movePanner(int n, int n2) {
            for (Role role : ImageDiffView.this.roles()) {
                ImageDiffView.this.contentArea(role).movePanner(n, n2);
            }
        }

        @Override
        public void setDockPanner(boolean bl) {
            ImageDiffView.this.setDockPanner(bl);
        }

        @Override
        public void setThreshold(int n) {
            ImageDiffView.this.setThreshold(n);
        }

        @Override
        public void showPanner(boolean bl, boolean bl2) {
            ArrayList arrayList = new ArrayList(Relation.roles((boolean)ImageDiffView.this.isThreeWay()));
            Collections.reverse(arrayList);
            boolean bl3 = bl;
            for (Role role : arrayList) {
                ImageContentArea imageContentArea = ImageDiffView.this.contentArea(role);
                if (imageContentArea == null) continue;
                boolean bl4 = bl3;
                if (bl4 && !imageContentArea.scrollable().hasImage()) {
                    bl4 = false;
                }
                imageContentArea.showPanner(bl4);
                if (LOG.isInfoEnabled()) {
                    LOG.info(String.valueOf(bl4 ? "Showing" : "Hiding") + " panner for " + role + " role");
                }
                if (!bl4 || !ImageDiffView.this.singlePanner) continue;
                bl3 = false;
            }
            if (bl2 && ImageDiffView.this.dbCenter.actionsExpandable() != null) {
                ImageDiffView.this.dbCenter.actionsExpandable().selectPannerUI(bl);
            }
        }

        @Override
        public void showPixelsOfKind(ImageDeltaKind imageDeltaKind) {
            ImageDiffView.this.setDeltaKind(imageDeltaKind);
        }

        @Override
        public void zoomIn(boolean bl) {
            Zoom zoom;
            if (LOG.isInfoEnabled()) {
                LOG.info("Zoom " + (bl ? "In" : "Out"));
            }
            if ((zoom = ImageDiffView.this.getRealZoom()) != null) {
                Zoom zoom2;
                Zoom zoom3 = zoom2 = bl ? zoom.zoomIn() : zoom.zoomOut();
                if (zoom2 != null) {
                    ImageDiffView.this.setZoom(zoom2);
                }
            }
        }

        @Override
        public void zoomTo(Zoom zoom) {
            ImageDiffView.this.setZoom(zoom);
        }
    }

    private final class MainRenderProvider
    extends BaseRenderProvider {
        protected MainRenderProvider() {
            super(true);
        }

        @Override
        protected Scale scale(Role role) {
            return ImageDiffView.this.getScaleMain();
        }
    }

    private final class PannerRenderProvider
    extends BaseRenderProvider
    implements IImageRenderProviderPanner {
        protected PannerRenderProvider() {
            super(false);
        }

        @Override
        public Scale getRelativeScale(Role role) {
            Scale scale = this.scale(role);
            Scale scale2 = ImageDiffView.this.getScaleMain();
            Scale scale3 = scale.divide(scale2);
            return scale3;
        }

        @Override
        public Rectangle getVisibleRect(Role role) {
            Dimension dimension = ImageDiffView.this.imageSize(role);
            if (GeomUtil.isEmpty(dimension)) {
                return new Rectangle(0, 0, 0, 0);
            }
            Rectangle rectangle = ImageDiffView.this.contentArea(role).getMainRect();
            rectangle = ImageDiffView.this.getScaleMain().divide(rectangle);
            Rectangle rectangle2 = new Rectangle(dimension);
            if ((rectangle = rectangle.intersection(rectangle2)).isEmpty()) {
                return rectangle;
            }
            return this.scale(role).multiply(rectangle);
        }

        @Override
        protected Scale scale(Role role) {
            return ImageDiffView.this.getScalePanner(role);
        }
    }
}

