/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal.ui;

import com.deltawalker.PrefKey;
import com.deltawalker.image.internal.ui.ImageActionsExpandable;
import com.deltawalker.image.internal.ui.ImageDiffView;
import com.deltawalker.image.internal.ui.ImageInfoExpandable;
import com.deltawalker.ui.DashboardCenter;
import com.deltawalker.ui.DiffView;
import com.deltopia.interfaces.IMvcController;
import com.deltopia.interfaces.IMvcModel;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ImageDashboardCenter
extends DashboardCenter {
    private ImageActionsExpandable expActions;
    private ImageInfoExpandable expInfo;
    private int orientation = Window.getDefaultOrientation();

    public ImageDashboardCenter(Composite composite, int n, ImageDiffView imageDiffView) {
        super(composite, n, (DiffView)imageDiffView);
        GridData gridData = new GridData(4, 4, true, true);
        this.setLayoutData(gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = gridLayout.marginHeight;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 1;
        this.setLayout((Layout)gridLayout);
    }

    public ImageActionsExpandable actionsExpandable() {
        return this.expActions;
    }

    public void connect(IMvcModel iMvcModel, IMvcController iMvcController) {
        super.connect(iMvcModel, iMvcController);
        this.createActionsExpandable();
        this.createInfoExpandable();
        this.expActions.connect(iMvcModel, iMvcController);
        this.expInfo.connect(iMvcModel, iMvcController);
    }

    public void createActionsExpandable() {
        if (this.expActions != null) {
            return;
        }
        this.expActions = new ImageActionsExpandable((Composite)this, this.orientation, this.deltaView());
    }

    public void createInfoExpandable() {
        if (this.expInfo != null) {
            return;
        }
        this.expInfo = new ImageInfoExpandable((Composite)this, this.orientation, this.deltaView());
    }

    protected ImageDiffView deltaView() {
        return (ImageDiffView)super.deltaView();
    }

    public void disconnect() {
        this.expActions.disconnect();
        this.expInfo.disconnect();
        super.disconnect();
    }

    public void dispose() {
        try {
            this.disconnect();
            if (this.expActions != null) {
                this.expActions.dispose();
                this.expActions = null;
            }
            if (this.expInfo != null) {
                this.expInfo.dispose();
                this.expInfo = null;
            }
        }
        finally {
            super.dispose();
        }
    }

    protected boolean prefChanged(IPreferenceStore iPreferenceStore, String string) {
        boolean bl = true;
        if (string.equals(PrefKey.I_EXPAND_ACTIONS.toString())) {
            this.expActions.setExpanded(iPreferenceStore.getBoolean(PrefKey.I_EXPAND_ACTIONS.toString()));
        } else if (string.equals(PrefKey.I_EXPAND_INFO.toString())) {
            this.expInfo.setExpanded(iPreferenceStore.getBoolean(PrefKey.I_EXPAND_INFO.toString()));
        } else {
            bl = super.prefChanged(iPreferenceStore, string);
        }
        return bl;
    }
}

