/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal.ui;

import com.deltawalker.image.internal.common.GeomUtil;
import com.deltawalker.image.internal.ui.IImageFacade;
import com.deltawalker.image.internal.ui.IImageRenderProvider;
import com.deltawalker.image.internal.ui.IImageRenderProviderPanner;
import com.deltawalker.image.internal.ui.ImageCanvas;
import com.deltawalker.image.internal.ui.ImageContextId;
import com.deltawalker.image.internal.ui.ImageDiffView;
import com.deltawalker.image.internal.ui.ImagePanner;
import com.deltawalker.script.Role;
import com.deltawalker.ui.ContentArea;
import com.deltawalker.ui.DiffView;
import com.deltopia.ui.swt.Border;
import com.deltopia.ui.swt.BorderDoubleLine;
import com.deltopia.ui.swt.IFocusNotifier;
import com.deltopia.ui.swt.IVerticalScrollBarOwner;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

final class ImageContentArea
extends ContentArea
implements IFocusNotifier {
    private static final Insets PANNER_BORDER_GAP = new Insets(18, 5, 5, 5);
    private static final Dimension PANNER_SIZE = new Dimension(136, 144);
    private ImageCanvas canvas;
    private ImagePanner panner;
    private boolean showPanner = false;

    public ImageContentArea(Composite composite, int n, ImageDiffView imageDiffView, Role role) {
        super(composite, n | 0x40000, (DiffView)imageDiffView, role);
        this.populate();
        this.postPopulate();
    }

    public void addFocusListener(FocusListener focusListener) {
        assert (focusListener != null);
        this.canvas.addFocusListener(focusListener);
    }

    void centerPanner(Rectangle rectangle) throws IllegalStateException {
        this.isInitialized();
        Rectangle rectangle2 = this.panner.getClientRect();
        GeomUtil.center(rectangle, rectangle2);
        this.panner.setOrigin(rectangle.x, rectangle.y);
    }

    protected ImageDiffView deltaView() {
        return (ImageDiffView)super.deltaView();
    }

    private void dockPanner() {
        org.eclipse.swt.graphics.Rectangle rectangle = this.getClientArea();
        Point point = new Point(rectangle.width - ImageContentArea.PANNER_SIZE.width, rectangle.height - ImageContentArea.PANNER_SIZE.height);
        Point point2 = this.panner.getLocation();
        if (this.deltaView().shouldDockPanner()) {
            this.movePanner(point.x, point.y);
        } else if (point2.x > point.x - 5 || point2.y > point.y - 5) {
            this.deltaView().setDockPanner(true);
        }
    }

    protected String getHelpContextId() {
        return ImageContextId.IMAGE_COMPARISON_WINDOW;
    }

    Rectangle getMainRect() throws IllegalStateException {
        this.isInitialized();
        Rectangle rectangle = this.canvas.getClientRect();
        java.awt.Point point = this.canvas.getOrigin();
        rectangle.translate(-point.x, -point.y);
        return rectangle;
    }

    Dimension getMainSize() throws IllegalStateException {
        this.isInitialized();
        return this.canvas.getClientDimension();
    }

    public final boolean hasImage() {
        return this.canvas.hasImage();
    }

    public boolean isFocusControl() {
        return this.canvas != null && this.canvas.isFocusControl();
    }

    private void isInitialized() {
        if (this.canvas == null || this.panner == null) {
            throw new IllegalStateException("Content area not yet initialized.");
        }
    }

    public void movePanner(int n, int n2) {
        this.isInitialized();
        this.panner.move(n, n2);
    }

    public Dimension pannerSize() throws IllegalStateException {
        this.isInitialized();
        return this.panner.getClientDimension();
    }

    private void populate() {
        this.canvas = new ImageCanvas((Composite)this, this.role(), 0, (IVerticalScrollBarOwner)this.deltaView());
        this.canvas.setBackground(this.getDisplay().getSystemColor(16));
        this.panner = new ImagePanner((Composite)this.canvas, this.role(), 0x40080000, (IVerticalScrollBarOwner)this.deltaView());
        this.panner.setBorder((Border)new BorderDoubleLine((Device)this.getDisplay(), 17, 19, PANNER_BORDER_GAP, 1));
        this.panner.setSize(ImageContentArea.PANNER_SIZE.width, ImageContentArea.PANNER_SIZE.height);
    }

    public void refresh() throws IllegalStateException {
        this.isInitialized();
        this.canvas.redraw();
        this.panner.redraw();
    }

    public void removeFocusListener(FocusListener focusListener) {
        assert (focusListener != null);
        this.canvas.removeFocusListener(focusListener);
    }

    public ImageCanvas scrollable() {
        return this.canvas;
    }

    void setImageFacade(IImageFacade iImageFacade) throws IllegalStateException {
        this.isInitialized();
        this.canvas.setImageFacade(iImageFacade);
        this.panner.setImageFacade(iImageFacade);
    }

    public void setInput(IImageRenderProvider iImageRenderProvider, IImageRenderProviderPanner iImageRenderProviderPanner) {
        this.isInitialized();
        this.canvas.setProvider(iImageRenderProvider);
        this.panner.setProvider(iImageRenderProviderPanner);
    }

    void setOrigin(int n, int n2) throws IllegalStateException {
        this.isInitialized();
        boolean bl = this.canvas.setOrigin(n, n2);
        if (bl) {
            this.panner.redraw();
        }
    }

    protected void setupSyncedScroll(boolean bl) {
    }

    public void showPanner(boolean bl) {
        this.showPanner = bl;
        this.updatePannerVisibility();
    }

    public void sizeChanged() {
        this.isInitialized();
        this.canvas.sizeScrollBars();
        this.dockPanner();
        this.refresh();
    }

    public void updatePannerVisibility() {
        boolean bl = this.canvas.getClientArea().isEmpty() || this.scrollable().isImageFitting();
        this.panner.setVisible(this.showPanner && !bl);
    }
}

