/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal.ui;

import com.deltawalker.image.internal.ITileList;
import com.deltawalker.image.internal.ITileListener;
import com.deltawalker.image.internal.Tile;
import com.deltawalker.image.internal.common.AwtToSwtImageConverter;
import com.deltawalker.image.internal.common.GeomUtil;
import com.deltawalker.image.internal.common.SwtGeometryUtil;
import com.deltawalker.image.internal.ui.IImageFacade;
import com.deltawalker.image.internal.ui.IImageRenderProvider;
import com.deltawalker.script.Role;
import com.deltawalker.ui.ControlUtil;
import com.deltawalker.ui.UIUtil;
import com.deltopia.ui.swt.Border;
import com.deltopia.ui.swt.IVerticalScrollBarOwner;
import com.deltopia.util.logging.ToString;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ImageCanvasBase
extends Canvas {
    private static final boolean DRAW_CHECKERED_BG = true;
    private static Image imageCB;
    public static final String KEY_CHECKERED_BG1 = "checkeredBg1";
    public static final String KEY_CHECKERED_BG2 = "checkeredBg2";
    private static final Logger LOG;
    private static final boolean MEASURE_PAINT = false;
    private static final boolean PAINT_CHECK = true;
    private static final boolean PAINT_DETAILED_CHECK = false;
    private static final boolean PAINT_TILE_META = false;
    private static Color rgbCB1;
    private static Color rgbCB2;
    private static final boolean TRACE_PAINT_DETAIL = false;
    private static final boolean TRACE_PAN = false;
    private final Adapter adapter;
    private final boolean allowOriginOutside;
    private Border border;
    private IImageFacade imgFacade;
    private final Point origin = new Point(0, 0);
    protected IVerticalScrollBarOwner ownerSB;
    private IImageRenderProvider provider;
    protected final Role role;

    static {
        LOG = LoggerFactory.getLogger(ImageCanvasBase.class);
        JFaceResources.getColorRegistry().addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getProperty();
                if (ImageCanvasBase.KEY_CHECKERED_BG1.equals(string) || ImageCanvasBase.KEY_CHECKERED_BG2.equals(string)) {
                    ImageCanvasBase.updateColors();
                }
            }
        });
        ImageCanvasBase.updateColors();
    }

    private static void updateColors() {
        Display display = UIUtil.display();
        ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
        rgbCB1 = new Color((Device)display, colorRegistry.getRGB(KEY_CHECKERED_BG1));
        rgbCB2 = new Color((Device)display, colorRegistry.getRGB(KEY_CHECKERED_BG2));
        if (imageCB != null) {
            imageCB.dispose();
        }
        imageCB = ControlUtil.createCheckeredBgImage((Display)display, (Color)rgbCB1, (Color)rgbCB2);
    }

    protected ImageCanvasBase(Composite composite, Role role, int n, boolean bl, IVerticalScrollBarOwner iVerticalScrollBarOwner) {
        super(composite, n | 0x40000 | 0x100000);
        assert (role != null);
        this.adapter = new Adapter();
        this.role = role;
        this.allowOriginOutside = bl;
        this.ownerSB = iVerticalScrollBarOwner;
        this.addPaintListener(this.adapter);
    }

    public void dispose() {
        this.disposeProvider();
    }

    private final void disposeProvider() {
        if (this.provider != null) {
            this.provider.removeTileListener(this.role, this.adapter);
            this.provider = null;
        }
    }

    public final Border getBorder() {
        return this.border;
    }

    public org.eclipse.swt.graphics.Rectangle getClientArea() {
        org.eclipse.swt.graphics.Rectangle rectangle = super.getClientArea();
        if (this.border != null) {
            Insets insets = this.border.getInsets();
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            if (rectangle.width < 0) {
                rectangle.width = 0;
            }
            if (rectangle.height < 0) {
                rectangle.height = 0;
            }
        }
        return rectangle;
    }

    final Dimension getClientDimension() {
        org.eclipse.swt.graphics.Rectangle rectangle = this.getClientArea();
        return new Dimension(rectangle.width, rectangle.height);
    }

    Rectangle getClientRect() {
        return SwtGeometryUtil.rectSwt2Awt(this.getClientArea());
    }

    final IImageFacade getImageFacade() {
        return this.imgFacade;
    }

    public final Point getOrigin() {
        return new Point(this.origin.x, this.origin.y);
    }

    protected org.eclipse.swt.graphics.Rectangle getOutermostClientArea() {
        return super.getClientArea();
    }

    final Role getRole() {
        return this.role;
    }

    public final boolean hasImage() {
        return this.imageProvider() != null;
    }

    protected final Rectangle imageBounds() {
        Rectangle rectangle = this.getClientRect();
        if (!this.hasImage() || rectangle.isEmpty()) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle rectangle2 = new Rectangle(this.origin, this.provider.displaySize(this.role));
        rectangle2 = rectangle2.intersection(this.getClientRect());
        return rectangle2;
    }

    IImageRenderProvider imageProvider() {
        return this.provider;
    }

    private final Dimension largestSize() {
        org.eclipse.swt.graphics.Rectangle rectangle = this.getClientArea();
        if (!this.hasImage() || rectangle.isEmpty()) {
            return new Dimension(0, 0);
        }
        return this.provider.largestSize(this.role);
    }

    private final Insets originLimits() {
        Dimension dimension = this.getClientDimension();
        Dimension dimension2 = this.largestSize();
        Insets insets = !this.allowOriginOutside ? new Insets(Math.min(dimension.height - dimension2.height, 0), Math.min(dimension.width - dimension2.width, 0), 0, 0) : new Insets(-dimension2.height, -dimension2.width, dimension.height, dimension.width);
        return insets;
    }

    protected void paint(GC gC) {
        try {
            org.eclipse.swt.graphics.Rectangle rectangle;
            long l = 0L;
            if (this.border != null) {
                this.border.paintBorder((Control)this, gC, super.getClientArea());
            }
            if ((rectangle = gC.getClipping()).isEmpty()) {
                return;
            }
            Rectangle rectangle2 = SwtGeometryUtil.rectSwt2Awt(rectangle);
            if (LOG.isInfoEnabled()) {
                LOG.info(new ToString().append("-> Paint", (Object)this).append(", client", rectangle2).append(", origin", this.origin).toString());
            }
            if (!this.hasImage()) {
                this.paintBackground(gC, rectangle, null);
                return;
            }
            Rectangle rectangle3 = new Rectangle(this.origin, this.provider.displaySize(this.role));
            rectangle3 = rectangle3.intersection(rectangle2);
            Rectangle rectangle4 = new Rectangle(this.origin, this.provider.largestSize(this.role));
            rectangle4 = rectangle3.intersection(rectangle2);
            if (rectangle4.isEmpty()) {
                this.paintBackground(gC, rectangle, null);
                return;
            }
            Rectangle rectangle5 = SwtGeometryUtil.rectSwt2Awt(rectangle);
            ITileList iTileList = this.provider.requestTiles(this.adapter, this.role, rectangle5, this.origin.getLocation());
            if (iTileList == null) {
                assert (false);
                return;
            }
            if (iTileList.shouldPaintBackground()) {
                this.paintBackground(gC, rectangle, rectangle4);
                this.paintCheckedBackground(gC, rectangle4);
            } else {
                this.paintBackground(gC, rectangle, rectangle3);
            }
            long l2 = 0L;
            l2 = this.paintImage(gC, iTileList);
        }
        catch (Throwable throwable) {
            LOG.error("Error painting image " + (Object)((Object)this), throwable);
        }
    }

    private void paintBackground(GC gC, org.eclipse.swt.graphics.Rectangle rectangle, Rectangle rectangle2) {
        if ((this.getStyle() & 0x40000000) != 0) {
            return;
        }
        Color color = gC.getBackground();
        gC.setBackground(this.getBackground());
        if (rectangle2 == null) {
            gC.fillRectangle(rectangle);
        } else {
            int n = rectangle.y + rectangle.height;
            int n2 = rectangle.x + rectangle.width;
            int n3 = rectangle2.y + rectangle2.height;
            int n4 = rectangle2.x + rectangle2.width;
            if (n4 < 0 || n3 < 0 || rectangle2.x > n2 || rectangle2.y > n) {
                gC.fillRectangle(rectangle);
                return;
            }
            int n5 = Math.min(rectangle.height, rectangle2.height);
            rectangle2.x = Math.max(0, rectangle2.x);
            rectangle2.y = Math.max(0, rectangle2.y);
            if (rectangle.y < rectangle2.y) {
                gC.fillRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle2.y);
            }
            if (rectangle.x < rectangle2.x) {
                gC.fillRectangle(rectangle.x, rectangle2.y, rectangle2.x, n5);
            }
            if (n > n3) {
                gC.fillRectangle(rectangle.x, n3, rectangle.width, n - n3);
            }
            if (n2 > n4) {
                gC.fillRectangle(n4, rectangle2.y, n2 - n4, n5);
            }
        }
        gC.setBackground(color);
    }

    private void paintCheckedBackground(GC gC, Rectangle rectangle) {
        if ((this.getStyle() & 0x40000000) != 0) {
            return;
        }
        org.eclipse.swt.graphics.Rectangle rectangle2 = imageCB.getBounds();
        int n = rectangle.x / rectangle2.width * rectangle2.width;
        int n2 = rectangle.y / rectangle2.height * rectangle2.height;
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle.y + rectangle.height;
        int n5 = n2;
        while (n5 < n4) {
            int n6 = n5 < rectangle.y ? rectangle.y : n5;
            int n7 = n5 + rectangle2.height > n4 ? n4 - n6 : rectangle2.height - (n6 - n5);
            int n8 = n;
            while (n8 < n3) {
                int n9 = n8 < rectangle.x ? rectangle.x : n8;
                int n10 = n8 + rectangle2.width > n3 ? n3 - n9 : rectangle2.width - (n9 - n8);
                gC.drawImage(imageCB, n9 - n8, n6 - n5, n10, n7, n9, n6, n10, n7);
                n8 += rectangle2.width;
            }
            n5 += rectangle2.height;
        }
    }

    protected long paintImage(GC gC, ITileList iTileList) {
        long l = 0L;
        Area area = new Area();
        while (iTileList.hasNextTile()) {
            Object object;
            Tile tile = iTileList.nextTile();
            Rectangle rectangle = tile.getRectImage();
            Rectangle rectangle2 = tile.getRectContext();
            Raster raster = tile.getRaster();
            if (area.contains(rectangle2)) {
                LOG.warn(new ToString().append("Already painted rect ", rectangle2).append(" in ", area).append("on context", (Object)iTileList.context()).toString());
            }
            area.add(new Area(rectangle2));
            if (raster != null) {
                object = new Rectangle(raster.getWidth(), raster.getHeight());
                if (rectangle.isEmpty()) {
                    LOG.warn(new ToString().append("Empty tile rect", rectangle).append(" on context", (Object)iTileList.context()).toString());
                } else if (!((Rectangle)object).contains(rectangle)) {
                    LOG.warn(new ToString().append("Currect tile image rect", rectangle).append(" out of image", (Rectangle)object).append(" on context", (Object)iTileList.context()).toString());
                }
            }
            if (raster != null) {
                object = tile.getColorModel();
                long l2 = System.nanoTime();
                ImageData imageData = AwtToSwtImageConverter.rasterToImageData(raster, (ColorModel)object);
                l += System.nanoTime() - l2;
                Image image = new Image((Device)this.getDisplay(), imageData);
                try {
                    gC.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    continue;
                }
                finally {
                    image.dispose();
                }
            }
            gC.fillRectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void redrawDeferredTiles(ITileList iTileList) {
        try {
            if (this.isDisposed()) {
                return;
            }
            while (true) {
                if (!iTileList.hasNextTile()) {
                    return;
                }
                Tile tile = iTileList.nextTile();
                Rectangle rectangle = tile.getRectContext(this.origin);
                if (rectangle.isEmpty()) {
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info("--- Not used " + this.role + ", tile=" + tile);
                    continue;
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info(new ToString().append("*** Repaint " + (Object)((Object)this) + ", tile=" + tile).append(", rectConverted", rectangle).toString());
                }
                this.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
            }
        }
        catch (RuntimeException runtimeException) {
            LOG.error("Deferred redraw failed " + (Object)((Object)this), (Throwable)runtimeException);
        }
    }

    public final void setBorder(Border border) {
        if (this.border != null) {
            border.dispose();
        }
        this.border = border;
    }

    final void setImageFacade(IImageFacade iImageFacade) {
        assert (iImageFacade != null);
        this.imgFacade = iImageFacade;
    }

    public final boolean setOrigin(int n, int n2) {
        Insets insets = this.originLimits();
        int n3 = n;
        int n4 = n2;
        if (n3 > insets.right) {
            n3 = insets.right;
        } else if (n3 < insets.left) {
            n3 = insets.left;
        }
        if (n4 > insets.bottom) {
            n4 = insets.bottom;
        } else if (n2 < insets.top) {
            n4 = insets.top;
        }
        if (n3 != this.origin.x || n4 != this.origin.y) {
            int n5 = n3 - this.origin.x;
            int n6 = n4 - this.origin.y;
            Dimension dimension = this.largestSize();
            this.scroll(n5, n6, 0, 0, dimension.width, dimension.height, false);
            this.origin.x = n3;
            this.origin.y = n4;
            return true;
        }
        return false;
    }

    public final void setOrigin(Point point) {
        this.setOrigin(point.x, point.y);
    }

    final void setProvider(IImageRenderProvider iImageRenderProvider) {
        if (this.provider == iImageRenderProvider) {
            if (iImageRenderProvider != null) {
                LOG.warn("RenderProvider is not changed " + iImageRenderProvider);
            }
            return;
        }
        this.disposeProvider();
        this.provider = iImageRenderProvider;
        if (iImageRenderProvider != null) {
            iImageRenderProvider.addTileListener(this.role, this.adapter);
        }
    }

    public void sizeScrollBars() {
        ScrollBar scrollBar = this.getHorizontalBar();
        ScrollBar scrollBar2 = this.getVerticalBar();
        if (scrollBar == null || scrollBar2 == null) {
            return;
        }
        if (!this.hasImage()) {
            scrollBar.setVisible(false);
            scrollBar2.setVisible(false);
            return;
        }
        Dimension dimension = this.largestSize();
        if (GeomUtil.isEmpty(dimension)) {
            return;
        }
        org.eclipse.swt.graphics.Rectangle rectangle = this.getClientArea();
        scrollBar.setVisible(rectangle.width < dimension.width);
        if (!this.ownerSB.isCommonScrollBarVisible()) {
            scrollBar2.setVisible(rectangle.height < dimension.height);
        }
        scrollBar.setIncrement((int)((float)rectangle.width / 100.0f));
        scrollBar.setPageIncrement(rectangle.width);
        scrollBar2.setIncrement((int)((float)rectangle.height / 100.0f));
        scrollBar2.setPageIncrement(rectangle.height);
        scrollBar.setMaximum(dimension.width);
        scrollBar2.setMaximum(dimension.height);
        scrollBar.setThumb(Math.min(dimension.width, rectangle.width));
        scrollBar2.setThumb(Math.min(dimension.height, rectangle.height));
        int n = dimension.width - rectangle.width;
        int n2 = dimension.height - rectangle.height;
        int n3 = scrollBar.getSelection();
        int n4 = scrollBar2.getSelection();
        if (n3 >= n && n <= 0) {
            n3 = 0;
        }
        if (n4 >= n2 && n2 <= 0) {
            n4 = 0;
        }
        this.getImageFacade().moveImage(-n3, -n4);
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " " + this.role;
    }

    private class Adapter
    implements ITileListener,
    PaintListener {
        private Adapter() {
        }

        public void paintControl(PaintEvent paintEvent) {
            ImageCanvasBase.this.paint(paintEvent.gc);
        }

        @Override
        public void processTilesComplete(final ITileList iTileList) {
            final Display display = UIUtil.display();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!display.isDisposed()) {
                        ImageCanvasBase.this.redrawDeferredTiles(iTileList);
                    }
                }
            });
        }

        public String toString() {
            return "Adapter: " + ImageCanvasBase.this.toString();
        }
    }
}

