/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal.ui;

import com.deltawalker.ImageCache;
import com.deltawalker.ImageConst;
import com.deltawalker.image.internal.ui.IImageFacade;
import com.deltawalker.image.internal.ui.ImageCanvasBase;
import com.deltawalker.image.internal.ui.Zoom;
import com.deltawalker.script.Role;
import com.deltopia.ui.swt.IVerticalScrollBarOwner;
import java.awt.Dimension;
import java.awt.Point;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageCanvas
extends ImageCanvasBase {
    private static final Logger LOG = LoggerFactory.getLogger(ImageCanvas.class);
    private Cursor panCursor = null;

    public ImageCanvas(Composite composite, Role role, int n, IVerticalScrollBarOwner iVerticalScrollBarOwner) {
        super(composite, role, n | 0x200 | 0x100 | 0x40000, false, iVerticalScrollBarOwner);
        this.setBackground(this.getDisplay().getSystemColor(9));
        EventHandler eventHandler = new EventHandler();
        this.addMouseListener(eventHandler);
        this.addMouseMoveListener(eventHandler);
        this.addMouseWheelListener(eventHandler);
        this.addKeyListener(eventHandler);
        this.addControlListener(eventHandler);
        this.getHorizontalBar().addSelectionListener((SelectionListener)eventHandler);
        this.getVerticalBar().addSelectionListener((SelectionListener)eventHandler);
    }

    @Override
    public void dispose() {
        if (this.panCursor != null) {
            this.panCursor.dispose();
            this.panCursor = null;
        }
    }

    public boolean isImageFitting() {
        if (!this.hasImage()) {
            return true;
        }
        Dimension dimension = this.imageProvider().displaySize(this.role);
        Rectangle rectangle = this.getClientArea();
        return dimension.width <= rectangle.width && dimension.height <= rectangle.height;
    }

    private class EventHandler
    implements MouseListener,
    MouseMoveListener,
    KeyListener,
    MouseWheelListener,
    ControlListener,
    SelectionListener {
        private static final int MOVE_AMOUNT = 30;
        private static final boolean TRACE = false;
        private Cursor oldCursor = null;
        private Point ptLast = null;

        private EventHandler() {
        }

        public void controlMoved(ControlEvent controlEvent) {
        }

        public void controlResized(ControlEvent controlEvent) {
            IImageFacade iImageFacade = ImageCanvas.this.getImageFacade();
            if (iImageFacade != null) {
                ImageCanvas.this.getImageFacade().canvasSizeChanged();
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            char c = keyEvent.character;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            switch (keyEvent.keyCode) {
                case 0x1000002: {
                    n2 = -30;
                    break;
                }
                case 0x1000001: {
                    n2 = 30;
                    break;
                }
                case 0x1000004: {
                    n = -30;
                    break;
                }
                case 0x1000003: {
                    n = 30;
                }
            }
            if (n != 0 || n2 != 0) {
                keyEvent.doit = false;
                Point point = ImageCanvas.this.getOrigin();
                ImageCanvas.this.getImageFacade().moveImage(point.x + n, point.y + n2);
            } else {
                if (c == '+') {
                    n3 = 1;
                } else if (c == '-') {
                    n3 = -1;
                }
                if (n3 != 0) {
                    keyEvent.doit = false;
                    if (n3 == 1) {
                        ImageCanvas.this.getImageFacade().zoomIn(true);
                    } else {
                        ImageCanvas.this.getImageFacade().zoomIn(false);
                    }
                } else if (c == 'r') {
                    ImageCanvas.this.redraw();
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            if (mouseEvent.button == 1) {
                if ((mouseEvent.stateMask & SWT.MOD1) != 0) {
                    ImageCanvas.this.getImageFacade().zoomTo(Zoom.ACTUAL_SIZE);
                } else {
                    ImageCanvas.this.getImageFacade().moveImage(0, 0);
                }
            }
        }

        public void mouseDown(MouseEvent mouseEvent) {
            ImageCanvas.this.setFocus();
            if (mouseEvent.button == 1 && ImageCanvas.this.hasImage()) {
                this.oldCursor = ImageCanvas.this.getCursor();
                if (ImageCanvas.this.panCursor == null) {
                    Image image = ImageCache.getImage((String)ImageConst.PANNER_CURSOR);
                    ImageData imageData = image.getImageData();
                    ImageCanvas.this.panCursor = new Cursor((Device)ImageCanvas.this.getDisplay(), imageData, 0, 0);
                }
                ImageCanvas.this.setCursor(ImageCanvas.this.panCursor);
                this.ptLast = new Point(mouseEvent.x, mouseEvent.y);
            }
        }

        public void mouseMove(MouseEvent mouseEvent) {
            if (this.ptLast != null) {
                Point point = ImageCanvas.this.getOrigin();
                point.x += mouseEvent.x - this.ptLast.x;
                point.y += mouseEvent.y - this.ptLast.y;
                ImageCanvas.this.getImageFacade().moveImage(point.x, point.y);
                this.ptLast.x = mouseEvent.x;
                this.ptLast.y = mouseEvent.y;
            }
        }

        public void mouseScrolled(MouseEvent mouseEvent) {
            ImageCanvas.this.setFocus();
            if ((mouseEvent.stateMask & SWT.MOD1) != 0) {
                if (mouseEvent.count != 0) {
                    ImageCanvas.this.getImageFacade().zoomIn(mouseEvent.count > 0);
                }
            } else {
                Point point = ImageCanvas.this.getOrigin();
                int n = mouseEvent.count * ImageCanvas.this.ownerSB.verticalScrollBar().getIncrement();
                if ((mouseEvent.stateMask & SWT.MOD2) != 0) {
                    ImageCanvas.this.getImageFacade().moveImage(point.x + n, point.y);
                }
            }
        }

        public void mouseUp(MouseEvent mouseEvent) {
            if (mouseEvent.button == 1) {
                ImageCanvas.this.setCursor(this.oldCursor);
                if (ImageCanvas.this.panCursor != null) {
                    ImageCanvas.this.panCursor.dispose();
                    ImageCanvas.this.panCursor = null;
                }
                this.ptLast = null;
            }
        }

        private void scroll(ScrollBar scrollBar) {
            if (!ImageCanvas.this.hasImage()) {
                return;
            }
            boolean bl = scrollBar == ImageCanvas.this.getHorizontalBar();
            Point point = ImageCanvas.this.getOrigin();
            int n = scrollBar.getSelection();
            if (bl) {
                ImageCanvas.this.getImageFacade().moveImage(-n, point.y);
            } else {
                ImageCanvas.this.getImageFacade().moveImage(point.x, -n);
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.widget instanceof ScrollBar) {
                this.scroll((ScrollBar)selectionEvent.widget);
            }
        }
    }
}

