/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal.ui;

import com.deltawalker.BoldFontCache;
import com.deltawalker.ImageCache;
import com.deltawalker.ImageConst;
import com.deltawalker.PrefKey;
import com.deltawalker.image.internal.Msg;
import com.deltawalker.image.internal.common.operation.ImageDeltaKind;
import com.deltawalker.image.internal.ui.IImageFacade;
import com.deltawalker.image.internal.ui.ImageDiffView;
import com.deltawalker.image.internal.ui.Zoom;
import com.deltawalker.ui.BaseExpandable;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.UIUtil;
import com.deltopia.interfaces.IMvcController;
import com.deltopia.interfaces.IMvcModel;
import com.deltopia.jface.util.DialogUtil;
import com.deltopia.util.OS;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.SegmentedControl;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageActionsExpandable
extends BaseExpandable {
    private static final Logger LOG = LoggerFactory.getLogger((String)ImageActionsExpandable.class.getName());
    private static final int SCALE_HEIGHT = 30;
    private static final int SCALE_WIDTH = 100;
    private static final boolean USE_SEGMENTED_CTL = OS.OSX;
    private Combo cbShow;
    private Combo cbZoom;
    private IImageFacade facade;
    private Zoom oldZoom;
    private final ActionHandler onAction;
    private Scale scaleThreshold;
    private Scale scaleZoom;
    private SegmentedControl scViewPan;
    private SegmentedControl scViewZoom;
    private ToolItem tiViewActual;
    private ToolItem tiViewFit;
    private ToolItem tiViewPan;
    private Text txtThreshold;
    private final ImageDiffView view;

    public ImageActionsExpandable(Composite composite, int n, ImageDiffView imageDiffView) {
        super(composite, n, (DiffView)imageDiffView);
        this.view = imageDiffView;
        this.setMenu(composite.getMenu());
        this.setFont(BoldFontCache.get((Font)this.getFont()));
        this.setText("Actions");
        ((GridLayout)this.client().getLayout()).numColumns = 2;
        this.onAction = new ActionHandler();
        this.createShowSection();
        this.createZoomSection();
    }

    public void connect(IMvcModel iMvcModel, IMvcController iMvcController) {
        this.facade = this.view.imageFacade();
        super.connect(iMvcModel, iMvcController);
        this.populateShowCombo();
    }

    private void createShowCombo(Composite composite) {
        this.cbShow = new Combo(composite, 0x800008, 262144);
        this.cbShow.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.cbShow.addSelectionListener((SelectionListener)this.onAction);
    }

    private void createShowSection() {
        Composite composite = DialogUtil.createSectionComposite((Composite)this.client());
        DialogUtil.createSectionTitle((Composite)composite, (String)"Show", (boolean)false);
        Composite composite2 = new Composite(composite, 0);
        int n = OS.OSX ? 3 : 0;
        composite2.setLayout((Layout)DialogUtil.createGridLayout((int)(this.showSeparators() ? 3 : 2), (int)n, (int)0, (int)2));
        GridData gridData = DialogUtil.createFillGridData();
        composite2.setLayoutData((Object)gridData);
        this.createShowCombo(composite2);
        this.createThresholdComposite(composite2);
        if (this.showSeparators()) {
            BaseExpandable.createCompositeSeparator((Composite)composite2, (int)0);
        }
    }

    private Composite createThresholdComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 5;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(Msg.ImageDashboard_threshold);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.scaleThreshold = new Scale(composite2, 256);
        GridData gridData = new GridData(131072, 4, false, true);
        if (OS.OSX) {
            gridData.heightHint = 30;
        }
        gridData.widthHint = 100;
        this.scaleThreshold.setLayoutData((Object)gridData);
        this.scaleThreshold.setPageIncrement(25);
        this.scaleThreshold.setMinimum(0);
        this.scaleThreshold.setMaximum(255);
        this.scaleThreshold.addSelectionListener((SelectionListener)this.onAction);
        this.txtThreshold = new Text(composite2, 2048);
        this.txtThreshold.setTextLimit(3);
        gridData = new GridData(0x1000000, 0x1000000, false, false);
        gridData.widthHint = 4 * UIUtil.getAverageCharWidth((Drawable)this.txtThreshold);
        this.txtThreshold.setLayoutData((Object)gridData);
        this.txtThreshold.addSelectionListener((SelectionListener)this.onAction);
        this.txtThreshold.addModifyListener(new ModifyListener(){
            private Integer oldVal;
            {
                this.oldVal = ImageActionsExpandable.this.view.getThreshold();
            }

            public void modifyText(ModifyEvent modifyEvent) {
                block5: {
                    String string = ImageActionsExpandable.this.txtThreshold.getText();
                    if (string.isEmpty()) {
                        return;
                    }
                    try {
                        Integer n = Integer.parseInt(string);
                        if (n >= 0 && n <= 255) {
                            this.oldVal = n;
                        } else {
                            ImageActionsExpandable.this.txtThreshold.setText(this.oldVal.toString());
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        ImageActionsExpandable.this.txtThreshold.setText(this.oldVal.toString());
                        if (!LOG.isDebugEnabled()) break block5;
                        LOG.debug("Couldn't convert string: " + string + " to an int", (Throwable)numberFormatException);
                    }
                }
            }
        });
        this.updateThresholdUI();
        return composite2;
    }

    private Composite createZoomComposite(Composite composite) {
        this.scaleZoom = new Scale(composite, 256);
        GridData gridData = new GridData(131072, 0x1000000, false, false);
        gridData.widthHint = 100;
        if (OS.OSX) {
            gridData.heightHint = 30;
        }
        this.scaleZoom.setLayoutData((Object)gridData);
        this.scaleZoom.setPageIncrement(100);
        this.scaleZoom.setMinimum(Zoom.MIN.getScaleAsInt());
        this.scaleZoom.setMaximum(Zoom.MAX.getScaleAsInt());
        this.scaleZoom.addSelectionListener((SelectionListener)this.onAction);
        this.scaleZoom.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                ImageActionsExpandable.this.facade.zoomTo(Zoom.fromPreset(Zoom.Preset.ACTUAL_SIZE));
            }
        });
        this.cbZoom = new Combo(composite, 4);
        String[] stringArray = Zoom.getListPredefinedScaleAsStr();
        this.cbZoom.setItems(stringArray);
        this.cbZoom.setText("");
        GridData gridData2 = new GridData(0x1000000, 0x1000000, false, false);
        if (OS.LINUX) {
            gridData2.widthHint = 100;
        }
        this.cbZoom.setLayoutData((Object)gridData2);
        this.cbZoom.addSelectionListener((SelectionListener)this.onAction);
        if (USE_SEGMENTED_CTL) {
            this.scViewZoom = new SegmentedControl(composite);
            this.scViewZoom.setSegmentStyle(2);
            this.scViewZoom.setSegmentCount(2);
            this.scViewZoom.setImage(ImageCache.getImage((String)ImageConst.IMAGE_FIT_TO_VIEW), 0);
            this.scViewZoom.setImage(ImageCache.getImage((String)ImageConst.IMAGE_ACTUAL_SIZE), 1);
            Listener listener = new Listener(){
                int segment;
                boolean selected;
                {
                    this.segment = ImageActionsExpandable.this.scViewZoom.selectedSegment();
                    this.selected = this.segment != -1 ? ImageActionsExpandable.this.scViewZoom.isSegmentSelected(this.segment) : false;
                }

                public void handleEvent(Event event) {
                    int n = ImageActionsExpandable.this.scViewZoom.selectedSegment();
                    boolean bl = true;
                    switch (event.type) {
                        case 13: {
                            switch (n) {
                                case 0: {
                                    if (this.segment == n) {
                                        bl = !this.selected;
                                        ImageActionsExpandable.this.selectViewModeUI(ViewMode.FIT_TO_VIEW, bl);
                                    }
                                    ImageActionsExpandable.this.onViewMode(ViewMode.FIT_TO_VIEW, bl);
                                    break;
                                }
                                case 1: {
                                    if (this.segment == n) {
                                        bl = !this.selected;
                                        ImageActionsExpandable.this.selectViewModeUI(ViewMode.ACTUAL_SIZE, bl);
                                    }
                                    ImageActionsExpandable.this.onViewMode(ViewMode.ACTUAL_SIZE, bl);
                                    break;
                                }
                                default: {
                                    if (!$assertionsDisabled) {
                                        throw new AssertionError();
                                    }
                                    break;
                                }
                            }
                        }
                        case 3: {
                            this.segment = ImageActionsExpandable.this.scViewZoom.selectedSegment();
                            this.selected = this.segment != -1 ? ImageActionsExpandable.this.scViewZoom.isSegmentSelected(this.segment) : false;
                        }
                    }
                }
            };
            this.scViewZoom.addListener(13, listener);
            this.scViewZoom.addListener(3, listener);
            this.scViewPan = new SegmentedControl(composite);
            this.scViewPan.setSegmentStyle(2);
            this.scViewPan.setSegmentCount(1);
            this.scViewPan.setImage(ImageCache.getImage((String)ImageConst.SHOW_PANNER), 0);
            Listener listener2 = new Listener(){
                int segment;
                boolean selected;
                {
                    this.segment = ImageActionsExpandable.this.scViewPan.selectedSegment();
                    this.selected = this.segment != -1 ? ImageActionsExpandable.this.scViewPan.isSegmentSelected(this.segment) : false;
                }

                public void handleEvent(Event event) {
                    int n = ImageActionsExpandable.this.scViewPan.selectedSegment();
                    boolean bl = true;
                    switch (event.type) {
                        case 13: {
                            switch (n) {
                                case 0: {
                                    if (this.segment == n) {
                                        bl = !this.selected;
                                        ImageActionsExpandable.this.selectViewModeUI(ViewMode.SHOW_PANNER, bl);
                                    }
                                    ImageActionsExpandable.this.onViewMode(ViewMode.SHOW_PANNER, bl);
                                    break;
                                }
                                default: {
                                    if (!$assertionsDisabled) {
                                        throw new AssertionError();
                                    }
                                    break;
                                }
                            }
                        }
                        case 3: {
                            this.segment = ImageActionsExpandable.this.scViewPan.selectedSegment();
                            this.selected = this.segment != -1 ? ImageActionsExpandable.this.scViewPan.isSegmentSelected(this.segment) : false;
                        }
                    }
                }
            };
            this.scViewPan.addListener(13, listener2);
            this.scViewPan.addListener(3, listener2);
        } else {
            ToolBar toolBar = new ToolBar(composite, 0x800000);
            this.tiViewFit = new ToolItem(toolBar, 32);
            this.tiViewFit.setImage(ImageCache.getImage((String)ImageConst.IMAGE_FIT_TO_VIEW));
            this.tiViewFit.setToolTipText(Msg.ImageDashboard_fitImage);
            this.tiViewFit.addSelectionListener((SelectionListener)this.onAction);
            this.tiViewActual = new ToolItem(toolBar, 32);
            this.tiViewActual.setImage(ImageCache.getImage((String)ImageConst.IMAGE_ACTUAL_SIZE));
            this.tiViewActual.setToolTipText(Msg.ImageDashboard_actualSize);
            this.tiViewActual.addSelectionListener((SelectionListener)this.onAction);
            this.tiViewPan = new ToolItem(toolBar, 32);
            this.tiViewPan.setImage(ImageCache.getImage((String)ImageConst.SHOW_PANNER));
            this.tiViewPan.setToolTipText(Msg.ImageDashboard_showPanner);
            this.tiViewPan.addSelectionListener((SelectionListener)this.onAction);
            this.tiViewPan.setSelection(true);
        }
        return composite;
    }

    private void createZoomSection() {
        Composite composite = DialogUtil.createSectionComposite((Composite)this.client());
        DialogUtil.createSectionTitle((Composite)composite, (String)"Zoom", (boolean)false);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = DialogUtil.createGridLayout((int)4, (int)0, (int)0, (int)2);
        gridLayout.horizontalSpacing = 5;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)DialogUtil.createFillGridData());
        this.createZoomComposite(composite2);
    }

    private void enableThresholdControls() {
        String string = this.cbShow.getText();
        ImageDeltaKind imageDeltaKind = ImageDeltaKind.fromDisplayName(string);
        this.enableThresholdControls(imageDeltaKind == ImageDeltaKind.CHANGED);
    }

    private void enableThresholdControls(boolean bl) {
        this.scaleThreshold.setEnabled(bl);
        this.txtThreshold.setEnabled(bl);
    }

    protected String expandPrefKey() {
        return PrefKey.I_EXPAND_ACTIONS.toString();
    }

    private void onViewMode(ViewMode viewMode, boolean bl) {
        switch (viewMode) {
            case FIT_TO_VIEW: {
                if (bl) {
                    Object object = this.scaleZoom.getData();
                    this.oldZoom = object instanceof Zoom ? (Zoom)object : null;
                    this.facade.zoomTo(Zoom.FIT_IMAGE);
                    this.selectViewModeUI(ViewMode.ACTUAL_SIZE, false);
                    break;
                }
                if (this.oldZoom == null) break;
                this.facade.zoomTo(this.oldZoom);
                break;
            }
            case ACTUAL_SIZE: {
                if (bl) {
                    Object object = this.scaleZoom.getData();
                    this.oldZoom = object instanceof Zoom ? (Zoom)object : null;
                    this.facade.zoomTo(Zoom.ACTUAL_SIZE);
                    this.selectViewModeUI(ViewMode.FIT_TO_VIEW, false);
                    break;
                }
                this.selectViewModeUI(ViewMode.FIT_TO_VIEW, true);
                if (this.oldZoom == null) break;
                this.facade.zoomTo(this.oldZoom);
                break;
            }
            case SHOW_PANNER: {
                IPreferenceStore iPreferenceStore = this.view.getInput().preferences();
                iPreferenceStore.setValue(PrefKey.I_SHOW_PANNER.toString(), String.valueOf(bl));
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void populateShowCombo() {
        ImageDeltaKind imageDeltaKind2;
        this.cbShow.removeAll();
        Set<ImageDeltaKind> set = ImageDeltaKind.types(this.view.isThreeWay());
        for (ImageDeltaKind imageDeltaKind2 : set) {
            this.cbShow.add(imageDeltaKind2.toDisplayName());
        }
        imageDeltaKind2 = this.view.getInput().preferences();
        int n = imageDeltaKind2.getInt(PrefKey.I_SHOW_COMBO_SEL.toString());
        this.cbShow.select(n);
        this.showComboChanged();
        this.enableThresholdControls();
    }

    public void selectPannerUI(boolean bl) {
        this.selectViewModeUI(ViewMode.SHOW_PANNER, bl);
    }

    private void selectViewModeUI(ViewMode viewMode, boolean bl) {
        block12: {
            block11: {
                if (!USE_SEGMENTED_CTL) break block11;
                switch (viewMode) {
                    case ACTUAL_SIZE: 
                    case FIT_TO_VIEW: {
                        this.scViewZoom.setSelected(viewMode.segment(), bl);
                        break block12;
                    }
                    case SHOW_PANNER: {
                        this.scViewPan.setSelected(viewMode.segment(), bl);
                        break block12;
                    }
                    default: {
                        assert (false);
                        break block12;
                    }
                }
            }
            switch (viewMode) {
                case ACTUAL_SIZE: {
                    this.tiViewActual.setSelection(bl);
                    break;
                }
                case FIT_TO_VIEW: {
                    this.tiViewFit.setSelection(bl);
                    break;
                }
                case SHOW_PANNER: {
                    this.tiViewPan.setSelection(bl);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    private void showComboChanged() {
        String string = this.cbShow.getText();
        ImageDeltaKind imageDeltaKind = ImageDeltaKind.fromDisplayName(string);
        this.facade.showPixelsOfKind(imageDeltaKind);
        this.enableThresholdControls(imageDeltaKind == ImageDeltaKind.CHANGED || imageDeltaKind == ImageDeltaKind.CHANGED);
    }

    public void updateThresholdUI() {
        Integer n = this.view.getThreshold();
        this.scaleThreshold.setSelection(n.intValue());
        this.txtThreshold.setText(n.toString());
    }

    public void updateZoomUI(Zoom zoom, Zoom zoom2) {
        if (zoom2 != null) {
            if (!zoom2.hasScale()) {
                throw new IllegalArgumentException("Invalid zoom factor " + zoom2);
            }
            this.cbZoom.setText(zoom2.displayName());
            this.scaleZoom.setSelection(zoom2.getScaleAsInt());
            this.scaleZoom.setData((Object)zoom2);
        }
        if (zoom != null) {
            this.selectViewModeUI(ViewMode.FIT_TO_VIEW, zoom.equals(Zoom.FIT_IMAGE));
            this.selectViewModeUI(ViewMode.ACTUAL_SIZE, zoom.equals(Zoom.ACTUAL_SIZE));
        }
    }

    private class ActionHandler
    extends MouseAdapter
    implements SelectionListener {
        private final boolean[] skipEvent = new boolean[1];
        private final int TIMEOUT = 300;

        private ActionHandler() {
        }

        private void thresholdScaleChanged() {
            Integer n = ImageActionsExpandable.this.scaleThreshold.getSelection();
            ImageActionsExpandable.this.txtThreshold.setText(n.toString());
            ImageActionsExpandable.this.facade.setThreshold(n);
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            block5: {
                if (selectionEvent.widget == ImageActionsExpandable.this.txtThreshold) {
                    String string = ImageActionsExpandable.this.txtThreshold.getText();
                    try {
                        int n = Integer.parseInt(string);
                        assert (n >= 0 && n <= 255);
                        ImageActionsExpandable.this.scaleThreshold.setSelection(n);
                        ImageActionsExpandable.this.facade.setThreshold(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if ($assertionsDisabled) break block5;
                        throw new AssertionError();
                    }
                }
            }
            if (selectionEvent.widget == ImageActionsExpandable.this.cbZoom) {
                this.zoomComboChanged();
            }
        }

        public void widgetSelected(final SelectionEvent selectionEvent) {
            if (selectionEvent.widget == ImageActionsExpandable.this.tiViewFit) {
                boolean bl = ImageActionsExpandable.this.tiViewFit.getSelection();
                ImageActionsExpandable.this.onViewMode(ViewMode.FIT_TO_VIEW, bl);
            } else if (selectionEvent.widget == ImageActionsExpandable.this.tiViewActual) {
                boolean bl = ImageActionsExpandable.this.tiViewActual.getSelection();
                ImageActionsExpandable.this.onViewMode(ViewMode.ACTUAL_SIZE, bl);
            } else if (selectionEvent.widget == ImageActionsExpandable.this.tiViewPan) {
                boolean bl = ImageActionsExpandable.this.tiViewPan.getSelection();
                IPreferenceStore iPreferenceStore = ImageActionsExpandable.this.view.getInput().preferences();
                iPreferenceStore.setValue(PrefKey.I_SHOW_PANNER.toString(), String.valueOf(bl));
            } else if (selectionEvent.widget == ImageActionsExpandable.this.scaleZoom || selectionEvent.widget == ImageActionsExpandable.this.scaleThreshold) {
                ImageActionsExpandable imageActionsExpandable = ImageActionsExpandable.this;
                if (this.skipEvent[0]) {
                    return;
                }
                this.skipEvent[0] = true;
                imageActionsExpandable.getDisplay().timerExec(300, new Runnable(){

                    @Override
                    public void run() {
                        if (selectionEvent.widget == ImageActionsExpandable.this.scaleThreshold) {
                            ActionHandler.this.thresholdScaleChanged();
                        } else {
                            ActionHandler.this.zoomScaleChanged();
                        }
                        ((ActionHandler)ActionHandler.this).skipEvent[0] = false;
                    }
                });
            } else if (selectionEvent.widget == ImageActionsExpandable.this.cbZoom) {
                this.zoomComboChanged();
            } else if (selectionEvent.widget == ImageActionsExpandable.this.cbShow) {
                Integer n = ImageActionsExpandable.this.cbShow.getSelectionIndex();
                IPreferenceStore iPreferenceStore = ImageActionsExpandable.this.view.getInput().preferences();
                iPreferenceStore.putValue(PrefKey.I_SHOW_COMBO_SEL.toString(), n.toString());
                ImageActionsExpandable.this.showComboChanged();
            }
        }

        private void zoomComboChanged() {
            String string = ImageActionsExpandable.this.cbZoom.getText();
            try {
                Zoom zoom = Zoom.fromString(string);
                int n = zoom.getScaleAsInt();
                if (n >= 1600) {
                    zoom = Zoom.MAX;
                    ImageActionsExpandable.this.cbZoom.setText(Zoom.MAX.displayName());
                } else if (n <= 0) {
                    zoom = Zoom.MIN;
                    ImageActionsExpandable.this.cbZoom.setText(Zoom.MIN.displayName());
                }
                ImageActionsExpandable.this.facade.zoomTo(zoom);
            }
            catch (Throwable throwable) {
                if (ImageActionsExpandable.this.oldZoom != null) {
                    ImageActionsExpandable.this.cbZoom.setText(Integer.toString(ImageActionsExpandable.this.oldZoom.getScaleAsInt()));
                }
                ImageActionsExpandable.this.cbZoom.setText(Zoom.MIN.displayName());
            }
        }

        private void zoomScaleChanged() {
            int n = ImageActionsExpandable.this.scaleZoom.getSelection();
            Zoom zoom = Zoom.zoomFromInt(n);
            ImageActionsExpandable.this.facade.zoomTo(zoom);
        }
    }

    static enum ViewMode {
        ACTUAL_SIZE(1),
        FIT_TO_VIEW(0),
        SHOW_PANNER(0);

        private final int segment;

        private ViewMode(int n2) {
            this.segment = n2;
        }

        public int segment() {
            return this.segment;
        }
    }
}

