/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal.common.operation;

import com.deltawalker.image.internal.Msg;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public enum ImageDeltaKind {
    ALL(Msg.ImageDeltaKind_all),
    CONFLICT(Msg.ImageDeltaKind_conflict),
    CHANGED(Msg.ImageDeltaKind_changed),
    SAME(Msg.ImageDeltaKind_same);

    private static final Set<ImageDeltaKind> THREE_WAY_TYPES;
    private static final Set<ImageDeltaKind> TWO_WAY_TYPES;
    private final String name;

    static {
        LinkedHashSet<ImageDeltaKind> linkedHashSet = new LinkedHashSet<ImageDeltaKind>(4);
        linkedHashSet.add(ALL);
        linkedHashSet.add(CHANGED);
        linkedHashSet.add(CONFLICT);
        linkedHashSet.add(SAME);
        THREE_WAY_TYPES = Collections.unmodifiableSet(linkedHashSet);
        linkedHashSet = new LinkedHashSet(linkedHashSet);
        linkedHashSet.remove((Object)CONFLICT);
        TWO_WAY_TYPES = Collections.unmodifiableSet(linkedHashSet);
    }

    public static ImageDeltaKind fromDisplayName(String string) throws IllegalArgumentException {
        ImageDeltaKind[] imageDeltaKindArray;
        ImageDeltaKind[] imageDeltaKindArray2 = imageDeltaKindArray = ImageDeltaKind.values();
        int n = imageDeltaKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImageDeltaKind imageDeltaKind = imageDeltaKindArray2[n2];
            if (imageDeltaKind.name.equals(string)) {
                return imageDeltaKind;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unknown difference type: " + string);
    }

    public static Set<ImageDeltaKind> types(boolean bl) {
        return bl ? THREE_WAY_TYPES : TWO_WAY_TYPES;
    }

    private ImageDeltaKind(String string2) {
        this.name = string2;
    }

    public String toDisplayName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

