/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal.common.operation;

import com.deltawalker.image.internal.common.operation.ImageDeltaKind;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;

final class CompareOpImage
extends PointOpImage {
    private static int CHECKERED_SQUARE_SIZE = 10;
    private static final boolean USE_ALPHA_SRC = false;
    private boolean drawCB;
    private int dstBandCount;
    private boolean firstSrcAncestor;
    private final ImageDeltaKind kind;
    private double lightFactor;
    private boolean src1HasAlpha;
    private int srcCount;
    private int threshold;

    public CompareOpImage(Builder builder) {
        super(builder.vector, builder.layout, (Map)builder.renderHints, true);
        this.srcCount = builder.vector.capacity();
        this.drawCB = builder.drawCB;
        this.kind = builder.kind;
        this.lightFactor = builder.lightFactor;
        this.drawCB = builder.drawCB;
        this.threshold = builder.threshold;
        this.firstSrcAncestor = builder.firstSrcAncestor;
        this.src1HasAlpha = this.getSourceImage(0).getColorModel().hasAlpha();
        RenderedImage renderedImage = (RenderedImage)builder.vector.get(0);
        this.minX = renderedImage.getMinX();
        this.minY = renderedImage.getMinY();
        this.width = renderedImage.getWidth();
        this.height = renderedImage.getHeight();
        this.tileWidth = renderedImage.getTileWidth();
        this.tileHeight = renderedImage.getTileHeight();
        SampleModel sampleModel = renderedImage.getSampleModel();
        ColorModel colorModel = renderedImage.getColorModel();
        int n = sampleModel.getTransferType();
        if (this.kind == null) {
            throw new NullPointerException("kind");
        }
        this.dstBandCount = colorModel instanceof IndexColorModel ? colorModel.getNumComponents() : sampleModel.getNumBands();
        if (!this.drawCB) {
            if (!colorModel.hasAlpha()) {
                ++this.dstBandCount;
            }
        } else {
            this.colorModel = colorModel;
            this.sampleModel = sampleModel;
        }
        if (!(this.drawCB || this.sampleModel.getTransferType() == n && this.sampleModel.getNumBands() == this.dstBandCount)) {
            this.sampleModel = RasterFactory.createComponentSampleModel(this.sampleModel, n, this.tileWidth, this.tileHeight, this.dstBandCount);
            if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
                this.colorModel = ImageUtil.getCompatibleColorModel(this.sampleModel, builder.renderHints);
            }
        }
    }

    private int checkeredPixel(int n, int n2) {
        return n / CHECKERED_SQUARE_SIZE % 2 == n2 / CHECKERED_SQUARE_SIZE % 2 ? Color.WHITE.getRed() : Color.LIGHT_GRAY.getRed();
    }

    private void compareIntersectThreeWay(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, int[] nArray, int n) {
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        byte[][] byArray2 = rasterAccessor4.getByteDataArrays();
        int[] nArray3 = rasterAccessor4.getBandOffsets();
        DiffsThreeWay diffsThreeWay = this.findDiffsThreeWay(rasterAccessor, rasterAccessor2, rasterAccessor3, nArray);
        if (diffsThreeWay.shouldShowPixelThreeWay()) {
            int n2 = 0;
            while (n2 < this.dstBandCount) {
                if (this.isLastBand(n2)) {
                    byArray2[n2][n + nArray3[n2]] = -1;
                } else {
                    int n3 = (2 - n2) * 8;
                    int n4 = diffsThreeWay.absDiff1 >> n3 & 0xFF;
                    int n5 = diffsThreeWay.absDiff3 >> n3 & 0xFF;
                    int n6 = byArray[n2][nArray[0] + nArray2[n2]] & 0xFF;
                    n6 = (int)((double)n6 + (double)(n4 + n5) * this.lightFactor);
                    byArray2[n2][n + nArray3[n2]] = ImageUtil.clampByte(n6);
                }
                ++n2;
            }
        } else {
            int n7 = 0;
            while (n7 < this.dstBandCount) {
                byArray2[n7][n + nArray3[n7]] = 0;
                ++n7;
            }
        }
    }

    private void compareIntersectThreeWayDrawCB(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, int[] nArray, int n, Point point) {
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        byte[][] byArray2 = rasterAccessor4.getByteDataArrays();
        int[] nArray3 = rasterAccessor4.getBandOffsets();
        DiffsThreeWay diffsThreeWay = this.findDiffsThreeWay(rasterAccessor, rasterAccessor2, rasterAccessor3, nArray);
        if (diffsThreeWay.shouldShowPixelThreeWay()) {
            int n2 = 0;
            while (n2 < this.dstBandCount) {
                if (this.src1HasAlpha && this.isLastBand(n2)) {
                    byArray2[n2][n + nArray3[n2]] = byArray[n2][nArray[0] + nArray2[n2]];
                } else {
                    int n3 = (2 - n2) * 8;
                    int n4 = diffsThreeWay.absDiff1() >> n3 & 0xFF;
                    int n5 = diffsThreeWay.absDiff3() >> n3 & 0xFF;
                    int n6 = byArray[n2][nArray[0] + nArray2[n2]] & 0xFF;
                    n6 = (int)((double)n6 + (double)(n4 + n5) * this.lightFactor);
                    byArray2[n2][n + nArray3[n2]] = ImageUtil.clampByte(n6);
                }
                ++n2;
            }
        } else {
            int n7 = 0;
            while (n7 < this.dstBandCount) {
                byArray2[n7][n + nArray3[n7]] = this.src1HasAlpha && this.isLastBand(n7) ? -1 : (byte)(this.checkeredPixel(point.x, point.y) & 0xFF);
                ++n7;
            }
        }
    }

    private void compareIntersectTwoWay(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, int[] nArray, int n) {
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        byte[][] byArray2 = rasterAccessor3.getByteDataArrays();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        DiffsTwoWay diffsTwoWay = this.findDiffsTwoWay(rasterAccessor, rasterAccessor2, nArray);
        if (diffsTwoWay.shouldShowPixelTwoWay()) {
            int n2 = 0;
            while (n2 < this.dstBandCount) {
                if (this.isLastBand(n2)) {
                    byArray2[n2][n + nArray3[n2]] = -1;
                } else {
                    int n3 = (this.dstBandCount - 2 - n2) * 8;
                    int n4 = diffsTwoWay.absDiff() >> n3 & 0xFF;
                    int n5 = byArray[n2][nArray[0] + nArray2[n2]] & 0xFF;
                    n5 = (int)((double)n5 + (double)n4 * this.lightFactor);
                    byArray2[n2][n + nArray3[n2]] = ImageUtil.clampByte(n5);
                }
                ++n2;
            }
        } else {
            int n6 = 0;
            while (n6 < this.dstBandCount) {
                byArray2[n6][n + nArray3[n6]] = 0;
                ++n6;
            }
        }
    }

    private void compareIntersectTwoWayDrawCB(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, int[] nArray, int n, Point point) {
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        byte[][] byArray2 = rasterAccessor3.getByteDataArrays();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        DiffsTwoWay diffsTwoWay = this.findDiffsTwoWay(rasterAccessor, rasterAccessor2, nArray);
        if (diffsTwoWay.shouldShowPixelTwoWay()) {
            int n2 = 0;
            while (n2 < this.dstBandCount) {
                if (this.src1HasAlpha && this.isLastBand(n2)) {
                    byArray2[n2][n + nArray3[n2]] = byArray[n2][nArray[0] + nArray2[n2]];
                } else {
                    int n3 = (2 - n2) * 8;
                    int n4 = diffsTwoWay.absDiff() >> n3 & 0xFF;
                    int n5 = byArray[n2][nArray[0] + nArray2[n2]] & 0xFF;
                    n5 = (int)((double)n5 + (double)n4 * this.lightFactor);
                    byArray2[n2][n + nArray3[n2]] = ImageUtil.clampByte(n5);
                }
                ++n2;
            }
        } else {
            int n6 = 0;
            while (n6 < this.dstBandCount) {
                byArray2[n6][n + nArray3[n6]] = this.src1HasAlpha && this.isLastBand(n6) ? -1 : (byte)(this.checkeredPixel(point.x, point.y) & 0xFF);
                ++n6;
            }
        }
    }

    private void compareThreeWay(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, Rectangle rectangle, Rectangle rectangle2) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n3 = 0;
        int n4 = 0;
        if (rasterAccessor2 != null) {
            n3 = rasterAccessor2.getScanlineStride();
            n4 = rasterAccessor2.getPixelStride();
        }
        int n5 = 0;
        int n6 = 0;
        if (rasterAccessor3 != null) {
            n5 = rasterAccessor3.getScanlineStride();
            n6 = rasterAccessor3.getPixelStride();
        }
        int n7 = rasterAccessor4.getScanlineStride();
        int n8 = rasterAccessor4.getPixelStride();
        int[] nArray2 = rasterAccessor4.getBandOffsets();
        byte[][] byArray2 = rasterAccessor4.getByteDataArrays();
        int n9 = rectangle.width;
        int n10 = rectangle.height;
        int n11 = rectangle2.width;
        int n12 = rectangle2.height;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int[] nArray3 = new int[this.srcCount];
        int n17 = 0;
        while (n17 < n10) {
            nArray3[0] = n13;
            n13 += n;
            nArray3[1] = n14;
            n14 += n3;
            nArray3[2] = n15;
            n15 += n5;
            int n18 = n16;
            n16 += n7;
            int n19 = 0;
            while (n19 < n9) {
                int n20;
                if (n17 < n12 && n19 < n11) {
                    this.compareIntersectThreeWay(rasterAccessor, rasterAccessor2, rasterAccessor3, rasterAccessor4, nArray3, n18);
                } else if (this.kind != ImageDeltaKind.SAME) {
                    n20 = 0;
                    while (n20 < this.dstBandCount) {
                        byArray2[n20][n18 + nArray2[n20]] = this.isLastBand(n20) ? (this.src1HasAlpha ? byArray[n20][nArray3[0] + nArray[n20]] : -1) : byArray[n20][nArray3[0] + nArray[n20]];
                        ++n20;
                    }
                } else {
                    n20 = 0;
                    while (n20 < this.dstBandCount) {
                        int n21 = n18 + nArray2[n20];
                        byArray2[n20][n21] = 0;
                        ++n20;
                    }
                }
                nArray3[0] = nArray3[0] + n2;
                nArray3[1] = nArray3[1] + n4;
                nArray3[2] = nArray3[2] + n6;
                n18 += n8;
                ++n19;
            }
            ++n17;
        }
    }

    private void compareThreeWayDrawCB(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, Rectangle rectangle, Rectangle rectangle2) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n3 = 0;
        int n4 = 0;
        if (rasterAccessor2 != null) {
            n3 = rasterAccessor2.getScanlineStride();
            n4 = rasterAccessor2.getPixelStride();
        }
        int n5 = 0;
        int n6 = 0;
        if (rasterAccessor3 != null) {
            n5 = rasterAccessor3.getScanlineStride();
            n6 = rasterAccessor3.getPixelStride();
        }
        int n7 = rectangle.x;
        int n8 = rectangle.y;
        int n9 = rasterAccessor4.getScanlineStride();
        int n10 = rasterAccessor4.getPixelStride();
        int[] nArray2 = rasterAccessor4.getBandOffsets();
        byte[][] byArray2 = rasterAccessor4.getByteDataArrays();
        int n11 = rectangle.width;
        int n12 = rectangle.height;
        int n13 = rectangle2.width;
        int n14 = rectangle2.height;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int[] nArray3 = new int[this.srcCount];
        int n19 = 0;
        while (n19 < n12) {
            nArray3[0] = n15;
            n15 += n;
            nArray3[1] = n16;
            n16 += n3;
            nArray3[2] = n17;
            n17 += n5;
            int n20 = n18;
            n18 += n9;
            int n21 = 0;
            while (n21 < n11) {
                if (n19 < n14 && n21 < n13) {
                    Point point = new Point(n7 + n21, n8 + n19);
                    this.compareIntersectThreeWayDrawCB(rasterAccessor, rasterAccessor2, rasterAccessor3, rasterAccessor4, nArray3, n20, point);
                } else if (this.kind != ImageDeltaKind.SAME) {
                    int n22 = 0;
                    while (n22 < this.dstBandCount) {
                        byArray2[n22][n20 + nArray2[n22]] = byArray[n22][nArray3[0] + nArray[n22]];
                        ++n22;
                    }
                } else {
                    int n23 = 0;
                    while (n23 < this.dstBandCount) {
                        int n24 = n20 + nArray2[n23];
                        byArray2[n23][n24] = 0;
                        ++n23;
                    }
                }
                nArray3[0] = nArray3[0] + n2;
                nArray3[1] = nArray3[1] + n4;
                nArray3[2] = nArray3[2] + n6;
                n20 += n10;
                ++n21;
            }
            ++n19;
        }
    }

    private void compareTwoWay(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, Rectangle rectangle, Rectangle rectangle2) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n3 = 0;
        int n4 = 0;
        if (rasterAccessor2 != null) {
            n3 = rasterAccessor2.getScanlineStride();
            n4 = rasterAccessor2.getPixelStride();
        }
        int n5 = rasterAccessor3.getScanlineStride();
        int n6 = rasterAccessor3.getPixelStride();
        int[] nArray2 = rasterAccessor3.getBandOffsets();
        byte[][] byArray2 = rasterAccessor3.getByteDataArrays();
        int n7 = rectangle.width;
        int n8 = rectangle.height;
        int n9 = rectangle2.width;
        int n10 = rectangle2.height;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int[] nArray3 = new int[this.srcCount];
        int n14 = 0;
        while (n14 < n8) {
            nArray3[0] = n11;
            n11 += n;
            nArray3[1] = n12;
            n12 += n3;
            int n15 = n13;
            n13 += n5;
            int n16 = 0;
            while (n16 < n7) {
                int n17;
                if (n14 < n10 && n16 < n9) {
                    this.compareIntersectTwoWay(rasterAccessor, rasterAccessor2, rasterAccessor3, nArray3, n15);
                } else if (this.kind != ImageDeltaKind.SAME) {
                    n17 = 0;
                    while (n17 < this.dstBandCount) {
                        byArray2[n17][n15 + nArray2[n17]] = this.isLastBand(n17) ? (this.src1HasAlpha ? byArray[n17][nArray3[0] + nArray[n17]] : -1) : byArray[n17][nArray3[0] + nArray[n17]];
                        ++n17;
                    }
                } else {
                    n17 = 0;
                    while (n17 < this.dstBandCount) {
                        int n18 = n15 + nArray2[n17];
                        byArray2[n17][n18] = 0;
                        ++n17;
                    }
                }
                nArray3[0] = nArray3[0] + n2;
                nArray3[1] = nArray3[1] + n4;
                n15 += n6;
                ++n16;
            }
            ++n14;
        }
    }

    private void compareTwoWayDrawCB(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, Rectangle rectangle, Rectangle rectangle2) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n3 = 0;
        int n4 = 0;
        if (rasterAccessor2 != null) {
            n3 = rasterAccessor2.getScanlineStride();
            n4 = rasterAccessor2.getPixelStride();
        }
        int n5 = rectangle.x;
        int n6 = rectangle.y;
        int n7 = rasterAccessor3.getScanlineStride();
        int n8 = rasterAccessor3.getPixelStride();
        int[] nArray2 = rasterAccessor3.getBandOffsets();
        byte[][] byArray2 = rasterAccessor3.getByteDataArrays();
        int n9 = rectangle.width;
        int n10 = rectangle.height;
        int n11 = rectangle2.width;
        int n12 = rectangle2.height;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int[] nArray3 = new int[this.srcCount];
        int n16 = 0;
        while (n16 < n10) {
            nArray3[0] = n13;
            n13 += n;
            nArray3[1] = n14;
            n14 += n3;
            int n17 = n15;
            n15 += n7;
            int n18 = 0;
            while (n18 < n9) {
                if (n16 < n12 && n18 < n11) {
                    Point point = new Point(n5 + n18, n6 + n16);
                    this.compareIntersectTwoWayDrawCB(rasterAccessor, rasterAccessor2, rasterAccessor3, nArray3, n17, point);
                } else if (this.kind != ImageDeltaKind.SAME) {
                    int n19 = 0;
                    while (n19 < this.dstBandCount) {
                        byArray2[n19][n17 + nArray2[n19]] = byArray[n19][nArray3[0] + nArray[n19]];
                        ++n19;
                    }
                } else {
                    int n20 = 0;
                    while (n20 < this.dstBandCount) {
                        int n21 = n17 + nArray2[n20];
                        byArray2[n20][n21] = 0;
                        ++n20;
                    }
                }
                nArray3[0] = nArray3[0] + n2;
                nArray3[1] = nArray3[1] + n4;
                n17 += n8;
                ++n18;
            }
            ++n16;
        }
    }

    @Override
    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Rectangle rectangle2 = rasterArray[0].getBounds();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = null;
        RasterAccessor rasterAccessor3 = null;
        if (!rectangle.isEmpty()) {
            rasterAccessor2 = new RasterAccessor(rasterArray[1], rectangle, rasterFormatTagArray[1], this.getSourceImage(1).getColorModel());
            if (this.srcCount == 3) {
                rasterAccessor3 = new RasterAccessor(rasterArray[2], rectangle, rasterFormatTagArray[2], this.getSourceImage(2).getColorModel());
            }
        }
        RasterAccessor rasterAccessor4 = new RasterAccessor(writableRaster, rectangle2, rasterFormatTagArray[this.srcCount], this.getColorModel());
        if (this.srcCount == 3) {
            if (this.drawCB) {
                this.compareThreeWayDrawCB(rasterAccessor, rasterAccessor2, rasterAccessor3, rasterAccessor4, rectangle2, rectangle);
            } else {
                this.compareThreeWay(rasterAccessor, rasterAccessor2, rasterAccessor3, rasterAccessor4, rectangle2, rectangle);
            }
        } else if (this.drawCB) {
            this.compareTwoWayDrawCB(rasterAccessor, rasterAccessor2, rasterAccessor4, rectangle2, rectangle);
        } else {
            this.compareTwoWay(rasterAccessor, rasterAccessor2, rasterAccessor4, rectangle2, rectangle);
        }
    }

    @Override
    public Raster computeTile(int n, int n2) {
        WritableRaster writableRaster = this.createTile(n, n2);
        Rectangle rectangle = writableRaster.getBounds().intersection(this.getBounds());
        PlanarImage planarImage = this.getSourceImage(0);
        PlanarImage planarImage2 = this.getSourceImage(1);
        Rectangle rectangle2 = planarImage2.getBounds();
        PlanarImage planarImage3 = null;
        Rectangle rectangle3 = new Rectangle(0, 0, 0, 0);
        if (this.srcCount == 3) {
            planarImage3 = this.getSourceImage(2);
            rectangle3 = planarImage3.getBounds();
        }
        Raster[] rasterArray = new Raster[this.srcCount];
        Rectangle rectangle4 = new Rectangle(0, 0, 0, 0);
        rasterArray[0] = planarImage.getData(rectangle);
        if (this.srcCount == 2) {
            if (rectangle.intersects(rectangle2)) {
                rectangle4 = rectangle.intersection(rectangle2);
                rasterArray[1] = planarImage2.getData(rectangle4);
            }
        } else if (rectangle.intersects(rectangle2) && rectangle.intersects(rectangle3) && rectangle2.intersects(rectangle3)) {
            rectangle4 = rectangle.intersection(rectangle2).intersection(rectangle3);
            rasterArray[1] = planarImage2.getData(rectangle4);
            rasterArray[2] = planarImage3.getData(rectangle4);
        }
        this.computeRect(rasterArray, writableRaster, rectangle4);
        if (planarImage.overlapsMultipleTiles(rectangle4)) {
            this.recycleTile(rasterArray[0]);
        }
        if (planarImage2.overlapsMultipleTiles(rectangle4)) {
            this.recycleTile(rasterArray[1]);
        }
        if (this.srcCount == 3 && planarImage3.overlapsMultipleTiles(rectangle4)) {
            this.recycleTile(rasterArray[2]);
        }
        return writableRaster;
    }

    private DiffsThreeWay findDiffsThreeWay(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, int[] nArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int[] nArray4 = rasterAccessor3.getBandOffsets();
        if ((nArray2.length != nArray3.length || nArray2.length != nArray4.length) && (n = nArray2.length + nArray3.length + nArray4.length) != 10 && n != 11) {
            throw new IllegalArgumentException("Images with different bands: " + nArray2.length + ", " + nArray3.length + ", " + nArray4.length);
        }
        if (nArray2.length != nArray3.length && nArray2.length + nArray3.length != 7) {
            throw new IllegalArgumentException("Images with different bands: " + nArray2.length + ", " + nArray3.length);
        }
        n = Math.min(Math.min(nArray2.length, nArray3.length), nArray4.length);
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
        byte[][] byArray3 = rasterAccessor3.getByteDataArrays();
        int n4 = 0;
        while (n4 < n) {
            int n5 = (2 - n4) * 8;
            int n6 = Math.abs((byArray[n4][nArray[0] + nArray2[n4]] & 0xFF) - (byArray2[n4][nArray[1] + nArray3[n4]] & 0xFF));
            int n7 = Math.abs((byArray2[n4][nArray[1] + nArray3[n4]] & 0xFF) - (byArray3[n4][nArray[2] + nArray4[n4]] & 0xFF));
            int n8 = Math.abs((byArray[n4][nArray[0] + nArray2[n4]] & 0xFF) - (byArray3[n4][nArray[2] + nArray4[n4]] & 0xFF));
            n2 += n6 << n5;
            n3 += n8 << n5;
            if (n6 > this.threshold || bl) {
                bl = true;
            }
            if (n7 > this.threshold || bl2) {
                bl2 = true;
            }
            if (n8 > this.threshold || bl3) {
                bl3 = true;
            }
            ++n4;
        }
        return new DiffsThreeWay(this.shouldShowPixelThreeWay(bl, bl2, bl3), n2, n3);
    }

    private DiffsTwoWay findDiffsTwoWay(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, int[] nArray) {
        int[] nArray2;
        int[] nArray3 = rasterAccessor.getBandOffsets();
        if (nArray3.length != (nArray2 = rasterAccessor2.getBandOffsets()).length && nArray3.length + nArray2.length != 7) {
            throw new IllegalArgumentException("Images with different bands: " + nArray3.length + ", " + nArray2.length);
        }
        int n = Math.min(nArray3.length, nArray2.length);
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = (2 - n3) * 8;
            byte by = byArray[n3][nArray[0] + nArray3[n3]];
            byte by2 = byArray2[n3][nArray[1] + nArray2[n3]];
            int n5 = Math.abs((by & 0xFF) - (by2 & 0xFF));
            n2 += n5 << n4;
            if (n5 > this.threshold || bl) {
                bl = true;
            }
            ++n3;
        }
        return new DiffsTwoWay(this.shouldShowPixelTwoWay(bl), n2);
    }

    private boolean isLastBand(int n) {
        return n == this.dstBandCount - 1;
    }

    private boolean shouldShowPixelThreeWay(boolean bl, boolean bl2, boolean bl3) {
        switch (this.kind) {
            case ALL: {
                return true;
            }
            case CHANGED: {
                return this.firstSrcAncestor ? !bl && bl3 || bl && !bl3 || !bl2 && bl3 : bl && !bl2 || bl && !bl3;
            }
            case CONFLICT: {
                return bl && bl2 && bl3;
            }
            case SAME: {
                return this.firstSrcAncestor ? !bl || !bl3 : !bl;
            }
        }
        return true;
    }

    private boolean shouldShowPixelTwoWay(boolean bl) {
        switch (this.kind) {
            case ALL: {
                return true;
            }
            case CHANGED: {
                return bl;
            }
            case CONFLICT: {
                return bl;
            }
            case SAME: {
                return !bl;
            }
        }
        return true;
    }

    static final class Builder {
        private boolean drawCB;
        private boolean firstSrcAncestor;
        private ImageDeltaKind kind;
        private ImageLayout layout;
        private double lightFactor;
        private RenderingHints renderHints;
        private int threshold;
        private Vector<RenderedImage> vector;

        Builder() {
        }

        public CompareOpImage build() {
            return new CompareOpImage(this);
        }

        public Builder deltaKind(ImageDeltaKind imageDeltaKind) {
            assert (imageDeltaKind != ImageDeltaKind.ALL);
            this.kind = imageDeltaKind;
            return this;
        }

        public Builder drawCB(boolean bl) {
            this.drawCB = bl;
            return this;
        }

        public Builder firstSrcAncestor(boolean bl) {
            this.firstSrcAncestor = bl;
            return this;
        }

        public Builder layout(ImageLayout imageLayout) {
            this.layout = imageLayout;
            return this;
        }

        public Builder lightFactor(double d) {
            this.lightFactor = d;
            return this;
        }

        public Builder renderHints(RenderingHints renderingHints) {
            this.renderHints = renderingHints;
            return this;
        }

        public Builder sources(Vector<RenderedImage> vector) {
            this.vector = vector;
            return this;
        }

        public Builder threshold(int n) {
            this.threshold = n;
            return this;
        }
    }

    private final class DiffsThreeWay {
        private int absDiff1;
        private int absDiff3;
        private boolean showPix3Way;

        public DiffsThreeWay(boolean bl, int n, int n2) {
            this.showPix3Way = bl;
            this.absDiff1 = n;
            this.absDiff3 = n2;
        }

        public int absDiff1() {
            return this.absDiff1;
        }

        public int absDiff3() {
            return this.absDiff3;
        }

        public boolean shouldShowPixelThreeWay() {
            return this.showPix3Way;
        }
    }

    private final class DiffsTwoWay {
        private int absDiff;
        private boolean showPix2Way;

        public DiffsTwoWay(boolean bl, int n) {
            this.showPix2Way = bl;
            this.absDiff = n;
        }

        public int absDiff() {
            return this.absDiff;
        }

        public boolean shouldShowPixelTwoWay() {
            return this.showPix2Way;
        }
    }
}

