/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal.common;

import com.deltawalker.image.internal.common.IFunctionInt;
import com.deltawalker.image.internal.common.LinearFunctionInt;
import com.deltopia.MathUtil;
import com.deltopia.util.logging.ToString;
import java.awt.Point;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public final class PiecewiseLinearFunctionInt
implements IFunctionInt {
    private final Map<Point, LinearFunctionInt> listSegment;

    public PiecewiseLinearFunctionInt(int ... nArray) throws NullPointerException, IllegalArgumentException {
        if (nArray == null) {
            throw new NullPointerException("listPointSegment");
        }
        int n = nArray.length;
        if (n < 4 || n / 2 * 2 != n) {
            throw new IllegalArgumentException("Invalid x,y coordinates");
        }
        this.listSegment = new TreeMap<Point, LinearFunctionInt>(new PointComparator());
        int n2 = 0;
        int n3 = nArray[n2++];
        int n4 = nArray[n2++];
        while (n2 < n) {
            int n5 = nArray[n2++];
            int n6 = nArray[n2++];
            if (n5 <= n3 || n6 <= n4) {
                throw new IllegalArgumentException("Non-increased points " + n5 + 'x' + n6);
            }
            this.listSegment.put(new Point(n5, n6), new LinearFunctionInt(n3, n4, n5, n6));
            n3 = n5;
            n4 = n6;
        }
    }

    private int getInternal(int n, boolean bl) {
        LinearFunctionInt linearFunctionInt = null;
        for (Map.Entry<Point, LinearFunctionInt> entry : this.listSegment.entrySet()) {
            Point point = entry.getKey();
            int n2 = bl ? point.y : point.x;
            linearFunctionInt = entry.getValue();
            if (n <= n2) break;
        }
        return bl ? linearFunctionInt.getX(n) : linearFunctionInt.getY(n);
    }

    @Override
    public int getY(int n) {
        return this.getInternal(n, false);
    }

    @Override
    public int getX(int n) {
        return this.getInternal(n, true);
    }

    public String toString() {
        return new ToString().append("Segments", this.listSegment.values()).toString();
    }

    private static class PointComparator
    implements Comparator<Point> {
        private PointComparator() {
        }

        @Override
        public int compare(Point point, Point point2) {
            int n = MathUtil.compare((int)point.x, (int)point2.x);
            if (n == 0) {
                n = MathUtil.compare((int)point.y, (int)point2.y);
            }
            return n;
        }
    }
}

