/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal.common;

import com.deltawalker.image.internal.common.IFunctionInt;

public final class LinearFunctionInt
implements IFunctionInt {
    private final double slope;
    private final int interceptY;

    public LinearFunctionInt(int n, int n2, int n3, int n4) throws IllegalArgumentException {
        if (n == n3 || n2 == n4) {
            throw new IllegalArgumentException("Cannot define linear function from points with same coordinates" + n + 'x' + n2 + '/' + n3 + 'x' + n4);
        }
        this.slope = ((double)n4 - (double)n2) / (double)(n3 - n);
        this.interceptY = LinearFunctionInt.fitInIntRange((double)n2 - this.slope * (double)n);
    }

    public static final int fitInIntRange(double d) throws IllegalArgumentException {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("NaN value");
        }
        int n = d > 2.147483647E9 ? Integer.MAX_VALUE : (d < -2.147483648E9 ? Integer.MIN_VALUE : (int)Math.round(d));
        return n;
    }

    public double getSlope() {
        return this.slope;
    }

    public int getInterceptY() {
        return this.interceptY;
    }

    @Override
    public int getY(int n) {
        return LinearFunctionInt.fitInIntRange(this.slope * (double)n + (double)this.interceptY);
    }

    @Override
    public int getX(int n) {
        return LinearFunctionInt.fitInIntRange((double)(n - this.interceptY) / this.slope);
    }

    public String toString() {
        return "slope=" + this.slope + ", interceptY=" + this.interceptY;
    }
}

