/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal.common;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;

public final class ImageUtil {
    private static final ColorModel CM_RGB;
    private static final ColorModel CM_RGBA;

    static {
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        CM_RGBA = new ComponentColorModel(colorSpace, new int[]{8, 8, 8, 8}, true, false, 3, 0);
        CM_RGB = new ComponentColorModel(colorSpace, new int[]{8, 8, 8}, false, false, 1, 0);
    }

    public static final double calculateRatio(int n, int n2) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("Non-positive width: " + n);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Non-positive height: " + n2);
        }
        return (double)n / (double)n2;
    }

    public static final boolean hasTransparency(ColorModel colorModel) {
        if (colorModel == null) {
            throw new NullPointerException("colorModel");
        }
        int n = colorModel.getTransparency();
        return n != 1;
    }

    public static final boolean is8BitsColorModel(ColorModel colorModel) throws NullPointerException {
        int n = colorModel.getNumComponents();
        int n2 = 0;
        while (n2 < n) {
            if (colorModel.getComponentSize(n2) != 8) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static final ColorModel getRGBColorModel(ColorModel colorModel) {
        int n = colorModel.getTransparency();
        ColorModel colorModel2 = n != 1 ? CM_RGBA : CM_RGB;
        return colorModel2;
    }

    private ImageUtil() {
    }
}

