/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal.common;

import com.deltawalker.image.internal.ImageLoader;
import com.deltawalker.image.internal.ImageLog;
import com.deltawalker.image.internal.Msg;
import com.deltawalker.image.internal.common.IOUtil;
import com.deltawalker.image.internal.common.ImageUtil;
import com.deltawalker.image.internal.common.operation.CompareDescriptor;
import com.deltawalker.image.internal.common.operation.ImageDeltaKind;
import com.deltawalker.script.Role;
import com.deltopia.util.logging.ToString;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.Histogram;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.BandCombineDescriptor;
import javax.media.jai.operator.BandMergeDescriptor;
import javax.media.jai.operator.BandSelectDescriptor;
import javax.media.jai.operator.ColorConvertDescriptor;
import javax.media.jai.operator.FormatDescriptor;
import javax.media.jai.operator.LookupDescriptor;
import javax.media.jai.operator.RescaleDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageOpUtil {
    private static final Logger LOG = LoggerFactory.getLogger((String)"com.deltawalker.image.internal.common.ImageOpUtil");
    private static final boolean TRACE_INEFFECTIVE_CONVERT = false;
    private static final boolean USE_SUBSAMPLE_IN_SCALE = false;

    static {
        CompareDescriptor.register();
    }

    public static final PlanarImage add(RenderedImage renderedImage, RenderedImage renderedImage2) {
        if (renderedImage == null) {
            throw new NullPointerException("image 1");
        }
        if (renderedImage2 == null) {
            throw new NullPointerException("image 2");
        }
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.addSource(renderedImage2);
        return JAI.create("Add", parameterBlock);
    }

    public static final PlanarImage compare(Role role, RenderedImage renderedImage, RenderedImage renderedImage2, RenderedImage renderedImage3, ImageDeltaKind imageDeltaKind, double d, int n, RenderingHints renderingHints) {
        ArrayList<RenderedImage> arrayList = new ArrayList<RenderedImage>();
        arrayList.add(renderedImage);
        arrayList.add(renderedImage2);
        if (renderedImage3 != null) {
            arrayList.add(renderedImage3);
        }
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(arrayList);
        parameterBlock.add((Object)imageDeltaKind);
        parameterBlock.add(d);
        parameterBlock.add(false);
        parameterBlock.add(n);
        parameterBlock.add(role == Role.REF);
        return JAI.create("Compare", parameterBlock, renderingHints);
    }

    private static final PlanarImage convert8bits(PlanarImage planarImage, RenderingHints renderingHints) {
        ColorModel colorModel = planarImage.getColorModel();
        int[] nArray = colorModel.getComponentSize();
        double[] dArray = new double[nArray.length];
        double[] dArray2 = new double[nArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = nArray[n2];
            if (n3 == 8) {
                ++n;
            }
            dArray[n2] = 255.0 / (double)(1 << n3);
            dArray2[n2] = 0.0;
            ++n2;
        }
        if (n == nArray.length) {
            return planarImage;
        }
        RenderedOp renderedOp = RescaleDescriptor.create(planarImage, dArray, dArray2, renderingHints);
        return renderedOp;
    }

    public static RenderedOp convertToComponentColorModel(RenderedOp object) throws IllegalArgumentException {
        int n;
        Object object2;
        SampleModel sampleModel = ((RenderedOp)object).getSampleModel();
        int n2 = sampleModel.getDataType();
        if (n2 != 0) {
            object = object2 = FormatDescriptor.create((RenderedImage)object, 0, null);
        }
        if ((n = ((ColorModel)(object2 = ((RenderedOp)object).getColorModel())).getColorSpace().getType()) != 5 && n != 6) {
            double[][] dArrayArray = new double[][]{{1.0, 0.0}, {1.0, 0.0}, {1.0, 0.0}};
            ParameterBlock parameterBlock = new ParameterBlock();
            parameterBlock.addSource(object);
            parameterBlock.add(dArrayArray);
            return JAI.create("bandcombine", parameterBlock, null);
        }
        if (((RenderedOp)object).getColorModel() instanceof ComponentColorModel) {
            return object;
        }
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(object);
        parameterBlock.add(((RenderedOp)object).getSampleModel().getTransferType());
        ImageLayout imageLayout = new ImageLayout();
        int n3 = 0;
        switch (((RenderedOp)object).getSampleModel().getTransferType()) {
            case 0: {
                n3 = 8;
                break;
            }
            case 1: {
                n3 = 16;
                break;
            }
            case 2: {
                n3 = 16;
                break;
            }
            case 3: {
                n3 = 32;
                break;
            }
            case 4: {
                n3 = 32;
                break;
            }
            case 5: {
                n3 = 64;
                break;
            }
            default: {
                throw new IllegalArgumentException("Incorrect data type for an index color model.");
            }
        }
        int n4 = ((RenderedOp)object).getColorModel().getTransparency();
        ComponentColorModel componentColorModel = n4 != 1 ? new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{n3, n3, n3, n3}, true, false, 3, ((RenderedOp)object).getSampleModel().getTransferType()) : new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{n3, n3, n3}, false, false, n4, ((RenderedOp)object).getSampleModel().getTransferType());
        imageLayout.setColorModel(componentColorModel);
        imageLayout.setSampleModel(((ColorModel)componentColorModel).createCompatibleSampleModel(((RenderedOp)object).getWidth(), ((RenderedOp)object).getHeight()));
        RenderingHints renderingHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout);
        RenderedOp renderedOp = JAI.create("format", parameterBlock, renderingHints);
        return renderedOp;
    }

    public static final PlanarImage convertToRGB(PlanarImage planarImage) throws IIOException {
        ColorModel colorModel;
        RenderedOp renderedOp;
        RenderingHints renderingHints;
        Object object;
        Object object2;
        ColorModel colorModel2;
        assert (planarImage != null);
        assert (planarImage.getSampleModel() != null);
        assert (planarImage.getColorModel() != null);
        int n = planarImage.getSampleModel().getNumBands();
        RenderedOp renderedOp2 = null;
        if (n > 4) {
            colorModel2 = planarImage.getColorModel();
            if (colorModel2.getColorSpace().getType() == 9 && colorModel2.hasAlpha() && n == 5) {
                renderedOp2 = BandSelectDescriptor.create(planarImage, new int[]{4}, null);
                object2 = new ComponentColorModel(colorModel2.getColorSpace(), new int[]{8, 8, 8, 8}, false, false, 1, colorModel2.getTransferType());
                object = new ImageLayout();
                ((ImageLayout)object).setColorModel((ColorModel)object2);
                renderingHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, object);
                int[] nArray = new int[4];
                nArray[1] = 1;
                nArray[2] = 2;
                nArray[3] = 3;
                planarImage = BandSelectDescriptor.create(planarImage, nArray, renderingHints);
            } else {
                ImageLog.error(new ToString().append("Image with more than 4 bands:\n\tSampleModel", planarImage.getSampleModel()).append(",\n\tColorModel", (Object)planarImage.getColorModel()).toString());
                throw new IIOException(ImageLoader.composeErrorMessage(Msg.ImageLoader_errInvalidParams));
            }
        }
        if (ImageOpUtil.isRGBComponent(planarImage.getColorModel()) && planarImage.getSampleModel().getDataType() == 0) {
            return planarImage;
        }
        colorModel2 = ImageUtil.getRGBColorModel(planarImage.getColorModel());
        object2 = new ImageLayout();
        ((ImageLayout)object2).setColorModel(colorModel2);
        object = colorModel2.createCompatibleSampleModel(planarImage.getWidth(), planarImage.getHeight());
        ((ImageLayout)object2).setSampleModel((SampleModel)object);
        renderingHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, object2);
        if (planarImage.getColorModel() instanceof ComponentColorModel) {
            planarImage = ImageOpUtil.convert8bits(planarImage, null);
        }
        if (planarImage.getSampleModel().getDataType() != 0) {
            boolean bl = planarImage.getColorModel().getColorSpace().getType() != 6;
            renderedOp = FormatDescriptor.create(planarImage, 0, bl ? renderingHints : null);
            assert (renderedOp.getSampleModel().getDataType() == 0);
            assert (!bl || renderedOp.getColorModel().getTransparency() == colorModel2.getTransparency());
            planarImage = renderedOp;
        }
        if ((colorModel = planarImage.getColorModel()) instanceof ComponentColorModel && colorModel.getColorSpace().isCS_sRGB()) {
            return planarImage;
        }
        if (colorModel.getColorSpace().getType() == 6 && colorModel.hasAlpha()) {
            double[][] dArrayArray = new double[][]{{1.0, 0.0, 0.0}, {1.0, 0.0, 0.0}, {1.0, 0.0, 0.0}, {1.0, 0.0, 0.0}};
            renderedOp = BandCombineDescriptor.create(planarImage, dArrayArray, renderingHints);
        } else if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            byte[][] byArray = new byte[ImageUtil.hasTransparency(colorModel) ? 4 : 3][indexColorModel.getMapSize()];
            indexColorModel.getReds(byArray[0]);
            indexColorModel.getGreens(byArray[1]);
            indexColorModel.getBlues(byArray[2]);
            if (byArray.length > 3) {
                indexColorModel.getAlphas(byArray[3]);
            }
            LookupTableJAI lookupTableJAI = new LookupTableJAI(byArray);
            renderedOp = LookupDescriptor.create(planarImage, lookupTableJAI, renderingHints);
        } else {
            renderedOp = ColorConvertDescriptor.create(planarImage, colorModel2, renderingHints);
        }
        if (renderedOp2 != null) {
            renderedOp = BandMergeDescriptor.create(renderedOp, renderedOp2, null);
        }
        assert (renderedOp.getSampleModel().getDataType() == 0);
        assert (renderedOp.getColorModel().getColorSpace().isCS_sRGB());
        return renderedOp;
    }

    public static final int[] histogram(PlanarImage planarImage) {
        if (planarImage == null) {
            throw new NullPointerException("image");
        }
        int[] nArray = new int[]{256};
        double[] dArray = new double[]{0.0};
        double[] dArray2 = new double[]{256.0};
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(planarImage);
        parameterBlock.add(null);
        parameterBlock.add(1);
        parameterBlock.add(1);
        parameterBlock.add(nArray);
        parameterBlock.add(dArray);
        parameterBlock.add(dArray2);
        RenderedOp renderedOp = JAI.create("histogram", parameterBlock, null);
        Histogram histogram = (Histogram)renderedOp.getProperty("histogram");
        int[] nArray2 = new int[histogram.getNumBins(0)];
        int n = 0;
        while (n < histogram.getNumBins(0)) {
            nArray2[n] = histogram.getBinSize(0, n);
            ++n;
        }
        return nArray2;
    }

    private static final boolean isRGBComponent(ColorModel colorModel) {
        return colorModel instanceof ComponentColorModel && (colorModel.getColorSpace().isCS_sRGB() || colorModel.getColorSpace().getType() == 5 && colorModel.hasAlpha());
    }

    public static final PlanarImage scale(PlanarImage planarImage, double d, double d2, Interpolation interpolation) throws NullPointerException {
        if (planarImage == null) {
            throw new NullPointerException("image");
        }
        if (Math.abs(d - d2) < 0.001) {
            d2 = d;
        }
        return ImageOpUtil.scaleOp(planarImage, (float)d, (float)d2, interpolation);
    }

    private static final PlanarImage scaleOp(PlanarImage planarImage, float f, float f2, Interpolation interpolation) throws NullPointerException {
        if (planarImage == null) {
            throw new NullPointerException("image");
        }
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(planarImage);
        parameterBlock.add(f);
        parameterBlock.add(f2);
        parameterBlock.add(0.0f);
        parameterBlock.add(0.0f);
        if (interpolation == null) {
            interpolation = Interpolation.getInstance(0);
        }
        parameterBlock.add(interpolation);
        return JAI.create("scale", parameterBlock);
    }

    public static final PlanarImage scaleSame(PlanarImage planarImage, double d) throws NullPointerException {
        if (planarImage == null) {
            throw new NullPointerException("image");
        }
        return ImageOpUtil.scaleOp(planarImage, (float)d, (float)d, null);
    }

    private static final PlanarImage subsampleOp(PlanarImage planarImage, double d, double d2, Interpolation interpolation) throws NullPointerException {
        if (planarImage == null) {
            throw new NullPointerException("image");
        }
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(planarImage);
        parameterBlock.add(d);
        parameterBlock.add(d2);
        if (interpolation == null) {
            interpolation = Interpolation.getInstance(0);
        }
        RenderingHints renderingHints = new RenderingHints(JAI.KEY_INTERPOLATION, interpolation);
        return JAI.create("SubsampleAverage", parameterBlock, renderingHints);
    }

    public static final PlanarImage subtract(RenderedImage renderedImage, RenderedImage renderedImage2) throws NullPointerException {
        if (renderedImage == null) {
            throw new NullPointerException("image 1");
        }
        if (renderedImage2 == null) {
            throw new NullPointerException("image 2");
        }
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.addSource(renderedImage2);
        return JAI.create("Subtract", parameterBlock);
    }

    public static final void disposePlanarImageChain(PlanarImage planarImage) {
        assert (planarImage != null);
        ImageOpUtil.disposePlanarImageChain(planarImage, new HashSet<PlanarImage>());
    }

    private static void disposePlanarImageChain(PlanarImage planarImage, HashSet<PlanarImage> hashSet) {
        Vector vector3;
        if (hashSet.contains(planarImage)) {
            return;
        }
        Vector vector2 = planarImage.getSinks();
        if (vector2 != null) {
            for (Vector vector3 : vector2) {
                Object object2;
                if (!(vector3 instanceof PlanarImage) || hashSet.contains(object2 = (PlanarImage)((Object)vector3))) continue;
                ((PlanarImage)object2).dispose();
                hashSet.add((PlanarImage)object2);
            }
        }
        planarImage.dispose();
        hashSet.add(planarImage);
        vector3 = planarImage.getSources();
        if (vector3 != null) {
            for (Object object : vector3) {
                if (!(object instanceof PlanarImage)) continue;
                ImageOpUtil.disposePlanarImageChain((PlanarImage)object, hashSet);
            }
        }
        if (planarImage instanceof RenderedOp) {
            Object object;
            object = (RenderedOp)planarImage;
            for (Object object2 : ((RenderedOp)object).getParameterBlock().getParameters()) {
                Closeable closeable;
                if (object2 instanceof ImageInputStream) {
                    closeable = (ImageInputStream)object2;
                    IOUtil.closeSilent(closeable);
                    continue;
                }
                if (object2 instanceof Closeable) {
                    closeable = (Closeable)object2;
                    IOUtil.closeSilent(closeable);
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info("- Close source: " + closeable);
                    continue;
                }
                if (!(object2 instanceof File) || !LOG.isInfoEnabled()) continue;
                LOG.info("- Dispose source file: " + object2);
            }
        }
    }

    private ImageOpUtil() {
    }
}

