/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal.common;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public final class ImageFactory {
    private static final GraphicsConfiguration DEFAULT_CONFIGURATION;

    static {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        DEFAULT_CONFIGURATION = !graphicsEnvironment.isHeadlessInstance() ? graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration() : null;
    }

    private ImageFactory() {
    }

    public static BufferedImage createGrayscale(int n, byte[] byArray) throws NullPointerException, IllegalArgumentException {
        int n2 = byArray.length / n;
        if (n2 <= 0 || n2 * n != byArray.length) {
            throw new IllegalArgumentException("Invalid input data=" + byArray.length + " width=" + n);
        }
        ColorSpace colorSpace = ColorSpace.getInstance(1003);
        int[] nArray = new int[]{8};
        ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, nArray, false, true, 1, 0);
        SampleModel sampleModel = ((ColorModel)componentColorModel).createCompatibleSampleModel(n, n2);
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, n * n2);
        WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, dataBufferByte, null);
        return new BufferedImage(componentColorModel, writableRaster, false, null);
    }

    public static final BufferedImage createIndexColor(Dimension dimension, int[] nArray, byte[] byArray, int n) throws IllegalArgumentException {
        if (byArray.length <= 0) {
            throw new IllegalArgumentException("Empty data");
        }
        if (nArray.length != 256) {
            throw new IllegalArgumentException("Non 256 colors palette " + nArray.length);
        }
        if (dimension.width * dimension.height != byArray.length) {
            throw new IllegalArgumentException("Invalid size: " + dimension + " for length=" + byArray.length);
        }
        IndexColorModel indexColorModel = new IndexColorModel(8, 256, nArray, 0, false, n, 0);
        SampleModel sampleModel = indexColorModel.createCompatibleSampleModel(dimension.width, dimension.height);
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, dimension.width * dimension.height, 0);
        WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, dataBufferByte, new Point(0, 0));
        BufferedImage bufferedImage = new BufferedImage(indexColorModel, writableRaster, false, null);
        return bufferedImage;
    }

    public static BufferedImage createOptimized(int n, int n2, int n3) {
        BufferedImage bufferedImage;
        if (DEFAULT_CONFIGURATION != null) {
            bufferedImage = DEFAULT_CONFIGURATION.createCompatibleImage(n, n2, n3);
        } else {
            int n4;
            switch (n3) {
                case 1: {
                    n4 = 1;
                    break;
                }
                case 2: 
                case 3: {
                    n4 = 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("transparency type: " + n3);
                }
            }
            bufferedImage = new BufferedImage(n, n2, n4);
        }
        return bufferedImage;
    }
}

