/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal.common;

import com.deltawalker.image.internal.common.ImageUtil;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.WritableRaster;

public final class ImageConverter {
    public static final BufferedImage convertTo8BitComponentRGB(BufferedImage bufferedImage) throws NullPointerException {
        ColorModel colorModel = bufferedImage.getColorModel();
        if (colorModel instanceof ComponentColorModel && colorModel.getColorSpace().isCS_sRGB() && ImageUtil.is8BitsColorModel(colorModel) && bufferedImage.getSampleModel().getDataType() == 0) {
            return bufferedImage;
        }
        ColorModel colorModel2 = ImageUtil.getRGBColorModel(bufferedImage.getColorModel());
        WritableRaster writableRaster = colorModel2.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight());
        BufferedImage bufferedImage2 = new BufferedImage(colorModel2, writableRaster, colorModel.isAlphaPremultiplied(), null);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        try {
            graphics2D.drawRenderedImage(bufferedImage, null);
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    private ImageConverter() {
    }
}

