/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal.common;

import com.deltawalker.image.internal.ImageLog;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.imageio.stream.ImageInputStream;

public final class IOUtil {
    public static final byte[] readData(File file, int n, int n2) throws IOException {
        if (n < 0 || n > n2) {
            throw new IllegalArgumentException("Invalid offset/length: " + n + '/' + n2);
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        try {
            if (n2 == 0) {
                byte[] byArray = new byte[]{};
                return byArray;
            }
            randomAccessFile.skipBytes(n);
            byte[] byArray = new byte[n2];
            int n3 = 0;
            while (n3 < n2) {
                int n4 = randomAccessFile.read(byArray, n3, n2 - n3);
                n3 += n4;
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            IOUtil.closeSilent(randomAccessFile);
        }
    }

    public static final void saveData(byte[] byArray, File file, int n, int n2) throws IOException, NullPointerException, IllegalArgumentException {
        if (byArray == null) {
            throw new NullPointerException("data");
        }
        if (n < 0 || n > n2) {
            throw new IllegalArgumentException("Invalid offset/length: " + n + '/' + n2);
        }
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");){
            randomAccessFile.write(byArray, n, n2);
        }
    }

    public static final void closeSilent(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                ImageLog.warn("Failed to close: " + closeable, iOException);
            }
        }
    }

    public static void closeSilent(ImageInputStream imageInputStream) {
        if (imageInputStream != null) {
            try {
                imageInputStream.close();
            }
            catch (IOException iOException) {
                ImageLog.warn("Failed to close: " + imageInputStream, iOException);
            }
        }
    }

    private IOUtil() {
    }
}

