/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal.common;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public final class GeomUtil {
    public static void center(Rectangle rectangle, Dimension dimension) {
        rectangle.x = Math.max((dimension.width - rectangle.width) / 2, 0);
        rectangle.y = Math.max((dimension.height - rectangle.height) / 2, 0);
    }

    public static void center(Rectangle rectangle, Rectangle rectangle2) {
        rectangle.x = rectangle2.x + Math.max((rectangle2.width - rectangle.width) / 2, 0);
        rectangle.y = rectangle2.y + Math.max((rectangle2.height - rectangle.height) / 2, 0);
    }

    public static double computeScaleFit(int n, int n2, int n3, int n4) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Invalid input size " + n + 'x' + n2);
        }
        if (n3 <= 0 || n4 <= 0) {
            throw new IllegalArgumentException("Invalid output size " + n3 + 'x' + n4);
        }
        double d = (double)n3 / (double)n;
        double d2 = (double)n4 / (double)n2;
        return d < d2 ? d : d2;
    }

    public static Point findCenter(Rectangle rectangle) {
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
    }

    public static final boolean isEmpty(Dimension dimension) {
        return dimension.width <= 0 || dimension.height <= 0;
    }

    private GeomUtil() {
    }
}

