/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal.common;

import com.deltawalker.image.internal.common.IOUtil;
import com.sun.media.jai.util.SimpleCMYKColorSpace;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ColorSpaceUtil {
    private static final Logger LOG = LoggerFactory.getLogger((String)"com.deltawalker.image.internal.common.ColorSpaceUtil");
    private static final String ICC_PROFILE_FILE = "/CMYK.icc";
    private static ColorSpace cmykCS = null;

    public static final synchronized ColorSpace getCMYKColorSpace() {
        if (cmykCS == null) {
            block8: {
                InputStream inputStream = null;
                try {
                    try {
                        inputStream = ColorSpaceUtil.class.getResourceAsStream(ICC_PROFILE_FILE);
                        if (inputStream == null) {
                            inputStream = new FileInputStream("./CMYK.icc");
                        }
                        ICC_Profile iCC_Profile = ICC_Profile.getInstance(inputStream);
                        cmykCS = new ICC_ColorSpace(iCC_Profile);
                    }
                    catch (IOException iOException) {
                        LOG.error("Failed to load CMYK profile", (Throwable)iOException);
                        IOUtil.closeSilent(inputStream);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.closeSilent(inputStream);
                    throw throwable;
                }
                IOUtil.closeSilent(inputStream);
            }
            if (cmykCS == null) {
                cmykCS = SimpleCMYKColorSpace.getInstance();
            }
        }
        return cmykCS;
    }
}

