/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal.common;

import com.deltawalker.image.internal.common.Border;
import com.deltopia.util.Const;
import java.awt.Insets;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;

public class BorderDoubleLine
extends Border {
    public static final int STYLE_ETCHED = 1;
    private Color colorIn;
    private Color colorOut;
    private final boolean dispose;
    private final Insets gapInsets;
    private final int style;

    public BorderDoubleLine(Color color, Color color2, boolean bl, Insets insets, int n) throws NullPointerException {
        if (color == null) {
            throw new NullPointerException("colorOut");
        }
        if (color2 == null) {
            throw new NullPointerException("colorIn");
        }
        this.colorIn = color2;
        this.colorOut = color;
        this.dispose = bl;
        this.style = n;
        this.gapInsets = insets != null ? new Insets(insets.top > 0 ? insets.top : 0, insets.left > 0 ? insets.left : 0, insets.bottom > 0 ? insets.bottom : 0, insets.right > 0 ? insets.right : 0) : null;
    }

    public BorderDoubleLine(Color color, Color color2, boolean bl, int n, int n2) throws NullPointerException {
        this(color, color2, bl, n > 0 ? new Insets(n, n, n, n) : null, n2);
    }

    public BorderDoubleLine(Device device, int n, int n2, Insets insets, int n3) throws NullPointerException {
        this(device.getSystemColor(n), device.getSystemColor(n2), false, insets, n3);
    }

    public BorderDoubleLine(Device device, int n, int n2, int n3, int n4) throws NullPointerException {
        this(device.getSystemColor(n), device.getSystemColor(n2), false, n3, n4);
    }

    @Override
    public void dispose() {
        if (this.dispose) {
            if (this.colorOut != null) {
                this.colorOut.dispose();
                this.colorOut = null;
            }
            if (this.colorIn != null) {
                this.colorIn.dispose();
                this.colorIn = null;
            }
        }
    }

    @Override
    public final Insets getInsets() {
        return new Insets(2 + this.gapInsets.top, 2 + this.gapInsets.left, 2 + this.gapInsets.bottom, 2 + this.gapInsets.right);
    }

    @Override
    public void paintBorder(Control control, GC gC, int n, int n2, int n3, int n4) {
        if (this.colorOut == null || this.colorIn == null) {
            return;
        }
        Color color = gC.getForeground();
        if ((this.style & 1) != 0) {
            gC.setForeground(this.colorOut);
            gC.drawRoundRectangle(n, n2, n3 - 2, n4 - 2, Const.ARC_M.x, Const.ARC_M.y);
            gC.setForeground(this.colorIn);
            gC.drawRoundRectangle(n + 1, n2 + 1, n3 - 4, n4 - 4, Const.ARC_M.x, Const.ARC_M.y);
        } else {
            gC.setForeground(this.colorOut);
            gC.drawRectangle(n, n2, n3 - 1, n4 - 1);
            if (n3 > 1 && n4 > 1) {
                gC.setForeground(this.colorIn);
                gC.drawRectangle(n + 1, n2 + 1, n3 - 3, n4 - 3);
            }
        }
        gC.setForeground(color);
    }
}

