/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal.common;

import com.deltawalker.image.internal.common.ImageUtil;
import com.deltawalker.image.internal.common.SwtCompatibleRaster;
import com.deltopia.util.logging.ToString;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.PlanarImage;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.awt.image.ByteInterleavedRaster;
import sun.awt.image.BytePackedRaster;

public class AwtToSwtImageConverter {
    private static final Logger LOG = LoggerFactory.getLogger((String)"com.deltawalker.image.internal.common.AwtToSwtImageConverter");
    private static final int[] ABGR;
    private static Map<ColorSpace, Map<ColorSpace, ColorConvertOp>> ConvertOps;
    private static final String OS_NAME;
    private static OS_Switch OsSwitch;
    private static final int[] RGBA;

    static {
        int[] nArray = new int[4];
        nArray[0] = 3;
        nArray[1] = 2;
        nArray[2] = 1;
        ABGR = nArray;
        int[] nArray2 = new int[4];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        RGBA = nArray2;
        OS_NAME = System.getProperty("os.name");
        ConvertOps = new HashMap<ColorSpace, Map<ColorSpace, ColorConvertOp>>();
        OsSwitch = OS_NAME.contains("Windows") ? new OS_Windows() : new OS_Other();
    }

    public static ImageData bufferedToImageData(BufferedImage bufferedImage, int n, int n2) {
        return AwtToSwtImageConverter.planarToImageData(PlanarImage.wrapRenderedImage(bufferedImage), n, n2);
    }

    protected static void computeValuesFromAwtImage(SampleModel sampleModel, ColorModel colorModel, int n, IValueHolder iValueHolder, IValueHolder iValueHolder2, IValueHolder iValueHolder3) {
        if (sampleModel.getDataType() != 0) {
            throw new IllegalStateException();
        }
        ColorSpace colorSpace = colorModel.getColorSpace();
        if (!colorSpace.isCS_sRGB()) {
            throw new IllegalStateException(new ToString().append("Unsupported color space", colorSpace).toString());
        }
        if (colorModel instanceof IndexColorModel) {
            AwtToSwtImageConverter.computeValuesPaletteIndexed((IndexColorModel)colorModel, n, iValueHolder, iValueHolder2, iValueHolder3);
            return;
        }
        throw new IllegalStateException();
    }

    protected static void computeValuesPaletteIndexed(IndexColorModel indexColorModel, int n, IValueHolder iValueHolder, IValueHolder iValueHolder2, IValueHolder iValueHolder3) {
        int[] nArray = new int[indexColorModel.getMapSize()];
        indexColorModel.getRGBs(nArray);
        RGB[] rGBArray = new RGB[(int)Math.pow(2.0, n)];
        int n2 = 0;
        while (n2 < nArray.length) {
            RGB rGB;
            rGBArray[n2] = rGB = new RGB(nArray[n2] >> 16 & 0xFF, nArray[n2] >> 8 & 0xFF, nArray[n2] & 0xFF);
            ++n2;
        }
        n2 = nArray.length;
        while (n2 < rGBArray.length) {
            rGBArray[n2] = new RGB(0, 0, 0);
            ++n2;
        }
        iValueHolder.set(new PaletteData(rGBArray));
        iValueHolder2.set(1);
        iValueHolder3.set(indexColorModel.getTransparentPixel());
    }

    protected static void convert(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        ColorConvertOp colorConvertOp;
        ColorSpace colorSpace = bufferedImage.getColorModel().getColorSpace();
        ColorSpace colorSpace2 = bufferedImage2.getColorModel().getColorSpace();
        Map<ColorSpace, ColorConvertOp> map = AwtToSwtImageConverter.getConvertOps().get(colorSpace);
        if (map == null) {
            map = new HashMap<ColorSpace, ColorConvertOp>();
            AwtToSwtImageConverter.getConvertOps().put(colorSpace, map);
            colorConvertOp = null;
        } else {
            colorConvertOp = map.get(colorSpace2);
        }
        if (colorConvertOp == null) {
            colorConvertOp = new ColorConvertOp(null);
            map.put(colorSpace2, colorConvertOp);
        }
        colorConvertOp.filter(bufferedImage, bufferedImage2);
    }

    private static final ImageData convertRGBComponent3Bytes(Raster raster, int[] nArray) {
        assert (nArray.length == 3);
        PaletteData paletteData = new PaletteData(0xFF0000 >> (nArray[0] << 3), 0xFF0000 >> (nArray[1] << 3), 0xFF0000 >> (nArray[2] << 3));
        byte[] byArray = AwtToSwtImageConverter.getDataBytes(raster);
        ImageData imageData = new ImageData(raster.getWidth(), raster.getHeight(), 24, paletteData, 3, byArray);
        return imageData;
    }

    private static final ImageData convertRGBComponent4Bytes(Raster raster, int[] nArray) {
        PaletteData paletteData;
        int n;
        boolean bl;
        assert (nArray.length == 4);
        if (Arrays.equals(nArray, RGBA)) {
            bl = true;
        } else if (Arrays.equals(nArray, ABGR)) {
            bl = false;
        } else {
            return null;
        }
        byte[] byArray = AwtToSwtImageConverter.getDataBytes(raster);
        int n2 = byArray.length;
        int n3 = n2 / 4;
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[n3 * 3];
        int n4 = 0;
        int n5 = 0;
        if (bl) {
            n = 0;
            while (n < n2) {
                byArray3[n4++] = byArray[n++];
                byArray3[n4++] = byArray[n++];
                byArray3[n4++] = byArray[n++];
                byArray2[n5++] = byArray[n++];
            }
            paletteData = new PaletteData(0xFF0000, 65280, 255);
        } else {
            n = 0;
            while (n < n2) {
                byArray2[n5++] = byArray[n++];
                byArray3[n4++] = byArray[n++];
                byArray3[n4++] = byArray[n++];
                byArray3[n4++] = byArray[n++];
            }
            paletteData = new PaletteData(255, 65280, 0xFF0000);
        }
        ImageData imageData = new ImageData(raster.getWidth(), raster.getHeight(), 24, paletteData, 3, byArray3);
        imageData.alphaData = byArray2;
        return imageData;
    }

    protected static BufferedImage createSwtCompatibleAwtImage(int n, int n2, boolean bl) {
        ComponentColorModel componentColorModel = bl ? CwtAwtImageTools.getRgbTransparentColorModel() : CwtAwtImageTools.getRgbColorModel();
        int n3 = componentColorModel.getNumComponents();
        int[] nArray = new int[n3];
        OsSwitch.initializeRgbBandOffsets(nArray);
        if (nArray.length > 3) {
            nArray[3] = 3;
        }
        PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(0, n, n2, n3, n * n3, nArray);
        DataBufferByte dataBufferByte = new DataBufferByte(n * n2 * n3);
        SwtCompatibleRaster swtCompatibleRaster = new SwtCompatibleRaster(pixelInterleavedSampleModel, dataBufferByte, new Point(0, 0));
        return new BufferedImage(componentColorModel, swtCompatibleRaster, false, null);
    }

    protected static Map<ColorSpace, Map<ColorSpace, ColorConvertOp>> getConvertOps() {
        return ConvertOps;
    }

    private static final byte[] getDataBytes(Raster raster) {
        byte[] byArray;
        assert (raster.getSampleModel().getDataType() == 0);
        if (raster instanceof SwtCompatibleRaster) {
            byArray = ((SwtCompatibleRaster)raster).getDataStorage();
        } else if (raster instanceof ByteInterleavedRaster) {
            byArray = ((ByteInterleavedRaster)raster).getDataStorage();
        } else if (raster instanceof BytePackedRaster) {
            byArray = ((BytePackedRaster)raster).getDataStorage();
        } else {
            if (LOG.isInfoEnabled()) {
                LOG.warn("Ineffective data get " + raster);
            }
            byArray = (byte[])raster.getDataElements(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight(), null);
        }
        return byArray;
    }

    private static final boolean isByteComponentColorModel(ColorModel colorModel) {
        return colorModel instanceof ComponentColorModel && ImageUtil.is8BitsColorModel(colorModel);
    }

    private static final boolean isByteComponentSampleModel(SampleModel sampleModel) {
        return sampleModel.getDataType() == 0 && sampleModel instanceof ComponentSampleModel;
    }

    public static ImageData planarToImageData(PlanarImage planarImage, int n, int n2) {
        return AwtToSwtImageConverter.rasterToImageData(planarImage.getTile(n, n2), planarImage.getColorModel());
    }

    public static ImageData rasterToImageData(Raster raster, ColorModel colorModel) {
        Object object;
        Object object2;
        Object object3;
        int n = colorModel.getPixelSize();
        if (colorModel instanceof ComponentColorModel && colorModel.getNumComponents() == 1) {
            PaletteData paletteData = new PaletteData(255, 65280, 0xFF0000);
            int[] nArray = new int[1];
            if (colorModel.getPixelSize() == 16) {
                ImageData imageData = new ImageData(raster.getWidth(), raster.getHeight(), 24, paletteData);
                int n2 = 0;
                while (n2 < imageData.height) {
                    int n3 = 0;
                    while (n3 < imageData.width) {
                        raster.getPixel(n3, n2, nArray);
                        imageData.setPixel(n3, n2, paletteData.getPixel(new RGB(nArray[0] / 256, nArray[0] / 256, nArray[0] / 256)));
                        ++n3;
                    }
                    ++n2;
                }
                return imageData;
            }
            ImageData imageData = new ImageData(raster.getWidth(), raster.getHeight(), 24, paletteData);
            int n4 = 0;
            while (n4 < imageData.height) {
                int n5 = 0;
                while (n5 < imageData.width) {
                    raster.getPixel(n5, n4, nArray);
                    imageData.setPixel(n5, n4, paletteData.getPixel(new RGB(nArray[0], nArray[0], nArray[0])));
                    ++n5;
                }
                ++n4;
            }
            return imageData;
        }
        SampleModel sampleModel = raster.getSampleModel();
        if (colorModel.getColorSpace().isCS_sRGB() && AwtToSwtImageConverter.isByteComponentColorModel(colorModel) && AwtToSwtImageConverter.isByteComponentSampleModel(sampleModel)) {
            object3 = (ComponentSampleModel)raster.getSampleModel();
            object2 = ((ComponentSampleModel)object3).getBandOffsets();
            object = null;
            if (((int[])object2).length == 4) {
                object = AwtToSwtImageConverter.convertRGBComponent4Bytes(raster, object2);
            } else if (((int[])object2).length == 3) {
                object = AwtToSwtImageConverter.convertRGBComponent3Bytes(raster, object2);
            }
            if (object != null) {
                return object;
            }
        }
        if (colorModel.getTransparency() == 3) {
            n = n / colorModel.getNumComponents() * colorModel.getNumColorComponents();
        }
        ObjectValueHolder objectValueHolder = new ObjectValueHolder(null);
        ObjectValueHolder objectValueHolder2 = new ObjectValueHolder(0);
        ObjectValueHolder objectValueHolder3 = new ObjectValueHolder(-1);
        try {
            AwtToSwtImageConverter.computeValuesFromAwtImage(sampleModel, colorModel, n, objectValueHolder, objectValueHolder2, objectValueHolder3);
        }
        catch (IllegalStateException illegalStateException) {
            if (LOG.isInfoEnabled()) {
                LOG.warn("computeValuesFromAwtImage failed", (Throwable)illegalStateException);
            }
            WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(raster.getWidth(), raster.getHeight());
            writableRaster.setRect(-raster.getMinX(), -raster.getMinY(), raster);
            object2 = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
            object = AwtToSwtImageConverter.createSwtCompatibleAwtImage(raster.getWidth(), raster.getHeight(), colorModel.hasAlpha());
            AwtToSwtImageConverter.convert((BufferedImage)object2, (BufferedImage)object);
            n = 24;
            objectValueHolder.set(OsSwitch.createRgbPaletteData());
            objectValueHolder2.set(3);
            raster = ((BufferedImage)object).getRaster();
        }
        object3 = AwtToSwtImageConverter.getDataBytes(raster);
        if (((PaletteData)objectValueHolder.get()).isDirect && colorModel.hasAlpha()) {
            object = new byte[((Object)object3).length / 4];
            object2 = new byte[((Object)object3).length / 4 * 3];
            int n6 = 0;
            while (n6 < ((ImageData)object).length) {
                object2[n6 * 3] = (int)object3[n6 * 4];
                object2[n6 * 3 + 1] = (int)object3[n6 * 4 + 1];
                object2[n6 * 3 + 2] = (int)object3[n6 * 4 + 2];
                object[n6] = object3[n6 * 4 + 3];
                ++n6;
            }
        } else {
            object = null;
            object2 = object3;
        }
        ImageData imageData = new ImageData(raster.getWidth(), raster.getHeight(), n, (PaletteData)objectValueHolder.get(), ((Integer)objectValueHolder2.get()).intValue(), (byte[])object2);
        imageData.transparentPixel = (Integer)objectValueHolder3.get();
        if (object != null) {
            imageData.alphaData = (byte[])object;
        }
        return imageData;
    }

    static class CwtAwtImageTools {
        private static ComponentColorModel ccmGray;
        private static ComponentColorModel ccmGrayAlpha;
        public static ComponentColorModel ccmRgb;
        public static ComponentColorModel ccmRgbAlpha;

        CwtAwtImageTools() {
        }

        public static ComponentColorModel getGrayColorModel() {
            if (ccmGray == null) {
                ccmGray = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 0);
            }
            return ccmGray;
        }

        public static ComponentColorModel getGrayTransparentColorModel() {
            if (ccmGrayAlpha == null) {
                ccmGrayAlpha = new ComponentColorModel(ColorSpace.getInstance(1003), true, false, 3, 0);
            }
            return ccmGrayAlpha;
        }

        public static ComponentColorModel getRgbColorModel() {
            if (ccmRgb == null) {
                ccmRgb = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, 0);
            }
            return ccmRgb;
        }

        public static ComponentColorModel getRgbTransparentColorModel() {
            if (ccmRgbAlpha == null) {
                ccmRgbAlpha = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 3, 0);
            }
            return ccmRgbAlpha;
        }
    }

    static interface IValueHolder<T> {
        public T get();

        public T set(T var1);
    }

    static class OS_Other
    implements OS_Switch {
        OS_Other() {
        }

        @Override
        public PaletteData createRgbPaletteData() {
            return new PaletteData(0xFF0000, 65280, 255);
        }

        @Override
        public void initializeRgbBandOffsets(int[] nArray) {
            int n = 0;
            while (n < 3) {
                nArray[n] = n;
                ++n;
            }
        }
    }

    static interface OS_Switch {
        public PaletteData createRgbPaletteData();

        public void initializeRgbBandOffsets(int[] var1);
    }

    static class OS_Windows
    implements OS_Switch {
        OS_Windows() {
        }

        @Override
        public PaletteData createRgbPaletteData() {
            return new PaletteData(255, 65280, 0xFF0000);
        }

        @Override
        public void initializeRgbBandOffsets(int[] nArray) {
            int n = 0;
            while (n < 3) {
                nArray[n] = 2 - n;
                ++n;
            }
        }
    }

    static class ObjectValueHolder
    implements IValueHolder {
        private Object value;

        public ObjectValueHolder(Object object) {
            this.value = object;
        }

        public Object get() {
            return this.value;
        }

        public Object set(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }
    }
}

