/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal;

import com.deltopia.util.logging.ToString;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.media.jai.PlanarImage;

final class Tiler {
    private static final Point[] EMPTY_TILE_ARRAY = new Point[0];
    public final int maxTileX;
    public final int maxTileY;
    public final int minTileX;
    public final int minTileY;
    public final int tileGridXOffset;
    public final int tileGridYOffset;
    public final int tileHeight;
    public final int tileWidth;

    public static final Point[] computePointsForIndices(Insets insets) {
        int n = insets.right - insets.left + 1;
        int n2 = insets.bottom - insets.top + 1;
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Invalid limits " + insets);
        }
        if (n == 0 || n2 == 0) {
            return EMPTY_TILE_ARRAY;
        }
        Point[] pointArray = new Point[n * n2];
        int n3 = 0;
        int n4 = insets.top;
        while (n4 <= insets.bottom) {
            int n5 = insets.left;
            while (n5 <= insets.right) {
                pointArray[n3++] = new Point(n5, n4);
                ++n5;
            }
            ++n4;
        }
        return pointArray;
    }

    static final Point[] listToArray(Collection<TileIndex> collection) throws NullPointerException {
        if (collection.size() <= 0) {
            return EMPTY_TILE_ARRAY;
        }
        Point[] pointArray = new Point[collection.size()];
        int n = 0;
        for (TileIndex tileIndex : collection) {
            pointArray[n++] = tileIndex.getLocation();
        }
        return pointArray;
    }

    Tiler(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n3 <= 0) {
            throw new IllegalArgumentException("tileWidth <= 0");
        }
        if (n4 <= 0) {
            throw new IllegalArgumentException("tileHeight <= 0");
        }
        if (n5 > n6) {
            throw new IllegalArgumentException("X range " + n5 + '-' + n6);
        }
        if (n7 > n8) {
            throw new IllegalArgumentException("Y range " + n7 + '-' + n8);
        }
        this.tileGridXOffset = n;
        this.tileGridYOffset = n2;
        this.tileHeight = n4;
        this.tileWidth = n3;
        this.maxTileX = n6;
        this.minTileX = n5;
        this.maxTileY = n8;
        this.minTileY = n7;
    }

    public Tiler(PlanarImage planarImage) {
        this(planarImage.getTileGridXOffset(), planarImage.getTileGridYOffset(), planarImage.getTileWidth(), planarImage.getTileHeight(), planarImage.getMinTileX(), planarImage.getMaxTileX(), planarImage.getMinTileY(), planarImage.getMaxTileY());
    }

    public Point[] computeTilesExtend(Insets insets, Insets insets2) {
        int n;
        Insets insets3 = this.extendTileRange(insets, insets2);
        if (insets3.right - insets3.left <= insets.right - insets.left && insets3.bottom - insets3.top <= insets.bottom - insets.top) {
            return EMPTY_TILE_ARRAY;
        }
        LinkedList<Point> linkedList = new LinkedList<Point>();
        int n2 = insets3.top;
        while (n2 < insets.top) {
            n = insets3.left;
            while (n <= insets3.right) {
                linkedList.add(new Point(n, n2));
                ++n;
            }
            ++n2;
        }
        if (insets3.right - insets3.left > insets.right - insets.left) {
            n2 = insets.top;
            while (n2 <= insets.bottom) {
                n = insets3.left;
                while (n < insets.left) {
                    linkedList.add(new Point(n, n2));
                    ++n;
                }
                n = insets.right + 1;
                while (n <= insets3.right) {
                    linkedList.add(new Point(n, n2));
                    ++n;
                }
                ++n2;
            }
        }
        n2 = insets.bottom + 1;
        while (n2 <= insets3.bottom) {
            n = insets3.left;
            while (n <= insets3.right) {
                linkedList.add(new Point(n, n2));
                ++n;
            }
            ++n2;
        }
        assert (linkedList.size() > 0);
        return linkedList.toArray(new Point[linkedList.size()]);
    }

    private Insets extendTileRange(Insets insets, Insets insets2) {
        assert (insets != null);
        return new Insets(Math.max(this.minTileY, insets.top - insets2.top), Math.max(this.minTileX, insets.left - insets2.left), Math.min(this.maxTileY, insets.bottom + insets2.bottom), Math.min(this.maxTileX, insets.right + insets2.right));
    }

    public int tileCountX() {
        return this.maxTileX - this.minTileX + 1;
    }

    public int tileCountY() {
        return this.maxTileY - this.minTileY + 1;
    }

    public Insets tilesToPaint(Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        if (rectangle.isEmpty()) {
            throw new IllegalArgumentException("Empty rcPaint " + rectangle);
        }
        int n4 = this.tileXFromPixelX(rectangle.x);
        if (n4 < this.minTileX) {
            n4 = this.minTileX;
        }
        if ((n3 = this.tileYFromPixelY(rectangle.y)) < this.minTileY) {
            n3 = this.minTileY;
        }
        if ((n2 = this.tileXFromPixelX(rectangle.x + rectangle.width - 1)) > this.maxTileX) {
            n2 = this.maxTileX;
        }
        if ((n = this.tileYFromPixelY(rectangle.y + rectangle.height - 1)) > this.maxTileY) {
            n = this.maxTileY;
        }
        return new Insets(n3, n4, n, n2);
    }

    public final Collection<TileIndex> tileToPaint(Rectangle rectangle, Insets insets) {
        Point[] pointArray;
        Insets insets2 = this.tilesToPaint(rectangle);
        Point[] pointArray2 = Tiler.computePointsForIndices(insets2);
        if (pointArray2.length <= 0) {
            return Collections.emptyList();
        }
        LinkedList<TileIndex> linkedList = new LinkedList<TileIndex>();
        Point[] pointArray3 = pointArray2;
        int n = pointArray2.length;
        int n2 = 0;
        while (n2 < n) {
            pointArray = pointArray3[n2];
            linkedList.add(new TileIndex((Point)pointArray, false));
            ++n2;
        }
        if (insets != null) {
            Point[] pointArray4 = pointArray = this.computeTilesExtend(insets2, insets);
            int n3 = pointArray.length;
            n = 0;
            while (n < n3) {
                Point point = pointArray4[n];
                linkedList.add(new TileIndex(point, true));
                ++n;
            }
        }
        return linkedList;
    }

    public int tileXFromPixelX(int n) {
        return PlanarImage.XToTileX(n, this.tileGridXOffset, this.tileWidth);
    }

    public int tileYFromPixelY(int n) {
        return PlanarImage.YToTileY(n, this.tileGridYOffset, this.tileHeight);
    }

    public String toString() {
        return "size=" + this.tileWidth + 'x' + this.tileHeight + ", grid=" + this.tileGridXOffset + "x" + this.tileGridYOffset + ", min=" + this.minTileX + 'x' + this.minTileY + ", max=" + this.maxTileY + 'x' + this.maxTileX;
    }

    static final class TileIndex
    implements ToString.IToStringSimple {
        public final boolean isExtend;
        public final int x;
        public final int y;

        TileIndex(int n, int n2, boolean bl) {
            this.x = n;
            this.y = n2;
            this.isExtend = bl;
        }

        TileIndex(Point point, boolean bl) {
            this(point.x, point.y, bl);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            TileIndex tileIndex = (TileIndex)object;
            return this.equalsTo(tileIndex.x, tileIndex.y);
        }

        public boolean equalsTo(int n, int n2) {
            return this.x == n && this.y == n2;
        }

        public boolean equalsTo(Point point) {
            return this.equalsTo(point.x, point.y);
        }

        public Point getLocation() {
            return new Point(this.x, this.y);
        }

        public int hashCode() {
            int n = this.x;
            n = 31 * n + this.y;
            return n;
        }

        public String toString() {
            return String.valueOf(this.x) + "x" + this.y + (this.isExtend ? "[Ext]" : "");
        }
    }
}

