/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal;

import com.deltawalker.image.internal.Context;
import com.deltawalker.image.internal.ITileList;
import com.deltawalker.image.internal.Scale;
import com.deltawalker.image.internal.Tile;
import com.deltawalker.image.internal.Tiler;
import com.deltawalker.image.internal.common.ImageUtil;
import com.deltopia.util.logging.ToString;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.util.Collection;
import java.util.Iterator;
import javax.media.jai.PlanarImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TileList
implements ITileList {
    private static final Logger LOG = LoggerFactory.getLogger((String)"com.deltawalker.image.internal.TileList");
    private static final boolean CHECK_RECTS = false;
    private final Context context;
    private final Scale scaleImage2Context;
    private final Rectangle rcReqImage;
    private final PlanarImage image;
    private final Collection<Tiler.TileIndex> listTileIndex;
    private final Iterator<Tiler.TileIndex> it;
    private int pos;

    static final void fixRectangle(Rectangle rectangle, Scale scale) {
        if (rectangle.isEmpty() && scale.compareTo(Scale.NO) > 0) {
            if (rectangle.width == 0) {
                rectangle.width = 1;
            }
            if (rectangle.height == 0) {
                rectangle.height = 1;
            }
        }
    }

    TileList(Context context, Scale scale, Rectangle rectangle, PlanarImage planarImage, Collection<Tiler.TileIndex> collection) throws NullPointerException, IllegalArgumentException {
        if (collection.size() <= 0) {
            throw new IllegalArgumentException("listTileIndex <= 0");
        }
        this.context = context;
        this.scaleImage2Context = scale;
        this.rcReqImage = rectangle;
        this.image = planarImage;
        this.listTileIndex = collection;
        this.it = collection.iterator();
        this.pos = 0;
    }

    @Override
    public Context context() {
        return this.context;
    }

    private ColorModel getColorModel() {
        return this.image.getColorModel();
    }

    @Override
    public boolean hasNextTile() {
        return this.it.hasNext();
    }

    @Override
    public Tile nextTile() throws IndexOutOfBoundsException {
        if (!this.it.hasNext()) {
            throw new IndexOutOfBoundsException("No more tiles: " + this.pos + '/' + this.listTileIndex.size());
        }
        Tiler.TileIndex tileIndex = this.it.next();
        Raster raster = this.image.getTile(tileIndex.x, tileIndex.y);
        Rectangle rectangle = raster.getBounds();
        Rectangle rectangle2 = rectangle.intersection(this.rcReqImage);
        Rectangle rectangle3 = this.scaleImage2Context.multiply(rectangle2);
        Point point = this.context.getOrigin();
        rectangle3.translate(point.x, point.y);
        rectangle2.translate(-rectangle.x, -rectangle.y);
        Tile tile = new Tile(raster, this.getColorModel(), rectangle2, rectangle3, this.context, tileIndex.getLocation());
        if (LOG.isInfoEnabled()) {
            LOG.info(new ToString().append("Returns tile", (Object)tile).append(", on", (Object)tileIndex).append(", context", (Object)this.context).appendID(" of image", (Object)this.image).toString());
        }
        ++this.pos;
        return tile;
    }

    @Override
    public boolean shouldPaintBackground() {
        return ImageUtil.hasTransparency(this.getColorModel());
    }

    public String toString() {
        return "context=" + this.context + ", scale=" + this.scaleImage2Context + ", rectImage=" + this.rcReqImage + ", image=" + this.image + ", indexes=" + this.listTileIndex + ", pos=" + this.pos;
    }
}

