/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal;

import com.deltawalker.image.internal.Context;
import com.deltopia.util.logging.ToString;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;

public final class Tile {
    private final ColorModel colorModel;
    private final Point index;
    private final Raster raster;
    private final Rectangle rectContext;
    private final Rectangle rectImage;
    private final Context context;

    Tile(Raster raster, ColorModel colorModel, Rectangle rectangle, Rectangle rectangle2, Context context, Point point) throws NullPointerException {
        assert (rectangle != null);
        assert (rectangle2 != null);
        assert (raster != null);
        assert (context != null);
        assert (point != null);
        this.raster = raster;
        this.colorModel = colorModel;
        this.rectImage = rectangle;
        this.rectContext = rectangle2;
        this.context = context;
        this.index = point;
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public final Point getIndex() {
        return this.index;
    }

    public Point getOrigin() {
        return this.context.getOrigin();
    }

    public Raster getRaster() {
        return this.raster;
    }

    public Rectangle getRectContext() {
        return this.rectContext.getBounds();
    }

    public Rectangle getRectContext(Point point) {
        Point point2 = point.getLocation();
        Point point3 = this.context.getOrigin();
        point2.translate(-point3.x, -point3.y);
        Rectangle rectangle = this.rectContext.getBounds();
        if (point2.x == 0 && point2.y == 0) {
            return rectangle;
        }
        rectangle.translate(point2.x, point2.y);
        return rectangle.intersection(this.rectContext);
    }

    public Rectangle getRectImage() {
        return this.rectImage.getBounds();
    }

    public String toString() {
        return new ToString().append("rectImage", this.rectImage).append(", rectContext", this.rectContext).append(", origin", this.context.getOrigin()).append(", hasRaster", this.raster != null).toString();
    }
}

