/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal;

import com.deltawalker.image.internal.BaseImageSource;
import com.deltawalker.image.internal.Context;
import com.deltawalker.image.internal.IDataProvider;
import com.deltawalker.image.internal.common.ImageOpUtil;
import java.io.IOException;
import javax.media.jai.PlanarImage;

final class SingleImageSource
extends BaseImageSource {
    private PlanarImage imageFull;

    public SingleImageSource(IDataProvider iDataProvider) throws IOException {
        super(iDataProvider);
        this.loader.setTileWidth(this.info.width);
        this.loader.setTileHeight(this.info.height);
        this.imageFull = this.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PlanarImage bestImage(Context context) {
        PlanarImage planarImage;
        SingleImageSource singleImageSource = this;
        synchronized (singleImageSource) {
            planarImage = this.imageFull;
        }
        if (planarImage == null) {
            throw new IllegalStateException("Already disposed");
        }
        return planarImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        PlanarImage planarImage;
        SingleImageSource singleImageSource = this;
        synchronized (singleImageSource) {
            planarImage = this.imageFull;
            this.imageFull = null;
        }
        if (planarImage != null) {
            ImageOpUtil.disposePlanarImageChain(planarImage);
        }
    }
}

