/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal;

import com.deltawalker.image.internal.Scale;
import java.math.RoundingMode;

final class ScaleRational
extends Scale {
    private static final int COEFF = 10000;
    private static final ScaleRational NO_SCALE = new ScaleRational(1, 1);
    private final int numerator;
    private final int denominator;

    static Scale createInt(double d) {
        double d2 = d * 10000.0;
        if (d2 > 2.147483647E9) {
            throw new IllegalArgumentException("Too high value: " + d2);
        }
        int n = (int)Math.round(d2);
        return ScaleRational.createInt(n, 10000);
    }

    private static final ScaleRational createInt(int n, int n2) {
        if (n == 1 && n2 == 1) {
            return NO_SCALE;
        }
        return new ScaleRational(n, n2);
    }

    static final ScaleRational createInt(int n, int n2, int n3, int n4) {
        ScaleRational scaleRational;
        ScaleRational scaleRational2 = ScaleRational.createInt(n3, n);
        return scaleRational2.compareTo(scaleRational = ScaleRational.createInt(n4, n2)) < 0 ? scaleRational2 : scaleRational;
    }

    private ScaleRational(int n, int n2) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Numerator is negative");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Denominator is not positive");
        }
        this.numerator = n;
        this.denominator = n2;
    }

    @Override
    public int compareTo(Scale scale) {
        ScaleRational scaleRational = (ScaleRational)scale;
        long l = (long)this.numerator * (long)scaleRational.denominator;
        long l2 = (long)this.denominator * (long)scaleRational.numerator;
        int n = l < l2 ? -1 : (l > l2 ? 1 : 0);
        return n;
    }

    @Override
    public double getValueAsDouble() {
        return (double)this.numerator / (double)this.denominator;
    }

    @Override
    public int hashCode() {
        int n = this.numerator;
        n = 31 * n + this.denominator;
        return n;
    }

    @Override
    int scaleInt(int n, boolean bl, RoundingMode roundingMode) {
        int n2;
        switch (roundingMode) {
            case FLOOR: {
                if (bl) {
                    n2 = (int)Math.floor((double)n * (double)this.denominator / (double)this.numerator);
                    break;
                }
                n2 = (int)Math.floor((double)n * (double)this.numerator / (double)this.denominator);
                break;
            }
            case CEILING: {
                if (bl) {
                    n2 = (int)Math.ceil((double)n * (double)this.denominator / (double)this.numerator);
                    break;
                }
                n2 = (int)Math.ceil((double)n * (double)this.numerator / (double)this.denominator);
                break;
            }
            case HALF_UP: {
                if (bl) {
                    n2 = (int)Math.round((double)n * (double)this.denominator / (double)this.numerator);
                    break;
                }
                n2 = (int)Math.round((double)n * (double)this.numerator / (double)this.denominator);
                break;
            }
            default: {
                throw new IllegalArgumentException("mode: " + (Object)((Object)roundingMode));
            }
        }
        return n2;
    }

    @Override
    Scale scaleInt(Scale scale, boolean bl) {
        long l;
        long l2;
        ScaleRational scaleRational = (ScaleRational)scale;
        if (bl) {
            l2 = this.numerator * scaleRational.denominator;
            l = this.denominator * scaleRational.numerator;
        } else {
            l2 = this.numerator * scaleRational.numerator;
            l = this.denominator * scaleRational.denominator;
        }
        if (l2 <= 0L || l <= 0L || l2 > Integer.MAX_VALUE || l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("New scale coefficient is out of range " + this + (bl ? (char)'/' : '*') + scale);
        }
        return ScaleRational.createInt((int)l2, (int)l);
    }

    public String toString() {
        if (this.denominator == 1) {
            return String.valueOf(this.numerator);
        }
        return String.format("%d/%d [%.5f]", this.numerator, this.denominator, this.getValueAsDouble());
    }
}

