/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal;

import com.deltawalker.image.internal.Scale;
import com.deltawalker.image.internal.common.GeomUtil;
import com.deltopia.MathUtil;
import java.math.RoundingMode;

final class ScaleDouble
extends Scale {
    private static final ScaleDouble NO_SCALE = new ScaleDouble(1.0);
    private final double value;

    static Scale createInt(double d) {
        if (Double.compare(d, 0.0) == 0) {
            return NO_SCALE;
        }
        return new ScaleDouble(d);
    }

    static Scale createInt(int n, int n2, int n3, int n4) throws IllegalArgumentException {
        double d = GeomUtil.computeScaleFit(n, n2, n3, n4);
        return ScaleDouble.createInt(d);
    }

    private ScaleDouble(double d) throws IllegalArgumentException {
        if (!MathUtil.isDetermined((double)d)) {
            throw new IllegalArgumentException("Not-determined value " + d);
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("Not positive value " + d);
        }
        this.value = d;
    }

    @Override
    public int compareTo(Scale scale) {
        ScaleDouble scaleDouble = (ScaleDouble)scale;
        return Double.compare(this.value, scaleDouble.value);
    }

    @Override
    public double getValueAsDouble() {
        return this.value;
    }

    @Override
    public int hashCode() {
        long l = this.value != 0.0 ? Double.doubleToLongBits(this.value) : 0L;
        return (int)(l ^ l >>> 32);
    }

    @Override
    int scaleInt(int n, boolean bl, RoundingMode roundingMode) {
        int n2;
        double d = bl ? (double)n / this.value : (double)n * this.value;
        switch (roundingMode) {
            case FLOOR: {
                n2 = (int)Math.floor(d);
                break;
            }
            case CEILING: {
                n2 = (int)Math.ceil(d);
                break;
            }
            case HALF_UP: {
                n2 = (int)Math.round(d);
                break;
            }
            default: {
                throw new IllegalArgumentException("mode: " + (Object)((Object)roundingMode));
            }
        }
        return n2;
    }

    @Override
    Scale scaleInt(Scale scale, boolean bl) {
        if (bl) {
            return ScaleDouble.create(this.value / ((ScaleDouble)scale).value);
        }
        return ScaleDouble.create(this.value * ((ScaleDouble)scale).value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

