/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal;

import com.deltawalker.image.internal.Scale;
import java.math.BigDecimal;
import java.math.RoundingMode;

final class ScaleBigDecimal
extends Scale {
    private static final ScaleBigDecimal NO_SCALE = new ScaleBigDecimal(BigDecimal.ONE);
    private final BigDecimal value;

    private static final BigDecimal createBI(int n) {
        return BigDecimal.valueOf(n);
    }

    private static final ScaleBigDecimal createInt(BigDecimal bigDecimal) {
        if (bigDecimal.equals(BigDecimal.ONE)) {
            return NO_SCALE;
        }
        return new ScaleBigDecimal(bigDecimal);
    }

    static ScaleBigDecimal createInt(double d) {
        BigDecimal bigDecimal = BigDecimal.valueOf(d);
        return ScaleBigDecimal.createInt(bigDecimal);
    }

    static ScaleBigDecimal createInt(int n, int n2, int n3, int n4) {
        BigDecimal bigDecimal;
        if (n == 1 && n3 == 1 && n2 == 1 && n4 == 1) {
            return NO_SCALE;
        }
        BigDecimal bigDecimal2 = ScaleBigDecimal.scaleInt(n3, n, true, RoundingMode.HALF_UP);
        return ScaleBigDecimal.createInt(bigDecimal2.compareTo(bigDecimal = ScaleBigDecimal.scaleInt(n4, n2, true, RoundingMode.HALF_UP)) < 0 ? bigDecimal2 : bigDecimal);
    }

    private static final BigDecimal scaleInt(BigDecimal bigDecimal, BigDecimal bigDecimal2, boolean bl, RoundingMode roundingMode) {
        if (bigDecimal2.equals(BigDecimal.ZERO)) {
            throw new IllegalArgumentException("zero coefficient");
        }
        BigDecimal bigDecimal3 = bl ? bigDecimal.divide(bigDecimal2, 32, roundingMode) : bigDecimal.multiply(bigDecimal2);
        return bigDecimal3;
    }

    private static final BigDecimal scaleInt(int n, int n2, boolean bl, RoundingMode roundingMode) {
        BigDecimal bigDecimal = ScaleBigDecimal.createBI(n);
        BigDecimal bigDecimal2 = ScaleBigDecimal.createBI(n2);
        return ScaleBigDecimal.scaleInt(bigDecimal, bigDecimal2, bl, roundingMode);
    }

    private ScaleBigDecimal(BigDecimal bigDecimal) throws IllegalArgumentException {
        if (bigDecimal.signum() <= 0) {
            throw new IllegalArgumentException("Not positive value " + bigDecimal);
        }
        this.value = bigDecimal;
    }

    @Override
    public int compareTo(Scale scale) {
        return this.value.compareTo(((ScaleBigDecimal)scale).value);
    }

    @Override
    public double getValueAsDouble() {
        return this.value.doubleValue();
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    int scaleInt(int n, boolean bl, RoundingMode roundingMode) {
        BigDecimal bigDecimal = ScaleBigDecimal.createBI(n);
        BigDecimal bigDecimal2 = ScaleBigDecimal.scaleInt(bigDecimal, this.value, bl, roundingMode);
        int n2 = bigDecimal2.intValue();
        return n2;
    }

    @Override
    Scale scaleInt(Scale scale, boolean bl) {
        if (bl) {
            return ScaleBigDecimal.createInt(this.value.divide(((ScaleBigDecimal)scale).value));
        }
        return ScaleBigDecimal.createInt(this.value.multiply(((ScaleBigDecimal)scale).value));
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

