/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.image.internal;

import com.deltawalker.image.internal.ImageInfo;
import com.deltawalker.image.internal.ScaleBigDecimal;
import com.deltawalker.image.internal.ScaleDouble;
import com.deltawalker.image.internal.ScaleRational;
import com.deltawalker.image.internal.common.GeomUtil;
import com.deltopia.MathUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.math.RoundingMode;

public abstract class Scale
implements Comparable<Scale> {
    private static final int SCALE_DOUBLE = 1;
    private static final int SCALE_BIG_DECIMAL = 2;
    private static final int SCALE_RATIONAL = 3;
    private static final int SCALE = 3;
    public static final Scale NO = Scale.create(1, 1, 1, 1);

    public static final Scale create(double d) throws IllegalArgumentException {
        Scale scale;
        if (!MathUtil.isDetermined((double)d)) {
            throw new IllegalArgumentException("Not-determined value " + d);
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("Not positive value " + d);
        }
        switch (3) {
            case 1: {
                scale = ScaleDouble.createInt(d);
                break;
            }
            case 2: {
                scale = ScaleBigDecimal.createInt(d);
                break;
            }
            case 3: {
                scale = ScaleRational.createInt(d);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return scale;
    }

    public static final Scale create(int n, int n2) throws IllegalArgumentException {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Invalid sizes: " + n + '/' + n2);
        }
        return Scale.create(n, n2, n, n2);
    }

    public static final Scale create(int n, int n2, int n3, int n4) throws IllegalArgumentException {
        Scale scale;
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Invalid input size " + n + 'x' + n2);
        }
        if (n3 <= 0 || n4 <= 0) {
            throw new IllegalArgumentException("Invalid output size " + n3 + 'x' + n4);
        }
        switch (3) {
            case 1: {
                scale = ScaleDouble.createInt(n, n2, n3, n4);
                break;
            }
            case 2: {
                scale = ScaleBigDecimal.createInt(n, n2, n3, n4);
                break;
            }
            case 3: {
                scale = ScaleRational.createInt(n, n2, n3, n4);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return scale;
    }

    public static final Scale create(RenderedImage renderedImage, ImageInfo imageInfo) throws IllegalArgumentException {
        if (imageInfo == null) {
            throw new NullPointerException("descriptor");
        }
        if (renderedImage == null) {
            throw new NullPointerException("image");
        }
        return Scale.create(imageInfo.width, imageInfo.height, renderedImage.getWidth(), renderedImage.getHeight());
    }

    public final Dimension divide(Dimension dimension) {
        return this.scale(dimension, true);
    }

    public final Point divide(Point point) {
        return this.scale(point, true);
    }

    public final Rectangle divide(Rectangle rectangle) {
        return this.scale(rectangle, true);
    }

    public final Scale divide(Scale scale) throws NullPointerException {
        if (scale == null) {
            throw new NullPointerException("scale");
        }
        return this.scaleInt(scale, true);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Scale scale = (Scale)object;
        return this.compareTo(scale) == 0;
    }

    public abstract double getValueAsDouble();

    public int hashCode() {
        long l = Double.doubleToLongBits(this.getValueAsDouble());
        return (int)(l ^ l >>> 32);
    }

    public final boolean isIdentity() {
        return this.compareTo(NO) == 0;
    }

    public final Dimension multiply(Dimension dimension) {
        return this.scale(dimension, false);
    }

    public final Point multiply(Point point) {
        return this.scale(point, false);
    }

    public final Rectangle multiply(Rectangle rectangle) {
        return this.scale(rectangle, false);
    }

    public final Scale multiply(Scale scale) {
        return this.scaleInt(scale, false);
    }

    private final Dimension scale(Dimension dimension, boolean bl) throws IllegalArgumentException {
        if (GeomUtil.isEmpty(dimension)) {
            throw new IllegalArgumentException("Empty size: " + dimension);
        }
        int n = this.scaleInt(dimension.width, bl);
        int n2 = this.scaleInt(dimension.height, bl);
        return new Dimension(n, n2);
    }

    private final Point scale(Point point, boolean bl) {
        int n = this.scaleInt(point.x, bl);
        int n2 = this.scaleInt(point.y, bl);
        return new Point(n, n2);
    }

    protected Rectangle scale(Rectangle rectangle, boolean bl) {
        if (rectangle.isEmpty()) {
            throw new IllegalArgumentException("Empty rect: " + rectangle);
        }
        int n = this.scaleInt(rectangle.x, bl, RoundingMode.FLOOR);
        int n2 = this.scaleInt(rectangle.y, bl, RoundingMode.FLOOR);
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle.y + rectangle.height;
        int n5 = this.scaleInt(n3, bl, RoundingMode.CEILING) - n;
        int n6 = this.scaleInt(n4, bl, RoundingMode.CEILING) - n2;
        return new Rectangle(n, n2, n5, n6);
    }

    final int scaleInt(int n, boolean bl) {
        return this.scaleInt(n, bl, RoundingMode.HALF_UP);
    }

    abstract int scaleInt(int var1, boolean var2, RoundingMode var3);

    abstract Scale scaleInt(Scale var1, boolean var2);
}

